/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.Util;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.Aggregator;
import org.rrd4j.data.Source;

class Def
extends Source {
    private final String path;
    private final String dsName;
    private final String backend;
    private final ConsolFun consolFun;
    private FetchData fetchData;

    Def(String name, FetchData fetchData) {
        this(name, name, fetchData);
    }

    Def(String name, String dsName, FetchData fetchData) {
        this(name, fetchData.getRequest().getParentDb().getPath(), dsName, fetchData.getRequest().getConsolFun(), fetchData.getRequest().getParentDb().getRrdBackend().getFactory().getName());
        this.fetchData = fetchData;
    }

    Def(String name, String path, String dsName, ConsolFun consolFunc) {
        this(name, path, dsName, consolFunc, null);
    }

    Def(String name, String path, String dsName, ConsolFun consolFunc, String backend) {
        super(name);
        this.path = path;
        this.dsName = dsName;
        this.consolFun = consolFunc;
        this.backend = backend;
    }

    String getPath() {
        return this.path;
    }

    String getCanonicalPath() throws IOException {
        return Util.getCanonicalPath(this.path);
    }

    String getDsName() {
        return this.dsName;
    }

    ConsolFun getConsolFun() {
        return this.consolFun;
    }

    String getBackend() {
        return this.backend;
    }

    boolean isCompatibleWith(Def def) throws IOException {
        return this.getCanonicalPath().equals(def.getCanonicalPath()) && this.getConsolFun() == def.consolFun && (this.backend == null && def.backend == null || this.backend != null && def.backend != null && this.backend.equals(def.backend));
    }

    void setFetchData(FetchData fetchData) {
        this.fetchData = fetchData;
    }

    long[] getRrdTimestamps() {
        return this.fetchData.getTimestamps();
    }

    double[] getRrdValues() {
        return this.fetchData.getValues(this.dsName);
    }

    long getArchiveEndTime() {
        return this.fetchData.getArcEndTime();
    }

    long getFetchStep() {
        return this.fetchData.getStep();
    }

    @Override
    Aggregates getAggregates(long tStart, long tEnd) {
        long[] t = this.getRrdTimestamps();
        double[] v = this.getRrdValues();
        return new Aggregator(t, v).getAggregates(tStart, tEnd);
    }

    @Override
    double getPercentile(long tStart, long tEnd, double percentile) {
        long[] t = this.getRrdTimestamps();
        double[] v = this.getRrdValues();
        return new Aggregator(t, v).getPercentile(tStart, tEnd, percentile);
    }

    boolean isLoaded() {
        return this.fetchData != null;
    }
}

