/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.objenesis.strategy;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.hive.org.objenesis.ObjenesisException;
import org.apache.hive.org.objenesis.instantiator.ObjectInstantiator;
import org.apache.hive.org.objenesis.instantiator.android.AndroidSerializationInstantiator;
import org.apache.hive.org.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import org.apache.hive.org.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import org.apache.hive.org.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import org.apache.hive.org.objenesis.instantiator.perc.PercSerializationInstantiator;
import org.apache.hive.org.objenesis.instantiator.sun.SunReflectionFactorySerializationInstantiator;
import org.apache.hive.org.objenesis.strategy.BaseInstantiatorStrategy;
import org.apache.hive.org.objenesis.strategy.PlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine()) {
                return new ObjectInputStreamInstantiator<T>(type);
            }
            if (PlatformDescription.SPECIFICATION_VERSION.equals("9")) {
                return new SunReflectionFactorySerializationInstantiator<T>(type);
            }
            return new ObjectStreamClassInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new ObjectStreamClassInstantiator<T>(type);
    }
}

