/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDecimalInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FilterDecimalColumnInList
extends VectorExpression
implements IDecimalInExpr {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private HiveDecimal[] inListValues;
    private transient HashSet<HiveDecimal> inSet;

    public FilterDecimalColumnInList() {
        this.inSet = null;
    }

    public FilterDecimalColumnInList(int colNum) {
        this.inputCol = colNum;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new HashSet(this.inListValues.length);
            for (HiveDecimal val : this.inListValues) {
                this.inSet.add(val);
            }
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.inputCol];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.inSet.contains(vector[0].getHiveDecimal())) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.inSet.contains(vector[i].getHiveDecimal())) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.inSet.contains(vector[i].getHiveDecimal())) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.inSet.contains(vector[0].getHiveDecimal())) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.inSet.contains(vector[i].getHiveDecimal())) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.inSet.contains(vector[i].getHiveDecimal())) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setInListValues(HiveDecimal[] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputCol + ", values " + Arrays.toString(this.inListValues);
    }
}

