/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedBatchUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedBatchUtil.class);

    public static void setNullColIsNullValue(ColumnVector cv, int rowIndex) {
        cv.isNull[rowIndex] = true;
        if (cv.noNulls) {
            cv.noNulls = false;
        }
    }

    public static void setRepeatingColumn(VectorizedRowBatch batch, int column) {
        ColumnVector cv = batch.cols[column];
        cv.isRepeating = true;
    }

    public static void setBatchSize(VectorizedRowBatch batch, int size) {
        assert (size <= batch.getMaxSize());
        batch.size = size;
    }

    public static ColumnVector createColumnVector(String typeName) {
        if ((typeName = typeName.toLowerCase()).equals("char") || typeName.equals("varchar")) {
            return new BytesColumnVector(1024);
        }
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeName);
        return VectorizedBatchUtil.createColumnVector(typeInfo);
    }

    public static ColumnVector createColumnVector(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case DATE: 
                    case INTERVAL_YEAR_MONTH: {
                        return new LongColumnVector(1024);
                    }
                    case TIMESTAMP: {
                        return new TimestampColumnVector(1024);
                    }
                    case INTERVAL_DAY_TIME: {
                        return new IntervalDayTimeColumnVector(1024);
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new DoubleColumnVector(1024);
                    }
                    case BINARY: 
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        return new BytesColumnVector(1024);
                    }
                    case DECIMAL: {
                        DecimalTypeInfo tInfo = (DecimalTypeInfo)primitiveTypeInfo;
                        return new DecimalColumnVector(1024, tInfo.precision(), tInfo.scale());
                    }
                }
                throw new RuntimeException("Vectorizaton is not supported for datatype:" + (Object)((Object)primitiveTypeInfo.getPrimitiveCategory()));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<TypeInfo> typeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
                ColumnVector[] children = new ColumnVector[typeInfoList.size()];
                for (int i = 0; i < children.length; ++i) {
                    children[i] = VectorizedBatchUtil.createColumnVector((TypeInfo)typeInfoList.get(i));
                }
                return new StructColumnVector(1024, children);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List<TypeInfo> typeInfoList = unionTypeInfo.getAllUnionObjectTypeInfos();
                ColumnVector[] children = new ColumnVector[typeInfoList.size()];
                for (int i = 0; i < children.length; ++i) {
                    children[i] = VectorizedBatchUtil.createColumnVector(typeInfoList.get(i));
                }
                return new UnionColumnVector(1024, children);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                return new ListColumnVector(1024, VectorizedBatchUtil.createColumnVector(listTypeInfo.getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                return new MapColumnVector(1024, VectorizedBatchUtil.createColumnVector(mapTypeInfo.getMapKeyTypeInfo()), VectorizedBatchUtil.createColumnVector(mapTypeInfo.getMapValueTypeInfo()));
            }
        }
        throw new RuntimeException("Vectorization is not supported for datatype:" + (Object)((Object)typeInfo.getCategory()));
    }

    public static void addRowToBatchFrom(Object row, StructObjectInspector oi, int rowIndex, int colOffset, VectorizedRowBatch batch, DataOutputBuffer buffer) throws HiveException {
        List<? extends StructField> fieldRefs = oi.getAllStructFieldRefs();
        int off = colOffset;
        for (int i = 0; i < fieldRefs.size(); ++i) {
            VectorizedBatchUtil.setVector(row, oi, fieldRefs.get(i), batch, buffer, rowIndex, i, off);
        }
    }

    public static void addProjectedRowToBatchFrom(Object row, StructObjectInspector oi, int rowIndex, VectorizedRowBatch batch, DataOutputBuffer buffer) throws HiveException {
        List<? extends StructField> fieldRefs = oi.getAllStructFieldRefs();
        for (int i = 0; i < fieldRefs.size(); ++i) {
            int projectedOutputCol = batch.projectedColumns[i];
            if (batch.cols[projectedOutputCol] == null) continue;
            VectorizedBatchUtil.setVector(row, oi, fieldRefs.get(i), batch, buffer, rowIndex, projectedOutputCol, 0);
        }
    }

    public static void acidAddRowToBatch(Object row, StructObjectInspector oi, int rowIndex, VectorizedRowBatch batch, VectorizedRowBatchCtx context, DataOutputBuffer buffer) throws HiveException {
        List<? extends StructField> fieldRefs = oi.getAllStructFieldRefs();
        for (int i = 0; i < fieldRefs.size(); ++i) {
            if (batch.cols[i] == null || context.isPartitionCol(i)) continue;
            VectorizedBatchUtil.setVector(row, oi, fieldRefs.get(i), batch, buffer, rowIndex, i, 0);
        }
    }

    private static void setVector(Object row, StructObjectInspector oi, StructField field, VectorizedRowBatch batch, DataOutputBuffer buffer, int rowIndex, int colIndex, int offset) throws HiveException {
        Object fieldData = oi.getStructFieldData(row, field);
        ObjectInspector foi = field.getFieldObjectInspector();
        assert (foi.getCategory() == ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)foi;
        Object writableCol = poi.getPrimitiveWritableObject(fieldData);
        switch (poi.getPrimitiveCategory()) {
            case BOOLEAN: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((BooleanWritable)writableCol).get() ? 1L : 0L;
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case BYTE: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((ByteWritable)((Object)writableCol)).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case SHORT: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((ShortWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case INT: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((IntWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case LONG: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((LongWritable)writableCol).get();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case DATE: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.vector[rowIndex] = ((DateWritable)writableCol).getDays();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case FLOAT: {
                DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    dcv.vector[rowIndex] = ((FloatWritable)writableCol).get();
                    dcv.isNull[rowIndex] = false;
                    break;
                }
                dcv.vector[rowIndex] = Double.NaN;
                VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                break;
            }
            case DOUBLE: {
                DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    dcv.vector[rowIndex] = ((DoubleWritable)((Object)writableCol)).get();
                    dcv.isNull[rowIndex] = false;
                    break;
                }
                dcv.vector[rowIndex] = Double.NaN;
                VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                break;
            }
            case TIMESTAMP: {
                TimestampColumnVector lcv = (TimestampColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    lcv.set(rowIndex, ((TimestampWritable)writableCol).getTimestamp());
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.setNullValue(rowIndex);
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                LongColumnVector lcv = (LongColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    HiveIntervalYearMonth i = ((HiveIntervalYearMonthWritable)writableCol).getHiveIntervalYearMonth();
                    lcv.vector[rowIndex] = i.getTotalMonths();
                    lcv.isNull[rowIndex] = false;
                    break;
                }
                lcv.vector[rowIndex] = 1L;
                VectorizedBatchUtil.setNullColIsNullValue(lcv, rowIndex);
                break;
            }
            case INTERVAL_DAY_TIME: {
                IntervalDayTimeColumnVector icv = (IntervalDayTimeColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    HiveIntervalDayTime idt = ((HiveIntervalDayTimeWritable)writableCol).getHiveIntervalDayTime();
                    icv.set(rowIndex, idt);
                    icv.isNull[rowIndex] = false;
                    break;
                }
                icv.setNullValue(rowIndex);
                VectorizedBatchUtil.setNullColIsNullValue(icv, rowIndex);
                break;
            }
            case BINARY: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    BytesWritable bw = (BytesWritable)writableCol;
                    byte[] bytes = bw.getBytes();
                    int start = buffer.getLength();
                    int length = bw.getLength();
                    try {
                        buffer.write(bytes, 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case STRING: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    Text colText = (Text)writableCol;
                    int start = buffer.getLength();
                    int length = colText.getLength();
                    try {
                        buffer.write(colText.getBytes(), 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case CHAR: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    HiveChar colHiveChar = ((HiveCharWritable)writableCol).getHiveChar();
                    byte[] bytes = colHiveChar.getStrippedValue().getBytes();
                    int length = bytes.length;
                    int start = buffer.getLength();
                    try {
                        buffer.write(bytes, 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case VARCHAR: {
                BytesColumnVector bcv = (BytesColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    bcv.isNull[rowIndex] = false;
                    HiveVarchar colHiveVarchar = ((HiveVarcharWritable)writableCol).getHiveVarchar();
                    byte[] bytes = colHiveVarchar.getValue().getBytes();
                    int length = bytes.length;
                    int start = buffer.getLength();
                    try {
                        buffer.write(bytes, 0, length);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("bad write", ioe);
                    }
                    bcv.setRef(rowIndex, buffer.getData(), start, length);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(bcv, rowIndex);
                break;
            }
            case DECIMAL: {
                DecimalColumnVector dcv = (DecimalColumnVector)batch.cols[offset + colIndex];
                if (writableCol != null) {
                    dcv.isNull[rowIndex] = false;
                    HiveDecimalWritable wobj = (HiveDecimalWritable)writableCol;
                    dcv.set(rowIndex, wobj);
                    break;
                }
                VectorizedBatchUtil.setNullColIsNullValue(dcv, rowIndex);
                break;
            }
            default: {
                throw new HiveException("Vectorizaton is not supported for datatype:" + (Object)((Object)poi.getPrimitiveCategory()));
            }
        }
    }

    public static StandardStructObjectInspector convertToStandardStructObjectInspector(StructObjectInspector structObjectInspector) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        ArrayList<ObjectInspector> oids = new ArrayList<ObjectInspector>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (StructField structField : fields) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName());
            ObjectInspector standardWritableObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
            oids.add(standardWritableObjectInspector);
            columnNames.add(structField.getFieldName());
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, oids);
    }

    public static String[] columnNamesFromStructObjectInspector(StructObjectInspector structObjectInspector) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        String[] result = new String[fields.size()];
        int i = 0;
        for (StructField structField : fields) {
            result[i++] = structField.getFieldName();
        }
        return result;
    }

    public static TypeInfo[] typeInfosFromTypeNames(String[] typeNames) throws HiveException {
        ArrayList<TypeInfo> typeInfoList = TypeInfoUtils.typeInfosFromTypeNames(Arrays.asList(typeNames));
        return typeInfoList.toArray(new TypeInfo[0]);
    }

    public static TypeInfo[] typeInfosFromStructObjectInspector(StructObjectInspector structObjectInspector) {
        ArrayList<TypeInfo> typeInfoList = TypeInfoUtils.typeInfosFromStructObjectInspector(structObjectInspector);
        return typeInfoList.toArray(new TypeInfo[0]);
    }

    static ColumnVector cloneColumnVector(ColumnVector source) throws HiveException {
        if (source instanceof LongColumnVector) {
            return new LongColumnVector(((LongColumnVector)source).vector.length);
        }
        if (source instanceof DoubleColumnVector) {
            return new DoubleColumnVector(((DoubleColumnVector)source).vector.length);
        }
        if (source instanceof BytesColumnVector) {
            return new BytesColumnVector(((BytesColumnVector)source).vector.length);
        }
        if (source instanceof DecimalColumnVector) {
            DecimalColumnVector decColVector = (DecimalColumnVector)source;
            return new DecimalColumnVector(decColVector.vector.length, decColVector.precision, decColVector.scale);
        }
        if (source instanceof TimestampColumnVector) {
            return new TimestampColumnVector(((TimestampColumnVector)source).getLength());
        }
        if (source instanceof IntervalDayTimeColumnVector) {
            return new IntervalDayTimeColumnVector(((IntervalDayTimeColumnVector)source).getLength());
        }
        if (source instanceof ListColumnVector) {
            ListColumnVector src = (ListColumnVector)source;
            ColumnVector child = VectorizedBatchUtil.cloneColumnVector(src.child);
            return new ListColumnVector(src.offsets.length, child);
        }
        if (source instanceof MapColumnVector) {
            MapColumnVector src = (MapColumnVector)source;
            ColumnVector keys = VectorizedBatchUtil.cloneColumnVector(src.keys);
            ColumnVector values = VectorizedBatchUtil.cloneColumnVector(src.values);
            return new MapColumnVector(src.offsets.length, keys, values);
        }
        if (source instanceof StructColumnVector) {
            StructColumnVector src = (StructColumnVector)source;
            ColumnVector[] copy = new ColumnVector[src.fields.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = VectorizedBatchUtil.cloneColumnVector(src.fields[i]);
            }
            return new StructColumnVector(1024, copy);
        }
        if (source instanceof UnionColumnVector) {
            UnionColumnVector src = (UnionColumnVector)source;
            ColumnVector[] copy = new ColumnVector[src.fields.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = VectorizedBatchUtil.cloneColumnVector(src.fields[i]);
            }
            return new UnionColumnVector(src.tags.length, copy);
        }
        throw new HiveException("Column vector class " + source.getClass().getName() + " is not supported!");
    }

    public static VectorizedRowBatch makeLike(VectorizedRowBatch batch) throws HiveException {
        VectorizedRowBatch newBatch = new VectorizedRowBatch(batch.numCols);
        for (int i = 0; i < batch.numCols; ++i) {
            if (batch.cols[i] == null) continue;
            newBatch.cols[i] = VectorizedBatchUtil.cloneColumnVector(batch.cols[i]);
            newBatch.cols[i].init();
        }
        newBatch.projectedColumns = Arrays.copyOf(batch.projectedColumns, batch.projectedColumns.length);
        newBatch.projectionSize = batch.projectionSize;
        newBatch.reset();
        return newBatch;
    }

    public static Writable getPrimitiveWritable(TypeInfo typeInfo) {
        return VectorizedBatchUtil.getPrimitiveWritable(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
    }

    public static Writable getPrimitiveWritable(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case VOID: {
                return null;
            }
            case BOOLEAN: {
                return new BooleanWritable(false);
            }
            case BYTE: {
                return new ByteWritable(0);
            }
            case SHORT: {
                return new ShortWritable(0);
            }
            case INT: {
                return new IntWritable(0);
            }
            case LONG: {
                return new LongWritable(0L);
            }
            case TIMESTAMP: {
                return new TimestampWritable(new Timestamp(0L));
            }
            case DATE: {
                return new DateWritable(new Date(0L));
            }
            case FLOAT: {
                return new FloatWritable(0.0f);
            }
            case DOUBLE: {
                return new DoubleWritable(0.0);
            }
            case BINARY: {
                return new BytesWritable(ArrayUtils.EMPTY_BYTE_ARRAY);
            }
            case STRING: {
                return new Text(ArrayUtils.EMPTY_BYTE_ARRAY);
            }
            case VARCHAR: {
                return new HiveVarcharWritable(new HiveVarchar("", -1));
            }
            case CHAR: {
                return new HiveCharWritable(new HiveChar("", -1));
            }
            case DECIMAL: {
                return new HiveDecimalWritable();
            }
            case INTERVAL_YEAR_MONTH: {
                return new HiveIntervalYearMonthWritable();
            }
            case INTERVAL_DAY_TIME: {
                return new HiveIntervalDayTimeWritable();
            }
        }
        throw new RuntimeException("Primitive category " + primitiveCategory.name() + " not supported");
    }

    public static String displayBytes(byte[] bytes, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            char ch = (char)bytes[i];
            if (ch < ' ' || ch > '~') {
                sb.append(String.format("\\%03d", bytes[i] & 0xFF));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void debugDisplayOneRow(VectorizedRowBatch batch, int index, String prefix) {
        StringBuilder sb = new StringBuilder();
        LOG.info(VectorizedBatchUtil.debugFormatOneRow(batch, index, prefix, sb).toString());
    }

    public static StringBuilder debugFormatOneRow(VectorizedRowBatch batch, int index, String prefix, StringBuilder sb) {
        sb.append(prefix + " row " + index + " ");
        for (int p = 0; p < batch.projectionSize; ++p) {
            int column = batch.projectedColumns[p];
            sb.append("(" + p + "," + column + ") ");
            ColumnVector colVector = batch.cols[column];
            if (colVector == null) {
                sb.append("(null ColumnVector)");
            } else {
                boolean isRepeating = colVector.isRepeating;
                if (isRepeating) {
                    sb.append("(repeating)");
                }
                int n = index = isRepeating ? 0 : index;
                if (colVector.noNulls || !colVector.isNull[index]) {
                    if (colVector instanceof LongColumnVector) {
                        sb.append(((LongColumnVector)colVector).vector[index]);
                    } else if (colVector instanceof DoubleColumnVector) {
                        sb.append(((DoubleColumnVector)colVector).vector[index]);
                    } else if (colVector instanceof BytesColumnVector) {
                        BytesColumnVector bytesColumnVector = (BytesColumnVector)colVector;
                        byte[] bytes = bytesColumnVector.vector[index];
                        int start = bytesColumnVector.start[index];
                        int length = bytesColumnVector.length[index];
                        if (bytes == null) {
                            sb.append("(Unexpected null bytes with start " + start + " length " + length + ")");
                        } else {
                            sb.append("bytes: '" + VectorizedBatchUtil.displayBytes(bytes, start, length) + "'");
                        }
                    } else if (colVector instanceof DecimalColumnVector) {
                        sb.append(((DecimalColumnVector)colVector).vector[index].toString());
                    } else if (colVector instanceof TimestampColumnVector) {
                        Timestamp timestamp = new Timestamp(0L);
                        ((TimestampColumnVector)colVector).timestampUpdate(timestamp, index);
                        sb.append(timestamp.toString());
                    } else if (colVector instanceof IntervalDayTimeColumnVector) {
                        HiveIntervalDayTime intervalDayTime = ((IntervalDayTimeColumnVector)colVector).asScratchIntervalDayTime(index);
                        sb.append(intervalDayTime.toString());
                    } else {
                        sb.append("Unknown");
                    }
                } else {
                    sb.append("NULL");
                }
            }
            sb.append(" ");
        }
        return sb;
    }

    public static void debugDisplayBatch(VectorizedRowBatch batch, String prefix) {
        for (int i = 0; i < batch.size; ++i) {
            int index = batch.selectedInUse ? batch.selected[i] : i;
            VectorizedBatchUtil.debugDisplayOneRow(batch, index, prefix);
        }
    }
}

