/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.generic.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClientDefaultImpl;
import org.apache.sentry.core.common.transport.RetryClientInvocationHandler;
import org.apache.sentry.core.common.transport.SentryClientTransportConfigInterface;
import org.apache.sentry.core.common.transport.SentryConnection;
import org.apache.sentry.core.common.transport.SentryPolicyClientTransportConfig;
import org.apache.sentry.core.common.transport.SentryTransportFactory;
import org.apache.sentry.core.common.transport.SentryTransportPool;
import org.apache.sentry.core.common.transport.TransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SentryGenericServiceClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericServiceClientFactory.class);
    private static final AtomicReference<SentryGenericServiceClientFactory> clientFactory = new AtomicReference();
    private final SentryPolicyClientTransportConfig transportConfig = new SentryPolicyClientTransportConfig();
    private final SentryTransportPool transportPool;
    private final Configuration conf;

    public static SentryGenericServiceClient create(Configuration conf) throws Exception {
        SentryGenericServiceClientFactory factory = clientFactory.get();
        if (factory != null) {
            return factory.create();
        }
        factory = new SentryGenericServiceClientFactory(conf);
        boolean ok = clientFactory.compareAndSet(null, factory);
        if (ok) {
            return factory.create();
        }
        factory.close();
        return clientFactory.get().create();
    }

    private SentryGenericServiceClientFactory(Configuration conf) {
        if (this.transportConfig.isKerberosEnabled(conf) && this.transportConfig.useUserGroupInformation(conf)) {
            LOGGER.info("Using UserGroupInformation authentication");
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
        this.conf = conf;
        this.transportPool = new SentryTransportPool(this.conf, (SentryClientTransportConfigInterface)this.transportConfig, (TransportFactory)new SentryTransportFactory(this.conf, (SentryClientTransportConfigInterface)this.transportConfig));
    }

    private SentryGenericServiceClient create() throws Exception {
        return (SentryGenericServiceClient)Proxy.newProxyInstance(SentryGenericServiceClientDefaultImpl.class.getClassLoader(), SentryGenericServiceClientDefaultImpl.class.getInterfaces(), (InvocationHandler)new RetryClientInvocationHandler(this.conf, (SentryConnection)new SentryGenericServiceClientDefaultImpl(this.conf, this.transportPool), (SentryClientTransportConfigInterface)this.transportConfig));
    }

    public static void factoryReset() {
        LOGGER.debug("factory reset");
        SentryGenericServiceClientFactory factory = clientFactory.getAndSet(null);
        if (factory != null) {
            try {
                factory.transportPool.close();
            }
            catch (Exception e) {
                LOGGER.error("failed to close transport pool", (Throwable)e);
            }
        }
    }

    private void close() {
        try {
            this.transportPool.close();
        }
        catch (Exception e) {
            LOGGER.error("failed to close transport pool", (Throwable)e);
        }
    }
}

