/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.generic.thrift;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.sentry.api.generic.thrift.NotificationHandler;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.api.generic.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.api.generic.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.api.generic.thrift.TDropPrivilegesRequest;
import org.apache.sentry.api.generic.thrift.TDropPrivilegesResponse;
import org.apache.sentry.api.generic.thrift.TDropSentryRoleRequest;
import org.apache.sentry.api.generic.thrift.TDropSentryRoleResponse;
import org.apache.sentry.api.generic.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.api.generic.thrift.TRenamePrivilegesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandlerInvoker
implements NotificationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationHandlerInvoker.class);
    private List<? extends NotificationHandler> handlers = Lists.newArrayList();

    public NotificationHandlerInvoker(List<? extends NotificationHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void create_sentry_role(TCreateSentryRoleRequest request, TCreateSentryRoleResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.create_sentry_role(new TCreateSentryRoleRequest(request), new TCreateSentryRoleResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void drop_sentry_role(TDropSentryRoleRequest request, TDropSentryRoleResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.drop_sentry_role(new TDropSentryRoleRequest(request), new TDropSentryRoleResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_grant_privilege(TAlterSentryRoleGrantPrivilegeRequest request, TAlterSentryRoleGrantPrivilegeResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.alter_sentry_role_grant_privilege(new TAlterSentryRoleGrantPrivilegeRequest(request), new TAlterSentryRoleGrantPrivilegeResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_revoke_privilege(TAlterSentryRoleRevokePrivilegeRequest request, TAlterSentryRoleRevokePrivilegeResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.alter_sentry_role_revoke_privilege(new TAlterSentryRoleRevokePrivilegeRequest(request), new TAlterSentryRoleRevokePrivilegeResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_add_groups(TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.alter_sentry_role_add_groups(new TAlterSentryRoleAddGroupsRequest(request), new TAlterSentryRoleAddGroupsResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_delete_groups(TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.alter_sentry_role_delete_groups(new TAlterSentryRoleDeleteGroupsRequest(request), new TAlterSentryRoleDeleteGroupsResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void drop_sentry_privilege(TDropPrivilegesRequest request, TDropPrivilegesResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.drop_sentry_privilege(new TDropPrivilegesRequest(request), new TDropPrivilegesResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void rename_sentry_privilege(TRenamePrivilegesRequest request, TRenamePrivilegesResponse response) {
        for (NotificationHandler notificationHandler : this.handlers) {
            try {
                LOGGER.debug("Calling " + notificationHandler);
                notificationHandler.rename_sentry_privilege(new TRenamePrivilegesRequest(request), new TRenamePrivilegesResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + notificationHandler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }
}

