/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.common;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.apache.sentry.service.common.SentryOwnerPrivilegeType;

public class ServiceConstants {
    private static final ImmutableMap<String, String> SASL_PROPERTIES;
    public static final String SENTRY_ZK_JAAS_NAME = "Sentry";
    public static final String CURRENT_INCARNATION_ID_KEY = "current.incarnation.key";

    static /* synthetic */ ImmutableMap access$000() {
        return SASL_PROPERTIES;
    }

    static {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        saslProps.put("javax.security.sasl.server.authentication", "true");
        saslProps.put("javax.security.sasl.qop", "auth-conf");
        SASL_PROPERTIES = ImmutableMap.copyOf(saslProps);
    }

    public static enum SentryPrincipalType {
        ROLE,
        USER;

    }

    public static class ClientConfig {
        public static final String SENTRY_EXPORT_IMPORT_DEFAULT_FS = "sentry.export.import.default.fs";
        public static final String SENTRY_EXPORT_IMPORT_DEFAULT_FS_DEFAULT = "file:///";
    }

    public static class ServerConfig {
        public static final ImmutableMap<String, String> SASL_PROPERTIES = ServiceConstants.access$000();
        public static final String SECURITY_MODE = "sentry.service.security.mode";
        public static final String SECURITY_MODE_KERBEROS = "kerberos";
        public static final String SECURITY_MODE_NONE = "none";
        public static final String SECURITY_USE_UGI_TRANSPORT = "sentry.service.security.use.ugi";
        public static final String ADMIN_GROUPS = "sentry.service.admin.group";
        public static final String PRINCIPAL = "sentry.service.server.principal";
        public static final String KEY_TAB = "sentry.service.server.keytab";
        public static final String RPC_PORT = "sentry.service.server.rpc-port";
        public static final int RPC_PORT_DEFAULT = 8038;
        public static final String RPC_ADDRESS = "sentry.service.server.rpc-address";
        public static final String RPC_ADDRESS_DEFAULT = "0.0.0.0";
        public static final String RPC_MAX_THREADS = "sentry.service.server-max-threads";
        public static final int RPC_MAX_THREADS_DEFAULT = 500;
        public static final String RPC_MIN_THREADS = "sentry.service.server-min-threads";
        public static final int RPC_MIN_THREADS_DEFAULT = 10;
        public static final String ALLOW_CONNECT = "sentry.service.allow.connect";
        public static final String SENTRY_POLICY_STORE_PLUGINS = "sentry.policy.store.plugins";
        public static final String SENTRY_POLICY_STORE_PLUGINS_DEFAULT = "";
        public static final String SENTRY_METASTORE_PLUGINS = "sentry.metastore.plugins";
        public static final String SENTRY_METASTORE_PLUGINS_DEFAULT = "";
        public static final String PROCESSOR_FACTORIES = "sentry.service.processor.factories";
        public static final String PROCESSOR_FACTORIES_DEFAULT = "org.apache.sentry.api.service.thrift.SentryPolicyStoreProcessorFactory,org.apache.sentry.api.generic.thrift.SentryGenericPolicyProcessorFactory";
        public static final String SENTRY_STORE = "sentry.service.sentrystore";
        public static final String SENTRY_STORE_DEFAULT = "org.apache.sentry.provider.db.service.persistent.SentryStore";
        public static final String SENTRY_STORE_JDBC_URL = "sentry.store.jdbc.url";
        public static final String SENTRY_STORE_JDBC_USER = "sentry.store.jdbc.user";
        public static final String SENTRY_STORE_JDBC_USER_DEFAULT = "Sentry";
        public static final String SENTRY_STORE_JDBC_PASS = "sentry.store.jdbc.password";
        public static final String SENTRY_STORE_JDBC_DRIVER = "sentry.store.jdbc.driver";
        public static final String SENTRY_STORE_JDBC_DRIVER_DEFAULT = "org.apache.derby.jdbc.EmbeddedDriver";
        public static final String SENTRY_STORE_TRANSACTION_RETRY = "sentry.store.transaction.retry";
        public static final int SENTRY_STORE_TRANSACTION_RETRY_DEFAULT = 11;
        public static final String SENTRY_STORE_TRANSACTION_RETRY_WAIT_TIME_MILLIS = "sentry.store.transaction.retry.wait.time.millis";
        public static final int SENTRY_STORE_TRANSACTION_RETRY_WAIT_TIME_MILLIS_DEFAULT = 250;
        public static final String JAVAX_JDO_URL = "javax.jdo.option.ConnectionURL";
        public static final String JAVAX_JDO_USER = "javax.jdo.option.ConnectionUserName";
        public static final String JAVAX_JDO_PASS = "javax.jdo.option.ConnectionPassword";
        public static final String JAVAX_JDO_DRIVER_NAME = "javax.jdo.option.ConnectionDriverName";
        public static final String DATANUCLEUS_ISOLATION_LEVEL = "datanucleus.transactionIsolation";
        public static final String DATANUCLEUS_REPEATABLE_READ = "repeatable-read";
        public static final String SENTRY_DB_PROPERTY_PREFIX = "sentry.";
        public static final String SENTRY_JAVAX_JDO_PROPERTY_PREFIX = "sentry.javax.jdo";
        public static final String SENTRY_DATANUCLEUS_PROPERTY_PREFIX = "sentry.datanucleus";
        public static final String SENTRY_VERIFY_SCHEM_VERSION = "sentry.verify.schema.version";
        public static final String SENTRY_VERIFY_SCHEM_VERSION_DEFAULT = "true";
        public static final String SENTRY_SERVICE_NAME = "sentry.service.name";
        public static final String SENTRY_SERVICE_NAME_DEFAULT = "Sentry-Service";
        public static final String SENTRY_STORE_GROUP_MAPPING = "sentry.store.group.mapping";
        public static final String SENTRY_STORE_GROUP_MAPPING_RESOURCE = "sentry.store.group.mapping.resource";
        public static final String SENTRY_STORE_HADOOP_GROUP_MAPPING = "org.apache.sentry.provider.common.HadoopGroupMappingService";
        public static final String SENTRY_STORE_LOCAL_GROUP_MAPPING = "org.apache.sentry.provider.file.LocalGroupMappingService";
        public static final String SENTRY_STORE_GROUP_MAPPING_DEFAULT = "org.apache.sentry.provider.common.HadoopGroupMappingService";
        public static final String SENTRY_STORE_ORPHANED_PRIVILEGE_REMOVAL = "sentry.store.orphaned.privilege.removal";
        public static final String SENTRY_STORE_ORPHANED_PRIVILEGE_REMOVAL_DEFAULT = "false";
        public static final String SENTRY_STORE_CLEAN_PERIOD_SECONDS = "sentry.store.clean.period.seconds";
        public static final long SENTRY_STORE_CLEAN_PERIOD_SECONDS_DEFAULT = 43200L;
        public static final String SENTRY_HA_ZK_PROPERTY_PREFIX = "sentry.ha.zookeeper.";
        public static final String SENTRY_HA_ZOOKEEPER_SECURITY = "sentry.ha.zookeeper.security";
        public static final boolean SENTRY_HA_ZOOKEEPER_SECURITY_DEFAULT = false;
        public static final String SENTRY_HA_ZOOKEEPER_QUORUM = "sentry.ha.zookeeper.quorum";
        public static final String SENTRY_HA_ZOOKEEPER_RETRIES_MAX_COUNT = "sentry.ha.zookeeper.session.retries.max.count";
        public static final int SENTRY_HA_ZOOKEEPER_RETRIES_MAX_COUNT_DEFAULT = 3;
        public static final String SENTRY_HA_ZOOKEEPER_SLEEP_BETWEEN_RETRIES_MS = "sentry.ha.zookeeper.session.sleep.between.retries.ms";
        public static final int SENTRY_HA_ZOOKEEPER_SLEEP_BETWEEN_RETRIES_MS_DEFAULT = 100;
        public static final String SENTRY_HA_ZOOKEEPER_NAMESPACE = "sentry.ha.zookeeper.namespace";
        public static final String SENTRY_HA_ZOOKEEPER_NAMESPACE_DEFAULT = "sentry";
        public static final String SERVER_HA_ZOOKEEPER_CLIENT_PRINCIPAL = "sentry.zookeeper.client.principal";
        public static final String SERVER_HA_ZOOKEEPER_CLIENT_KEYTAB = "sentry.zookeeper.client.keytab";
        public static final String SERVER_HA_ZOOKEEPER_CLIENT_TICKET_CACHE = "sentry.zookeeper.client.ticketcache";
        public static final String SERVER_HA_ZOOKEEPER_CLIENT_TICKET_CACHE_DEFAULT = "false";
        public static final String SERVER_HA_STANDBY_SIG = "sentry.ha.standby.signal";
        public static final String SENTRY_NOTIFICATION_SYNC_TIMEOUT_MS = "sentry.notification.sync.timeout.ms";
        public static final int SENTRY_NOTIFICATION_SYNC_TIMEOUT_DEFAULT = 200000;
        public static final ImmutableMap<String, String> SENTRY_STORE_DEFAULTS = ImmutableMap.builder().put((Object)"datanucleus.connectionPoolingType", (Object)"BoneCP").put((Object)"datanucleus.schema.validateTables", (Object)"false").put((Object)"datanucleus.schema.validateColumns", (Object)"false").put((Object)"datanucleus.schema.validateConstraints", (Object)"false").put((Object)"datanucleus.storeManagerType", (Object)"rdbms").put((Object)"datanucleus.schema.autoCreateAll", (Object)"false").put((Object)"datanucleus.autoStartMechanismMode", (Object)"checked").put((Object)"datanucleus.transactionIsolation", (Object)"repeatable-read").put((Object)"datanucleus.cache.level2", (Object)"false").put((Object)"datanucleus.cache.level2.type", (Object)"none").put((Object)"datanucleus.query.sql.allowAll", (Object)"true").put((Object)"datanucleus.identifierFactory", (Object)"datanucleus1").put((Object)"datanucleus.rdbms.useLegacyNativeValueStrategy", (Object)"true").put((Object)"datanucleus.plugin.pluginRegistryBundleCheck", (Object)"LOG").put((Object)"javax.jdo.PersistenceManagerFactoryClass", (Object)"org.datanucleus.api.jdo.JDOPersistenceManagerFactory").put((Object)"javax.jdo.option.DetachAllOnCommit", (Object)"true").put((Object)"javax.jdo.option.NonTransactionalRead", (Object)"false").put((Object)"javax.jdo.option.NonTransactionalWrite", (Object)"false").put((Object)"javax.jdo.option.Multithreaded", (Object)"true").build();
        public static final String SENTRY_HMSFOLLOWER_INIT_DELAY_MILLS = "sentry.hmsfollower.init.delay.mills";
        public static final long SENTRY_HMSFOLLOWER_INIT_DELAY_MILLS_DEFAULT = 0L;
        public static final String SENTRY_HMSFOLLOWER_INTERVAL_MILLS = "sentry.hmsfollower.interval.mills";
        public static final long SENTRY_HMSFOLLOWER_INTERVAL_MILLS_DEFAULT = 500L;
        public static final String SENTRY_WEB_ENABLE = "sentry.service.web.enable";
        public static final Boolean SENTRY_WEB_ENABLE_DEFAULT = false;
        public static final String SENTRY_WEB_PORT = "sentry.service.web.port";
        public static final int SENTRY_WEB_PORT_DEFAULT = 29000;
        public static final String SENTRY_REPORTER = "sentry.service.reporter";
        public static final String SENTRY_REPORTER_INTERVAL_SEC = "sentry.service.reporter.interval.sec";
        public static final String SENTRY_JSON_REPORTER_FILE = "sentry.service.reporter.file";
        public static final String SENTRY_JSON_REPORTER_FILE_DEFAULT = "/tmp/sentry-metrics.json";
        public static final int SENTRY_REPORTER_INTERVAL_DEFAULT = 300;
        public static final String SENTRY_WEB_USE_SSL = "sentry.web.use.ssl";
        public static final String SENTRY_WEB_SSL_KEYSTORE_PATH = "sentry.web.ssl.keystore.path";
        public static final String SENTRY_WEB_SSL_KEYSTORE_PASSWORD = "sentry.web.ssl.keystore.password";
        public static final String SENTRY_SSL_PROTOCOL_BLACKLIST = "sentry.ssl.protocol.blacklist";
        public static final String[] SENTRY_SSL_PROTOCOL_BLACKLIST_DEFAULT = new String[]{"SSLv2", "SSLv2Hello", "SSLv3"};
        public static final String SENTRY_WEB_SECURITY_PREFIX = "sentry.service.web.authentication";
        public static final String SENTRY_WEB_SECURITY_TYPE = "sentry.service.web.authentication.type";
        public static final String SENTRY_WEB_SECURITY_TYPE_NONE = "NONE";
        public static final String SENTRY_WEB_SECURITY_TYPE_KERBEROS = "KERBEROS";
        public static final String SENTRY_WEB_SECURITY_PRINCIPAL = "sentry.service.web.authentication.kerberos.principal";
        public static final String SENTRY_WEB_SECURITY_KEYTAB = "sentry.service.web.authentication.kerberos.keytab";
        public static final String SENTRY_WEB_SECURITY_ALLOW_CONNECT_USERS = "sentry.service.web.authentication.allow.connect.users";
        public static final String SENTRY_WEB_ADMIN_SERVLET_ENABLED = "sentry.web.admin.servlet.enabled";
        public static final boolean SENTRY_WEB_ADMIN_SERVLET_ENABLED_DEFAULT = false;
        public static final String SENTRY_WEB_PUBSUB_SERVLET_ENABLED = "sentry.web.pubsub.servlet.enabled";
        public static final boolean SENTRY_WEB_PUBSUB_SERVLET_ENABLED_DEFAULT = false;
        public static final String SENTRY_POLICY_SERVER_THRIFT_MAX_MESSAGE_SIZE = "sentry.policy.server.thrift.max.message.size";
        public static final long SENTRY_POLICY_SERVER_THRIFT_MAX_MESSAGE_SIZE_DEFAULT = 0x6400000L;
        public static final String SENTRY_COMPONENT_ACTION_FACTORY_FORMAT = "sentry.%s.action.factory";
        @Deprecated
        public static final String SENTRY_KERBEROS_TGT_AUTORENEW = "sentry.service.kerberos.tgt.autorenew";
        @Deprecated
        public static final Boolean SENTRY_KERBEROS_TGT_AUTORENEW_DEFAULT = false;
        public static final String SENTRY_DELTA_KEEP_COUNT = "sentry.server.delta.keep.count";
        public static final int SENTRY_DELTA_KEEP_COUNT_DEFAULT = 200;
        public static final String SENTRY_HMS_NOTIFICATION_ID_KEEP_COUNT = "sentry.server.delta.keep.count";
        public static final int SENTRY_HMS_NOTIFICATION_ID_KEEP_COUNT_DEFAULT = 100;
        public static final String SENTRY_DB_POLICY_STORE_OWNER_AS_PRIVILEGE = "sentry.db.policy.store.owner.as.privilege";
        public static final SentryOwnerPrivilegeType SENTRY_DB_POLICY_STORE_OWNER_AS_PRIVILEGE_DEFAULT = SentryOwnerPrivilegeType.NONE;
        public static final String SENTRY_DB_EXPLICIT_GRANTS_PERMITTED = "sentry.db.explicit.grants.permitted";
        public static final String SENTRY_DB_EXPLICIT_GRANTS_PERMITTED_DEFAULT = "CREATE,REFRESH,SELECT,INSERT,ALL,*";
        public static final String SENTRY_DB_VALUE_GENERATION_ALLOCATION_SIZE = "sentry.db.valuegeneration.allocation.size";
        public static final int SENTRY_DB_VALUE_GENERATION_ALLOCATION_SIZE_DEFAULT = 100;
        public static final String SENTRY_STATEMENT_BATCH_LIMIT = "sentry.statement.batch.limit";
        public static final int SENTRY_STATEMENT_BATCH_LIMIT_DEFAULT = 100;
    }

    public static class ServiceArgs {
        public static final String CONFIG_FILE_SHORT = "c";
        public static final String CONFIG_FILE_LONG = "conffile";
    }

    public static class ConfUtilties {
        public static final Splitter CLASS_SPLITTER = Splitter.onPattern((String)"[\\s,]").trimResults().omitEmptyStrings();
    }
}

