/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.sentry.core.common.utils.SentryConstants;

public class KeyValue {
    private final String key;
    private final String value;

    public KeyValue(String keyValue) {
        int splitterIndex = keyValue.indexOf("=");
        int splitterIndexEnd = keyValue.lastIndexOf("=");
        if (splitterIndex > 0 && splitterIndex == splitterIndexEnd) {
            this.key = keyValue.substring(0, splitterIndex).trim().intern();
            this.value = keyValue.substring(splitterIndex + 1).trim().intern();
        } else {
            ArrayList kvList = Lists.newArrayList((Iterable)SentryConstants.KV_SPLITTER.trimResults().limit(2).split((CharSequence)keyValue));
            if (kvList.size() != 2) {
                throw new IllegalArgumentException("Invalid key value: " + keyValue + " " + kvList);
            }
            this.key = (String)kvList.get(0);
            this.value = (String)kvList.get(1);
        }
        if (this.key.isEmpty()) {
            throw new IllegalArgumentException("For keyValue: " + keyValue + ", Key cannot be empty");
        }
        if (this.value.isEmpty()) {
            throw new IllegalArgumentException("For keyValue: " + keyValue + ", Value cannot be empty");
        }
    }

    public KeyValue(String key, String value) {
        this.key = key.intern();
        this.value = value.intern();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return SentryConstants.KV_JOINER.join((Object)this.key, (Object)this.value, new Object[0]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValue other = (KeyValue)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

