/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.registry;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.AbstractSliderResource;
import org.apache.slider.server.appmaster.web.rest.registry.PathEntryResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RegistryResource
extends AbstractSliderResource {
    protected static final Logger log = LoggerFactory.getLogger(RegistryResource.class);
    public static final String SERVICE_PATH = "/{path:.*}";
    private final RegistryOperations registry;

    public RegistryResource(WebAppApi slider) {
        super(slider);
        this.registry = slider.getRegistryOperations();
    }

    private void init(HttpServletRequest request, UriInfo uriInfo) {
        log.debug(uriInfo.getRequestUri().toString());
    }

    @GET
    @Produces(value={"application/json"})
    public PathEntryResource getRoot(@Context HttpServletRequest request, @Context UriInfo uriInfo) {
        return this.lookup("/", request, uriInfo);
    }

    @Path(value="/{path:.*}")
    @GET
    @Produces(value={"application/json"})
    public PathEntryResource lookup(@PathParam(value="path") String path, @Context HttpServletRequest request, @Context UriInfo uriInfo) {
        this.init(request, uriInfo);
        return this.resolvePath(path);
    }

    public PathEntryResource resolvePath(String path) throws WebApplicationException {
        try {
            PathEntryResource pathEntry = this.fromRegistry(path);
            if (log.isDebugEnabled()) {
                log.debug("Resolved:\n{}", (Object)pathEntry);
            }
            return pathEntry;
        }
        catch (Exception e) {
            throw this.buildException(path, e);
        }
    }

    private PathEntryResource fromRegistry(String path) throws IOException {
        PathEntryResource entry = new PathEntryResource();
        try {
            entry.service = this.registry.resolve(path);
        }
        catch (NoRecordException noRecordException) {
            log.debug("No record at {}", (Object)path);
        }
        catch (InvalidRecordException e) {
            log.warn("Failed to resolve {}: {}", new Object[]{path, e, e});
        }
        entry.nodes = this.registry.list(path);
        return entry;
    }
}

