/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.IOUtils;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractMetainfoParser {
    protected final GsonBuilder gsonBuilder = new GsonBuilder();
    protected final Gson gson = this.gsonBuilder.create();
    private static final Logger log = LoggerFactory.getLogger(AbstractMetainfoParser.class);

    public String toJsonString(Metainfo metaInfo) throws IOException {
        return this.gson.toJson((Object)metaInfo);
    }

    public Metainfo fromJsonString(String json) throws IOException {
        return (Metainfo)this.gson.fromJson(json, Metainfo.class);
    }

    public Metainfo fromJsonStream(InputStream is) throws IOException {
        log.debug("loading from xml stream");
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer);
        return this.fromJsonString(writer.toString());
    }

    public Metainfo fromXmlStream(InputStream metainfoStream) throws IOException {
        log.debug("loading from xml stream");
        Digester digester = new Digester();
        digester.setValidating(false);
        this.composeSchema(digester);
        try {
            Metainfo metainfo = (Metainfo)digester.parse(metainfoStream);
            return metainfo;
        }
        catch (IOException e) {
            log.debug("IOException in metainfoparser during fromXmlStream: " + e.getMessage());
        }
        catch (SAXException e) {
            log.debug("SAXException in metainfoparser during fromXmlStream: " + e.getMessage());
        }
        finally {
            metainfoStream.close();
        }
        return null;
    }

    protected abstract void composeSchema(Digester var1);
}

