/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.zk;

import java.util.Locale;

public final class ZKPathBuilder {
    private final String username;
    private final String appname;
    private final String clustername;
    private final String quorum;
    private String appPath;
    private String registryPath;
    private final String appQuorum;

    public ZKPathBuilder(String username, String appname, String clustername, String quorum, String appQuorum) {
        this.username = username;
        this.appname = appname;
        this.clustername = clustername;
        this.quorum = quorum;
        this.appPath = this.buildAppPath();
        this.registryPath = this.buildRegistryPath();
        this.appQuorum = appQuorum;
    }

    public String buildAppPath() {
        return String.format(Locale.ENGLISH, "/yarnapps_%s_%s_%s", this.appname, this.username, this.clustername);
    }

    public String buildRegistryPath() {
        return String.format(Locale.ENGLISH, "/services_%s_%s_%s", this.appname, this.username, this.clustername);
    }

    public String getQuorum() {
        return this.quorum;
    }

    public String getAppQuorum() {
        return this.appQuorum;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getRegistryPath() {
        return this.registryPath;
    }

    public void setRegistryPath(String registryPath) {
        this.registryPath = registryPath;
    }
}

