/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.restclient;

import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.slider.core.exceptions.ExceptionConverter;
import org.apache.slider.core.restclient.HttpVerb;
import org.apache.slider.core.restclient.UrlConnectionOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UgiJerseyBinding
implements HttpURLConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(UgiJerseyBinding.class);
    private final UrlConnectionOperations operations;
    private final URLConnectionClientHandler handler;

    public UgiJerseyBinding(UrlConnectionOperations operations) {
        Preconditions.checkArgument((operations != null ? 1 : 0) != 0, (Object)"Null operations");
        this.operations = operations;
        this.handler = new URLConnectionClientHandler((HttpURLConnectionFactory)this);
    }

    public UgiJerseyBinding(Configuration conf) {
        this(new UrlConnectionOperations(conf));
    }

    public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
        try {
            return this.operations.openConnection(url);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
    }

    public UrlConnectionOperations getOperations() {
        return this.operations;
    }

    public URLConnectionClientHandler getHandler() {
        return this.handler;
    }

    public boolean isUseSpnego() {
        return this.operations.isUseSpnego();
    }

    public static IOException uprateFaults(HttpVerb verb, String url, UniformInterfaceException ex) throws IOException {
        return ExceptionConverter.convertJerseyException(verb.getVerb(), url, ex);
    }

    public ClientConfig createJerseyClientConfig() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", true);
        return clientConfig;
    }

    public Client createJerseyClient(ClientConfig clientConfig) {
        return new Client((ClientHandler)this.getHandler(), clientConfig);
    }

    public Client createJerseyClient() {
        return this.createJerseyClient(this.createJerseyClientConfig());
    }
}

