/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.slider.core.persist.ApplicationReportSerDeser;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class SerializedApplicationReport {
    public String applicationId;
    public String applicationAttemptId;
    public String name;
    public String applicationType;
    public String user;
    public String queue;
    public String host;
    public Integer rpcPort;
    public String state;
    public String diagnostics;
    public String url;
    public Long submitTime;
    public Long startTime;
    public Long finishTime;
    public String finalStatus;
    public String origTrackingUrl;
    public Float progress;

    public SerializedApplicationReport() {
    }

    public SerializedApplicationReport(ApplicationReport report) {
        this.applicationId = report.getApplicationId().toString();
        this.applicationAttemptId = report.getCurrentApplicationAttemptId().toString();
        this.name = report.getName();
        this.applicationType = report.getApplicationType();
        this.user = report.getUser();
        this.queue = report.getQueue();
        this.host = report.getHost();
        this.rpcPort = report.getRpcPort();
        this.state = report.getYarnApplicationState().toString();
        this.diagnostics = report.getDiagnostics();
        this.startTime = report.getStartTime();
        this.finishTime = report.getFinishTime();
        FinalApplicationStatus appStatus = report.getFinalApplicationStatus();
        this.finalStatus = appStatus == null ? "" : appStatus.toString();
        this.progress = Float.valueOf(report.getProgress());
        this.url = report.getTrackingUrl();
        this.origTrackingUrl = report.getOriginalTrackingUrl();
    }

    public String toString() {
        try {
            return ApplicationReportSerDeser.toString(this);
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }
}

