/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.spi;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.sentry.spi.ProviderFactory;
import org.apache.sentry.spi.ProviderLoader;
import org.apache.sentry.spi.Spi;

public class DefaultProviderLoader
implements ProviderLoader {
    private ClassLoader classLoader;

    public DefaultProviderLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public List<Spi> loadSpis() {
        LinkedList<Spi> list = new LinkedList<Spi>();
        for (Spi spi : ServiceLoader.load(Spi.class, this.classLoader)) {
            list.add(spi);
        }
        return list;
    }

    @Override
    public List<ProviderFactory> load(Spi spi) {
        LinkedList<ProviderFactory> list = new LinkedList<ProviderFactory>();
        for (ProviderFactory providerFactory : ServiceLoader.load(spi.getProviderFactoryClass(), this.classLoader)) {
            list.add(providerFactory);
        }
        return list;
    }
}

