/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.thirdparty.com.google.common.eventbus;

import com.jolbox.thirdparty.com.google.common.base.Objects;
import com.jolbox.thirdparty.com.google.common.base.Throwables;
import com.jolbox.thirdparty.com.google.common.cache.CacheBuilder;
import com.jolbox.thirdparty.com.google.common.cache.CacheLoader;
import com.jolbox.thirdparty.com.google.common.cache.LoadingCache;
import com.jolbox.thirdparty.com.google.common.collect.HashMultimap;
import com.jolbox.thirdparty.com.google.common.collect.ImmutableList;
import com.jolbox.thirdparty.com.google.common.collect.Maps;
import com.jolbox.thirdparty.com.google.common.collect.Multimap;
import com.jolbox.thirdparty.com.google.common.eventbus.AllowConcurrentEvents;
import com.jolbox.thirdparty.com.google.common.eventbus.EventHandler;
import com.jolbox.thirdparty.com.google.common.eventbus.HandlerFindingStrategy;
import com.jolbox.thirdparty.com.google.common.eventbus.Subscribe;
import com.jolbox.thirdparty.com.google.common.eventbus.SynchronizedEventHandler;
import com.jolbox.thirdparty.com.google.common.reflect.TypeToken;
import com.jolbox.thirdparty.com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    private static final LoadingCache<Class<?>, ImmutableList<Method>> handlerMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        @Override
        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return AnnotatedHandlerFinder.getAnnotatedMethodsInternal(concreteClass);
        }
    });

    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap<Class<?>, EventHandler> methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method : AnnotatedHandlerFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method);
            methodsInListener.put(eventType, handler);
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return handlerMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsInternal(Class<?> clazz) {
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap<MethodIdentifier, Method> identifiers = Maps.newHashMap();
        for (Class superClazz : supers) {
            for (Method superClazzMethod : superClazz.getMethods()) {
                if (!superClazzMethod.isAnnotationPresent(Subscribe.class)) continue;
                Class<?>[] parameterTypes = superClazzMethod.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException("Method " + superClazzMethod + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                }
                MethodIdentifier ident = new MethodIdentifier(superClazzMethod);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, superClazzMethod);
            }
        }
        return ImmutableList.copyOf(identifiers.values());
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

