/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.MemorizeTransactionProxy;
import com.jolbox.thirdparty.com.google.common.base.FinalizableWeakReference;
import com.jolbox.thirdparty.com.google.common.base.Objects;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPartition
implements Serializable {
    private static final long serialVersionUID = -7864443421028454573L;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPartition.class);
    private BlockingQueue<ConnectionHandle> freeConnections;
    private final int acquireIncrement;
    private final int minConnections;
    private final int maxConnections;
    protected ReentrantReadWriteLock statsLock = new ReentrantReadWriteLock();
    private int createdConnections = 0;
    private final String url;
    private final String username;
    private final String password;
    private volatile boolean unableToCreateMoreTransactions = false;
    private boolean disableTracking;
    private BlockingQueue<Object> poolWatchThreadSignalQueue = new ArrayBlockingQueue<Object>(1);
    private long queryExecuteTimeLimitInNanoSeconds;
    private String poolName;
    protected BoneCP pool;

    protected BlockingQueue<Object> getPoolWatchThreadSignalQueue() {
        return this.poolWatchThreadSignalQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCreatedConnections(int increment) {
        try {
            this.statsLock.writeLock().lock();
            this.createdConnections += increment;
        }
        finally {
            this.statsLock.writeLock().unlock();
        }
    }

    protected void addFreeConnection(ConnectionHandle connectionHandle) throws SQLException {
        connectionHandle.setOriginatingPartition(this);
        this.updateCreatedConnections(1);
        if (!this.disableTracking) {
            this.trackConnectionFinalizer(connectionHandle);
        }
        if (!this.freeConnections.offer(connectionHandle)) {
            this.updateCreatedConnections(-1);
            if (!this.disableTracking) {
                this.pool.getFinalizableRefs().remove(connectionHandle.getInternalConnection());
            }
            connectionHandle.internalClose();
        }
    }

    protected void trackConnectionFinalizer(ConnectionHandle connectionHandle) {
        if (!this.disableTracking) {
            Connection con = connectionHandle.getInternalConnection();
            if (con != null && con instanceof Proxy && Proxy.getInvocationHandler(con) instanceof MemorizeTransactionProxy) {
                try {
                    con = (Connection)Proxy.getInvocationHandler(con).invoke(con, ConnectionHandle.class.getMethod("getProxyTarget", new Class[0]), null);
                }
                catch (Throwable t) {
                    logger.error("Error while attempting to track internal db connection", t);
                }
            }
            final Connection internalDBConnection = con;
            final BoneCP pool = connectionHandle.getPool();
            connectionHandle.getPool().getFinalizableRefs().put(internalDBConnection, (Reference<ConnectionHandle>)new FinalizableWeakReference<ConnectionHandle>(connectionHandle, connectionHandle.getPool().getFinalizableRefQueue()){

                @Override
                public void finalizeReferent() {
                    try {
                        pool.getFinalizableRefs().remove(internalDBConnection);
                        if (internalDBConnection != null && !internalDBConnection.isClosed()) {
                            logger.warn("BoneCP detected an unclosed connection " + ConnectionPartition.this.poolName + "and will now attempt to close it for you. " + "You should be closing this connection in your application - enable connectionWatch for additional debugging assistance or set disableConnectionTracking to true to disable this feature entirely.");
                            internalDBConnection.close();
                            ConnectionPartition.this.updateCreatedConnections(-1);
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Error while closing off internal db connection", t);
                    }
                }
            });
        }
    }

    protected BlockingQueue<ConnectionHandle> getFreeConnections() {
        return this.freeConnections;
    }

    protected void setFreeConnections(BlockingQueue<ConnectionHandle> freeConnections) {
        this.freeConnections = freeConnections;
    }

    public ConnectionPartition(BoneCP pool) {
        BoneCPConfig config = pool.getConfig();
        this.minConnections = config.getMinConnectionsPerPartition();
        this.maxConnections = config.getMaxConnectionsPerPartition();
        this.acquireIncrement = config.getAcquireIncrement();
        this.url = config.getJdbcUrl();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.poolName = config.getPoolName() != null ? "(in pool '" + config.getPoolName() + "') " : "";
        this.pool = pool;
        this.disableTracking = config.isDisableConnectionTracking();
        this.queryExecuteTimeLimitInNanoSeconds = TimeUnit.NANOSECONDS.convert(config.getQueryExecuteTimeLimitInMs(), TimeUnit.MILLISECONDS);
    }

    protected int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    protected int getMinConnections() {
        return this.minConnections;
    }

    protected int getMaxConnections() {
        return this.maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCreatedConnections() {
        try {
            this.statsLock.readLock().lock();
            int n = this.createdConnections;
            return n;
        }
        finally {
            this.statsLock.readLock().unlock();
        }
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    protected boolean isUnableToCreateMoreTransactions() {
        return this.unableToCreateMoreTransactions;
    }

    protected void setUnableToCreateMoreTransactions(boolean unableToCreateMoreTransactions) {
        this.unableToCreateMoreTransactions = unableToCreateMoreTransactions;
    }

    protected int getAvailableConnections() {
        return this.freeConnections.size();
    }

    public int getRemainingCapacity() {
        return this.freeConnections.remainingCapacity();
    }

    protected long getQueryExecuteTimeLimitinNanoSeconds() {
        return this.queryExecuteTimeLimitInNanoSeconds;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("url", this.pool.getConfig().getJdbcUrl()).add("user", this.pool.getConfig().getUsername()).add("minConnections", this.getMinConnections()).add("maxConnections", this.getMaxConnections()).add("acquireIncrement", this.acquireIncrement).add("createdConnections", this.createdConnections).add("freeConnections", this.getFreeConnections()).toString();
    }
}

