/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.AbstractConnectionStrategy;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionStrategy;
import com.jolbox.thirdparty.com.google.common.base.FinalizableReferenceQueue;
import com.jolbox.thirdparty.com.google.common.base.FinalizableWeakReference;
import com.jolbox.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import java.lang.ref.Reference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedConnectionStrategy
extends AbstractConnectionStrategy {
    private static final long serialVersionUID = -4725640468699097218L;
    private static final Logger logger = LoggerFactory.getLogger(CachedConnectionStrategy.class);
    private volatile AtomicBoolean warnApp = new AtomicBoolean();
    protected final Map<ConnectionHandle, Reference<Thread>> threadFinalizableRefs = new ConcurrentHashMap<ConnectionHandle, Reference<Thread>>();
    private FinalizableReferenceQueue finalizableRefQueue = new FinalizableReferenceQueue();
    private ConnectionStrategy fallbackStrategy;
    protected CachedConnectionStrategyThreadLocal<AbstractMap.SimpleEntry<ConnectionHandle, Boolean>> tlConnections;

    public CachedConnectionStrategy(BoneCP pool, ConnectionStrategy fallbackStrategy) {
        this.pool = pool;
        this.fallbackStrategy = fallbackStrategy;
        this.tlConnections = new CachedConnectionStrategyThreadLocal(this, this.fallbackStrategy);
    }

    protected synchronized void stealExistingAllocations() {
        for (ConnectionHandle handle : this.threadFinalizableRefs.keySet()) {
            if (!handle.logicallyClosed.compareAndSet(true, false)) continue;
            try {
                this.pool.releaseConnection(handle);
            }
            catch (SQLException e) {
                logger.error("Error releasing connection", (Throwable)e);
            }
        }
        if (this.warnApp.compareAndSet(false, true)) {
            logger.warn("Cached strategy chosen, but more threads are requesting a connection than are configured. Switching permanently to default strategy.");
        }
        this.threadFinalizableRefs.clear();
    }

    protected void threadWatch(final ConnectionHandle c) {
        this.threadFinalizableRefs.put(c, (Reference<Thread>)new FinalizableWeakReference<Thread>(Thread.currentThread(), this.finalizableRefQueue){

            @Override
            public void finalizeReferent() {
                try {
                    if (!CachedConnectionStrategy.this.pool.poolShuttingDown) {
                        logger.debug("Monitored thread is dead, closing off allocated connection.");
                    }
                    c.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                CachedConnectionStrategy.this.threadFinalizableRefs.remove(c);
            }
        });
    }

    protected Connection getConnectionInternal() throws SQLException {
        Object result = this.tlConnections.get();
        if (result == null) {
            this.pool.cachedPoolStrategy = false;
            this.pool.connectionStrategy = this.fallbackStrategy;
            this.stealExistingAllocations();
            return (ConnectionHandle)this.pool.connectionStrategy.getConnection();
        }
        return (Connection)((AbstractMap.SimpleEntry)result).getKey();
    }

    public ConnectionHandle pollConnection() {
        throw new UnsupportedOperationException();
    }

    public void terminateAllConnections() {
        for (ConnectionHandle conn : this.threadFinalizableRefs.keySet()) {
            this.pool.destroyConnection(conn);
        }
        this.threadFinalizableRefs.clear();
        this.fallbackStrategy.terminateAllConnections();
    }

    public void cleanupConnection(ConnectionHandle oldHandle, ConnectionHandle newHandle) {
        this.threadFinalizableRefs.remove(oldHandle);
        this.threadWatch(newHandle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CachedConnectionStrategyThreadLocal<T>
    extends ThreadLocal<AbstractMap.SimpleEntry<ConnectionHandle, Boolean>> {
        private ConnectionStrategy fallbackStrategy;
        private CachedConnectionStrategy ccs;

        public CachedConnectionStrategyThreadLocal(CachedConnectionStrategy ccs, ConnectionStrategy fallbackStrategy) {
            this.fallbackStrategy = fallbackStrategy;
            this.ccs = ccs;
        }

        @Override
        protected AbstractMap.SimpleEntry<ConnectionHandle, Boolean> initialValue() {
            AbstractMap.SimpleEntry<ConnectionHandle, Boolean> result = null;
            ConnectionHandle c = null;
            for (int i = 0; i < 12 && (c = (ConnectionHandle)this.fallbackStrategy.pollConnection()) == null; ++i) {
                Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
            }
            if (c != null) {
                result = new AbstractMap.SimpleEntry<ConnectionHandle, Boolean>(c, false);
                this.ccs.threadWatch(c);
            }
            return result;
        }

        public AbstractMap.SimpleEntry<ConnectionHandle, Boolean> dumbGet() {
            return (AbstractMap.SimpleEntry)super.get();
        }

        @Override
        public AbstractMap.SimpleEntry<ConnectionHandle, Boolean> get() {
            AbstractMap.SimpleEntry<ConnectionHandle, Boolean> result = (AbstractMap.SimpleEntry<ConnectionHandle, Boolean>)super.get();
            if (result == null || ((Boolean)result.getValue()).booleanValue()) {
                ConnectionHandle fallbackConnection = (ConnectionHandle)this.fallbackStrategy.pollConnection();
                if (fallbackConnection == null) {
                    return null;
                }
                result = new AbstractMap.SimpleEntry<ConnectionHandle, Boolean>(fallbackConnection, false);
            }
            result.setValue(true);
            ((ConnectionHandle)result.getKey()).logicallyClosed.set(false);
            return result;
        }
    }
}

