/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;

public class HiveAuthzPrivileges {
    private final Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> inputPrivileges = new HashMap<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>>();
    private final Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> outputPrivileges = new HashMap<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>>();
    private final HiveOperationType operationType;
    private final HiveOperationScope operationScope;
    private final boolean grantOption;

    protected HiveAuthzPrivileges(Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> inputPrivileges, Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> outputPrivileges, HiveOperationType operationType, HiveOperationScope operationScope) {
        this(inputPrivileges, outputPrivileges, operationType, operationScope, false);
    }

    protected HiveAuthzPrivileges(Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> inputPrivileges, Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> outputPrivileges, HiveOperationType operationType, HiveOperationScope operationScope, boolean requireGrantOption) {
        this.inputPrivileges.putAll(inputPrivileges);
        this.outputPrivileges.putAll(outputPrivileges);
        this.operationScope = operationScope;
        this.operationType = operationType;
        this.grantOption = requireGrantOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HiveAuthzPrivileges)) {
            return false;
        }
        HiveAuthzPrivileges that = (HiveAuthzPrivileges)o;
        return this.grantOption == that.grantOption && Objects.equals(this.inputPrivileges, that.inputPrivileges) && Objects.equals(this.outputPrivileges, that.outputPrivileges) && this.operationType == that.operationType && this.operationScope == that.operationScope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputPrivileges, this.outputPrivileges, this.operationType, this.operationScope, this.grantOption});
    }

    public Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> getInputPrivileges() {
        return this.inputPrivileges;
    }

    public Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> getOutputPrivileges() {
        return this.outputPrivileges;
    }

    public boolean getGrantOption() {
        return this.grantOption;
    }

    public HiveOperationType getOperationType() {
        return this.operationType;
    }

    public HiveOperationScope getOperationScope() {
        return this.operationScope;
    }

    public static class AuthzPrivilegeBuilder {
        private final Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> inputPrivileges = new HashMap<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>>();
        private final Map<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>> outputPrivileges = new HashMap<DBModelAuthorizable.AuthorizableType, EnumSet<DBModelAction>>();
        private HiveOperationType operationType;
        private HiveOperationScope operationScope;
        private boolean grantOption = false;

        public AuthzPrivilegeBuilder addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType inputObjectType, EnumSet<DBModelAction> inputPrivilege) {
            this.inputPrivileges.put(inputObjectType, inputPrivilege);
            return this;
        }

        public AuthzPrivilegeBuilder addOutputEntityPriviledge(DBModelAuthorizable.AuthorizableType outputEntityType, EnumSet<DBModelAction> outputPrivilege) {
            this.outputPrivileges.put(outputEntityType, outputPrivilege);
            return this;
        }

        public AuthzPrivilegeBuilder addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType outputObjectType, EnumSet<DBModelAction> outputPrivilege) {
            this.outputPrivileges.put(outputObjectType, outputPrivilege);
            return this;
        }

        public AuthzPrivilegeBuilder setOperationType(HiveOperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public AuthzPrivilegeBuilder setOperationScope(HiveOperationScope operationScope) {
            this.operationScope = operationScope;
            return this;
        }

        public AuthzPrivilegeBuilder setGrantOption(boolean requireGrantOption) {
            this.grantOption = requireGrantOption;
            return this;
        }

        public HiveAuthzPrivileges build() {
            if (this.operationScope.equals((Object)HiveOperationScope.UNKNOWN)) {
                throw new UnsupportedOperationException("Operation scope is not set");
            }
            if (this.operationType.equals((Object)HiveOperationType.UNKNOWN)) {
                throw new UnsupportedOperationException("Operation scope is not set");
            }
            return new HiveAuthzPrivileges(this.inputPrivileges, this.outputPrivileges, this.operationType, this.operationScope, this.grantOption);
        }
    }

    public static enum HiveExtendedOperation {
        TRANSFORM,
        RESOURCE;

    }

    public static enum HiveOperationScope {
        UNKNOWN,
        SERVER,
        DATABASE,
        TABLE,
        FUNCTION,
        CONNECT,
        COLUMN;

    }

    public static enum HiveOperationType {
        UNKNOWN,
        DDL,
        DML,
        DATA_LOAD,
        DATA_UNLOAD,
        QUERY,
        INFO;

    }
}

