/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryPrincipalType;

class SentryHmsEvent {
    private long eventId;
    private final EventMessage.EventType eventType;
    private String ownerName;
    private TSentryPrincipalType ownerType;
    private TSentryAuthorizable authorizable;
    private final Boolean isMetastoreTransactionActive;
    private static final Map<PrincipalType, TSentryPrincipalType> mapOwnerType = ImmutableMap.of((Object)PrincipalType.ROLE, (Object)TSentryPrincipalType.ROLE, (Object)PrincipalType.USER, (Object)TSentryPrincipalType.USER);

    private SentryHmsEvent(ListenerEvent event, EventMessage.EventType type) {
        String isActive = event.getParameters().getOrDefault("HIVE_METASTORE_TRANSACTION_ACTIVE", null);
        this.isMetastoreTransactionActive = isActive != null && Boolean.valueOf(isActive) != false;
        this.eventId = this.getEventId(event);
        this.eventType = type;
    }

    public SentryHmsEvent(String inServerName, CreateTableEvent event) {
        this((ListenerEvent)event, EventMessage.EventType.CREATE_TABLE);
        this.setOwnerInfo(event.getTable());
        this.setAuthorizable(inServerName, event.getTable());
    }

    public SentryHmsEvent(String inServerName, DropTableEvent event) {
        this((ListenerEvent)event, EventMessage.EventType.DROP_TABLE);
        this.setOwnerInfo(event.getTable());
        this.setAuthorizable(inServerName, event.getTable());
    }

    public SentryHmsEvent(String inServerName, AlterTableEvent event) {
        this((ListenerEvent)event, EventMessage.EventType.ALTER_TABLE);
        if (!StringUtils.equals((String)event.getOldTable().getOwner(), (String)event.getNewTable().getOwner())) {
            this.setOwnerInfo(event.getNewTable());
        }
        this.setAuthorizable(inServerName, event.getNewTable());
    }

    public SentryHmsEvent(String inServerName, AlterDatabaseEvent event) {
        this((ListenerEvent)event, EventMessage.EventType.ALTER_DATABASE);
        if (!StringUtils.equals((String)event.getOldDatabase().getOwnerName(), (String)event.getNewDatabase().getOwnerName())) {
            this.setOwnerInfo(event.getNewDatabase());
        }
        this.setAuthorizable(inServerName, event.getNewDatabase());
    }

    public SentryHmsEvent(String inServerName, CreateDatabaseEvent event) {
        this((ListenerEvent)event, EventMessage.EventType.CREATE_DATABASE);
        this.setOwnerInfo(event.getDatabase());
        this.setAuthorizable(inServerName, event.getDatabase());
    }

    public SentryHmsEvent(String inServerName, DropDatabaseEvent event) {
        this((ListenerEvent)event, EventMessage.EventType.DROP_DATABASE);
        this.setOwnerInfo(event.getDatabase());
        this.setAuthorizable(inServerName, event.getDatabase());
    }

    public EventMessage.EventType getEventType() {
        return this.eventType;
    }

    public long getEventId() {
        return this.eventId;
    }

    public TSentryPrincipalType getOwnerType() {
        return this.ownerType;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public TSentryAuthorizable getAuthorizable() {
        return this.authorizable;
    }

    private void setOwnerInfo(Table table) {
        this.ownerName = table != null ? table.getOwner() : null;
        this.ownerType = table != null ? this.getTSentryHmsObjectOwnerType(table.getOwnerType()) : null;
    }

    private void setOwnerInfo(Database database) {
        this.ownerName = database != null ? database.getOwnerName() : null;
        this.ownerType = database != null ? this.getTSentryHmsObjectOwnerType(database.getOwnerType()) : null;
    }

    private void setAuthorizable(String serverName, Table table) {
        if (this.authorizable == null) {
            this.authorizable = new TSentryAuthorizable(serverName);
        }
        this.authorizable.setDb(table != null ? table.getDbName() : null);
        this.authorizable.setTable(table != null ? table.getTableName() : null);
    }

    private void setAuthorizable(String serverName, Database database) {
        if (this.authorizable == null) {
            this.authorizable = new TSentryAuthorizable(serverName);
        }
        this.authorizable.setDb(database != null ? database.getName() : null);
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    private TSentryPrincipalType getTSentryHmsObjectOwnerType(PrincipalType principalType) {
        return mapOwnerType.get(principalType);
    }

    private long getEventId(ListenerEvent event) {
        return Long.parseLong(event.getParameters().getOrDefault("DB_NOTIFICATION_EVENT_ID_KEY_NAME", "-1"));
    }

    public Boolean isMetastoreTransactionActive() {
        return this.isMetastoreTransactionActive;
    }
}

