/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivilegesMap;
import org.apache.sentry.binding.metastore.MetastoreAuthzBindingBase;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.db.DBModelAuthorizable;

public class MetastoreAuthzBinding
extends MetastoreAuthzBindingBase {
    public MetastoreAuthzBinding(Configuration config) throws Exception {
        super(config);
    }

    @Override
    protected void authorizeMetastoreAccess(HiveOperation hiveOp, Set<List<DBModelAuthorizable>> inputHierarchy, Set<List<DBModelAuthorizable>> outputHierarchy) throws InvalidOperationException {
        if (MetastoreAuthzBinding.isSentryCacheOutOfSync()) {
            throw this.invalidOperationException((Exception)((Object)new SentryUserException("Metastore/Sentry cache is out of sync")));
        }
        try {
            this.getHiveAuthzBinding().authorize(hiveOp, HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(hiveOp), new Subject(this.getUserName()), inputHierarchy, outputHierarchy);
        }
        catch (AuthorizationException e1) {
            throw this.invalidOperationException((Exception)((Object)e1));
        }
        catch (LoginException e1) {
            throw this.invalidOperationException(e1);
        }
        catch (IOException e1) {
            throw this.invalidOperationException(e1);
        }
        catch (Exception e) {
            throw this.invalidOperationException(e);
        }
    }
}

