/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.SentryHivePrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.AbstractHiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.sentry.binding.hive.SentryHivePrivilegeObject;
import org.apache.sentry.binding.hive.authz.SentryHiveAccessController;
import org.apache.sentry.binding.hive.authz.SentryHiveAuthorizationValidator;

public class SentryHiveAuthorizerImpl
extends AbstractHiveAuthorizer {
    private SentryHiveAccessController accessController;
    private SentryHiveAuthorizationValidator authValidator;
    private static HiveAuthorizationTranslator hiveTranslator = new SentryHiveAuthorizationTranslator();

    public SentryHiveAuthorizerImpl(SentryHiveAccessController accessController, SentryHiveAuthorizationValidator authValidator) {
        this.accessController = accessController;
        this.authValidator = authValidator;
    }

    public HiveAuthorizer.VERSION getVersion() {
        return HiveAuthorizer.VERSION.V1;
    }

    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        this.accessController.grantPrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
    }

    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        this.accessController.revokePrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
    }

    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException, HiveAccessControlException {
        this.accessController.createRole(roleName, adminGrantor);
    }

    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        this.accessController.dropRole(roleName);
    }

    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        return this.accessController.getPrincipalGrantInfoForRole(roleName);
    }

    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAuthzPluginException, HiveAccessControlException {
        return this.accessController.getRoleGrantInfoForPrincipal(principal);
    }

    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        this.accessController.grantRole(hivePrincipals, roles, grantOption, grantorPrinc);
    }

    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        this.accessController.revokeRole(hivePrincipals, roles, grantOption, grantorPrinc);
    }

    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputsHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
    }

    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> listObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        return this.authValidator.filterListCmdObjects(listObjs, context);
    }

    public List<String> getAllRoles() throws HiveAuthzPluginException, HiveAccessControlException {
        return this.accessController.getAllRoles();
    }

    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException, HiveAccessControlException {
        return this.accessController.showPrivileges(principal, privObj);
    }

    public void setCurrentRole(String roleName) throws HiveAccessControlException, HiveAuthzPluginException {
        this.accessController.setCurrentRole(roleName);
    }

    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        return this.accessController.getCurrentRoleNames();
    }

    public void applyAuthorizationConfigPolicy(HiveConf hiveConf) throws HiveAuthzPluginException {
        this.accessController.applyAuthorizationConfigPolicy(hiveConf);
    }

    public HiveAuthorizationTranslator getHiveAuthorizationTranslator() throws HiveAuthzPluginException {
        return hiveTranslator;
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext hiveAuthzContext, List<HivePrivilegeObject> list) throws SemanticException {
        return null;
    }

    public boolean needTransform() {
        return false;
    }

    protected static HivePrivilegeObject.HivePrivilegeObjectType getPrivObjectType(SentryHivePrivilegeObjectDesc privSubjectDesc) {
        if (privSubjectDesc.getObject() == null) {
            return null;
        }
        if (privSubjectDesc.getServer()) {
            return HivePrivilegeObject.HivePrivilegeObjectType.GLOBAL;
        }
        if (privSubjectDesc.getUri()) {
            return HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI;
        }
        return privSubjectDesc.getTable() ? HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW : HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
    }

    private static class SentryHiveAuthorizationTranslator
    extends DefaultHiveAuthorizationTranslator {
        private SentryHiveAuthorizationTranslator() {
        }

        public HivePrivilegeObject getHivePrivilegeObject(PrivilegeObjectDesc privSubjectDesc) throws HiveException {
            SentryHivePrivilegeObjectDesc sPrivSubjectDesc;
            if (privSubjectDesc != null && privSubjectDesc instanceof SentryHivePrivilegeObjectDesc && (sPrivSubjectDesc = (SentryHivePrivilegeObjectDesc)privSubjectDesc).isSentryPrivObjectDesc()) {
                HivePrivilegeObject.HivePrivilegeObjectType objectType = SentryHiveAuthorizerImpl.getPrivObjectType(sPrivSubjectDesc);
                return new SentryHivePrivilegeObject(objectType, privSubjectDesc.getObject());
            }
            return super.getHivePrivilegeObject(privSubjectDesc);
        }
    }
}

