/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.db.Column;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Table;

public class MetastoreAuthzObjectFilter<T> {
    private static final HiveAuthzPrivileges LIST_DATABASES_PRIVILEGES = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, new DBModelAction[]{DBModelAction.INSERT, DBModelAction.ALTER, DBModelAction.CREATE, DBModelAction.DROP, DBModelAction.INDEX, DBModelAction.LOCK})).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
    private static final HiveAuthzPrivileges LIST_DATABASES_PRIVILEGES_ON_SELECT = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
    private static final HiveAuthzPrivileges LIST_TABLES_PRIVILEGES = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, new DBModelAction[]{DBModelAction.INSERT, DBModelAction.ALTER, DBModelAction.CREATE, DBModelAction.DROP, DBModelAction.INDEX, DBModelAction.LOCK})).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
    private static final HiveAuthzPrivileges LIST_TABLES_PRIVILEGES_ON_SELECT = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
    private final boolean DEFAULT_DATABASE_RESTRICTED;
    private final boolean SHOWDATABASES_ON_SELECT_ONLY;
    private final boolean SHOWTABLES_ON_SELECT_ONLY;
    private final DBModelAuthorizable AUTH_SERVER;
    private HiveAuthzBinding authzBinding;
    private ObjectExtractor extractor;

    public MetastoreAuthzObjectFilter(HiveAuthzBinding authzBinding, ObjectExtractor extractor) {
        this.authzBinding = authzBinding;
        this.extractor = extractor;
        this.AUTH_SERVER = authzBinding.getAuthServer();
        this.DEFAULT_DATABASE_RESTRICTED = authzBinding.getAuthzConf().getBoolean(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), false);
        this.SHOWDATABASES_ON_SELECT_ONLY = authzBinding.getAuthzConf().getBoolean(HiveAuthzConf.AuthzConfVars.SHOWDATABASES_ON_SELECT_ONLY.getVar(), false);
        this.SHOWTABLES_ON_SELECT_ONLY = authzBinding.getAuthzConf().getBoolean(HiveAuthzConf.AuthzConfVars.SHOWTABLES_ON_SELECT_ONLY.getVar(), false);
    }

    public static HiveAuthzPrivileges getListDatabasesPrivileges() {
        return LIST_DATABASES_PRIVILEGES;
    }

    public HiveAuthzPrivileges getListTablePrivileges() {
        if (this.SHOWTABLES_ON_SELECT_ONLY) {
            return LIST_TABLES_PRIVILEGES_ON_SELECT;
        }
        return LIST_TABLES_PRIVILEGES;
    }

    public List<T> filterDatabases(String username, List<T> dbNames) {
        if (dbNames == null) {
            return Collections.emptyList();
        }
        ArrayList filteredDatabases = Lists.newArrayList();
        for (T dbName : dbNames) {
            String objName = this.extractor.getDatabaseName(dbName);
            if (!StringUtils.isEmpty((String)objName) && !this.authorizeDatabase(username, objName)) continue;
            filteredDatabases.add(dbName);
        }
        return filteredDatabases;
    }

    public List<T> filterTables(String username, List<T> tables) {
        if (tables == null) {
            return Collections.emptyList();
        }
        ArrayList filteredTables = Lists.newArrayList();
        for (T table : tables) {
            String dbName = this.extractor.getDatabaseName(table);
            String tableName = this.extractor.getTableName(table);
            if (!StringUtils.isEmpty((String)dbName) && !this.authorizeTable(username, dbName, tableName)) continue;
            filteredTables.add(table);
        }
        return filteredTables;
    }

    private boolean authorizeDatabase(String username, String dbName) {
        if (!this.DEFAULT_DATABASE_RESTRICTED && dbName.equalsIgnoreCase("default")) {
            return true;
        }
        Database database = new Database(dbName);
        List<DBModelAuthorizable> authorizable = Arrays.asList(this.AUTH_SERVER, database, Table.ALL, Column.ALL);
        if (this.SHOWDATABASES_ON_SELECT_ONLY) {
            return this.authorize(HiveOperation.SHOWDATABASES, LIST_DATABASES_PRIVILEGES_ON_SELECT, username, authorizable);
        }
        return this.authorize(HiveOperation.SHOWDATABASES, LIST_DATABASES_PRIVILEGES, username, authorizable);
    }

    private boolean authorizeTable(String username, String dbName, String tableName) {
        Database database = new Database(dbName);
        Table table = new Table(tableName);
        List<DBModelAuthorizable> authorizable = Arrays.asList(this.AUTH_SERVER, database, table, Column.ALL);
        if (this.SHOWTABLES_ON_SELECT_ONLY) {
            return this.authorize(HiveOperation.SHOWTABLES, LIST_TABLES_PRIVILEGES_ON_SELECT, username, authorizable);
        }
        return this.authorize(HiveOperation.SHOWTABLES, LIST_TABLES_PRIVILEGES, username, authorizable);
    }

    private boolean authorize(HiveOperation op, HiveAuthzPrivileges privs, String username, List<DBModelAuthorizable> authorizable) {
        try {
            this.authzBinding.authorize(op, privs, new Subject(username), Collections.singleton(authorizable), Collections.emptySet());
        }
        catch (AuthorizationException e) {
            return false;
        }
        return true;
    }

    public static interface ObjectExtractor<T> {
        public String getDatabaseName(T var1);

        public String getTableName(T var1);
    }
}

