/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;

public class HiveAuthzPrivilegesMap {
    private static final Map<HiveOperation, HiveAuthzPrivileges> hiveAuthzStmtPrivMap = new HashMap<HiveOperation, HiveAuthzPrivileges>();

    public static HiveAuthzPrivileges getHiveAuthzPrivileges(HiveOperation hiveStmtOp) {
        return hiveAuthzStmtPrivMap.get(hiveStmtOp);
    }

    private HiveAuthzPrivilegesMap() {
    }

    static {
        HiveAuthzPrivileges createServerPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Server, EnumSet.of(DBModelAction.CREATE)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.SERVER).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges macroCreatePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.CREATE)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dropMacroPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.DROP)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges tableCreatePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.CREATE)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dropDbPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.DROP)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterDbPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALTER)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterDbSetOwnerPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).setGrantOption(true).build();
        HiveAuthzPrivileges alterTablePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALTER)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dropTablePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.DROP)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges indexTablePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INDEX)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterTableAndUriPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALTER)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges addPartitionPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALTER)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dropPartitionPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALTER)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.DROP)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterTableRenamePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.CREATE)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterTableSetOwnerPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).setGrantOption(true).build();
        HiveAuthzPrivileges alterTableExchangePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INSERT, DBModelAction.ALTER)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterPartPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALTER)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzPrivileges tableQueryPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INSERT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        HiveAuthzPrivileges tableLoadPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DATA_LOAD).build();
        HiveAuthzPrivileges tableExportPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DATA_UNLOAD).build();
        HiveAuthzPrivileges tableMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT, DBModelAction.ALTER)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzPrivileges columnMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT, DBModelAction.ALTER)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.COLUMN).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzPrivileges dbImportPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.CREATE)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges alterViewAsPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALTER)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges createViewPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.CREATE)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dbMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzPrivileges tableLockPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.LOCK)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DML).build();
        HiveAuthzPrivileges dbLockPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.LOCK)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DML).build();
        HiveAuthzPrivileges functionPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.FUNCTION).setOperationType(HiveAuthzPrivileges.HiveOperationType.DATA_LOAD).build();
        HiveAuthzPrivileges anyPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, new DBModelAction[]{DBModelAction.INSERT, DBModelAction.ALTER, DBModelAction.CREATE, DBModelAction.DROP, DBModelAction.INDEX, DBModelAction.LOCK})).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        HiveAuthzPrivileges truncateTablePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.DROP)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEDATABASE, createServerPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPDATABASE, dropDbPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATETABLE, tableCreatePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERDATABASE, alterDbPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERDATABASE_OWNER, alterDbSetOwnerPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEMACRO, macroCreatePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPMACRO, dropMacroPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPTABLE, dropTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEVIEW, createViewPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPVIEW, dropTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEINDEX, indexTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPINDEX, indexTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERINDEX_PROPS, indexTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERINDEX_REBUILD, indexTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_PROPERTIES, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_SERDEPROPERTIES, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_CLUSTER_SORT, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_FILEFORMAT, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_TOUCH, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_RENAMECOL, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_ADDCOLS, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_REPLACECOLS, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_PARTCOLTYPE, alterPartPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_EXCHANGEPARTITION, alterTableExchangePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_BUCKETNUM, alterPartPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_BUCKETNUM, alterPartPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_RENAMEPART, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_ARCHIVE, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_UNARCHIVE, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_FILEFORMAT, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_SERDEPROPERTIES, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_MERGEFILES, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_SKEWED, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_SERIALIZER, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_MERGEFILES, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERVIEW_PROPERTIES, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERVIEW_AS, alterViewAsPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERVIEW_RENAME, alterTableRenamePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_OWNER, alterTableSetOwnerPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_DROPPARTS, dropPartitionPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_ADDPARTS, addPartitionPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_RENAME, alterTableRenamePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_SERIALIZER, alterTableAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_LOCATION, alterTableAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_LOCATION, alterTableAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTBLPART_SKEWED_LOCATION, alterTableAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.MSCK, alterTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ANALYZE_TABLE, tableQueryPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SWITCHDATABASE, anyPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEFUNCTION, functionPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPFUNCTION, functionPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOWCOLUMNS, columnMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOW_TABLESTATUS, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOW_TBLPROPERTIES, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOW_CREATETABLE, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOWINDEXES, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOWPARTITIONS, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.EXPORT, tableExportPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.IMPORT, dbImportPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.LOAD, tableLoadPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.LOCKTABLE, tableLockPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.UNLOCKTABLE, tableLockPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.LOCKDB, dbLockPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.UNLOCKDB, dbLockPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATETABLE_AS_SELECT, new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.CREATE)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build());
        hiveAuthzStmtPrivMap.put(HiveOperation.QUERY, tableQueryPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DESCDATABASE, dbMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DESCTABLE, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.TRUNCATETABLE, truncateTablePrivilege);
    }
}

