/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.HiveAuthzBindingHookBase;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivilegesMap;
import org.apache.sentry.binding.hive.authz.MetastoreAuthzObjectFilter;
import org.apache.sentry.binding.hive.authz.SentryHiveAuthorizationValidator;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.util.SentryAuthorizerUtil;
import org.apache.sentry.binding.util.SimpleSemanticAnalyzer;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.Column;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSentryValidator
extends SentryHiveAuthorizationValidator {
    private final MetastoreAuthzObjectFilter.ObjectExtractor<HivePrivilegeObject> OBJECT_EXTRACTOR = new MetastoreAuthzObjectFilter.ObjectExtractor<HivePrivilegeObject>(){

        @Override
        public String getDatabaseName(HivePrivilegeObject o) {
            return o != null ? o.getDbname() : null;
        }

        @Override
        public String getTableName(HivePrivilegeObject o) {
            return o != null && this.isTable(o) ? o.getObjectName() : null;
        }

        private boolean isTable(HivePrivilegeObject o) {
            return o.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
        }
    };
    public static final Logger LOG = LoggerFactory.getLogger(DefaultSentryValidator.class);
    protected HiveConf conf;
    protected HiveAuthzConf authzConf;
    protected HiveAuthenticationProvider authenticator;
    private HiveAuthzBinding.HiveHook hiveHook;
    private static final Set<HiveOperation> EX_DB_ALL = Sets.newHashSet((Object[])new HiveOperation[]{HiveOperation.DROPDATABASE, HiveOperation.CREATETABLE, HiveOperation.IMPORT, HiveOperation.DESCDATABASE, HiveOperation.ALTERTABLE_RENAME, HiveOperation.LOCKDB, HiveOperation.UNLOCKDB});
    private static final Set<HiveOperation> EX_DB_INPUT = Sets.newHashSet((Object[])new HiveOperation[]{HiveOperation.DROPDATABASE, HiveOperation.DESCDATABASE, HiveOperation.ALTERTABLE_RENAME, HiveOperation.LOCKDB, HiveOperation.UNLOCKDB});
    private static final Set<HiveOperation> EX_TB_ALL = Sets.newHashSet((Object[])new HiveOperation[]{HiveOperation.DROPTABLE, HiveOperation.DROPVIEW, HiveOperation.DESCTABLE, HiveOperation.SHOW_TBLPROPERTIES, HiveOperation.SHOWINDEXES, HiveOperation.ALTERTABLE_PROPERTIES, HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERTABLE_TOUCH, HiveOperation.ALTERTABLE_ADDCOLS, HiveOperation.ALTERTABLE_REPLACECOLS, HiveOperation.ALTERTABLE_RENAMEPART, HiveOperation.ALTERTABLE_ARCHIVE, HiveOperation.ALTERTABLE_UNARCHIVE, HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERTABLE_SKEWED, HiveOperation.ALTERTABLE_DROPPARTS, HiveOperation.ALTERTABLE_ADDPARTS, HiveOperation.ALTERTABLE_RENAME, HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERVIEW_PROPERTIES, HiveOperation.ALTERPARTITION_FILEFORMAT, HiveOperation.ALTERPARTITION_SERIALIZER, HiveOperation.ALTERPARTITION_MERGEFILES, HiveOperation.ALTERPARTITION_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.MSCK, HiveOperation.ALTERINDEX_REBUILD, HiveOperation.LOCKTABLE, HiveOperation.UNLOCKTABLE, HiveOperation.SHOWCOLUMNS, HiveOperation.SHOW_TABLESTATUS, HiveOperation.LOAD, HiveOperation.TRUNCATETABLE});
    private static final Set<HiveOperation> EX_TB_INPUT = Sets.newHashSet((Object[])new HiveOperation[]{HiveOperation.DROPTABLE, HiveOperation.DROPVIEW, HiveOperation.SHOW_TBLPROPERTIES, HiveOperation.SHOWINDEXES, HiveOperation.ALTERINDEX_REBUILD, HiveOperation.LOCKTABLE, HiveOperation.UNLOCKTABLE, HiveOperation.SHOW_TABLESTATUS});
    private static final Set<HiveOperation> META_TB_INPUT = Sets.newHashSet((Object[])new HiveOperation[]{HiveOperation.DESCTABLE, HiveOperation.SHOWCOLUMNS});

    public DefaultSentryValidator(HiveConf conf, HiveAuthzConf authzConf, HiveAuthenticationProvider authenticator) throws Exception {
        this.initilize(conf, authzConf, authenticator);
        this.hiveHook = HiveAuthzBinding.HiveHook.HiveServer2;
    }

    public DefaultSentryValidator(HiveAuthzBinding.HiveHook hiveHook, HiveConf conf, HiveAuthzConf authzConf, HiveAuthenticationProvider authenticator) throws Exception {
        this.initilize(conf, authzConf, authenticator);
        this.hiveHook = hiveHook;
    }

    protected void initilize(HiveConf conf, HiveAuthzConf authzConf, HiveAuthenticationProvider authenticator) throws Exception {
        Preconditions.checkNotNull((Object)conf, (Object)"HiveConf cannot be null");
        Preconditions.checkNotNull((Object)authzConf, (Object)"HiveAuthzConf cannot be null");
        Preconditions.checkNotNull((Object)authenticator, (Object)"Hive authenticator provider cannot be null");
        this.conf = conf;
        this.authzConf = authzConf;
        this.authenticator = authenticator;
    }

    @Override
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            String msg = "Checking privileges for operation " + hiveOpType + " by user " + this.authenticator.getUserName() + " on  input objects " + inputHObjs + " and output objects " + outputHObjs + ". Context Info: " + context;
            LOG.debug(msg);
        }
        HiveOperation hiveOp = SentryAuthorizerUtil.convert2HiveOperation(hiveOpType.name());
        HiveAuthzPrivileges stmtAuthPrivileges = null;
        stmtAuthPrivileges = HiveOperation.DESCTABLE.equals((Object)hiveOp) && !context.getCommandString().contains("EXTENDED") && !context.getCommandString().contains("FORMATTED") ? HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(HiveOperation.SHOWCOLUMNS) : HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(hiveOp);
        try (HiveAuthzBinding hiveAuthzBinding = null;){
            hiveAuthzBinding = this.getAuthzBindingWithPrivilegeCache(this.authenticator.getUserName());
            if (stmtAuthPrivileges == null) {
                return;
            }
            Set<List<DBModelAuthorizable>> inputHierarchyList = SentryAuthorizerUtil.convert2SentryPrivilegeList(hiveAuthzBinding.getAuthServer(), inputHObjs);
            Set<List<DBModelAuthorizable>> outputHierarchyList = SentryAuthorizerUtil.convert2SentryPrivilegeList(hiveAuthzBinding.getAuthServer(), outputHObjs);
            this.addExtendHierarchy(hiveOp, stmtAuthPrivileges, inputHierarchyList, outputHierarchyList, context.getCommandString(), hiveAuthzBinding);
            hiveAuthzBinding.authorize(hiveOp, stmtAuthPrivileges, new Subject(this.authenticator.getUserName()), inputHierarchyList, outputHierarchyList);
        }
        if ("true".equalsIgnoreCase(SessionState.get().getConf().get("sentry.hive.mock.compilation"))) {
            throw new HiveAccessControlException("sentry.hive.mock.error Mock query compilation aborted. Set sentry.hive.mock.compilation to 'false' for normal query processing");
        }
    }

    public HiveAuthzBinding getAuthzBindingWithPrivilegeCache(String userName) throws Exception {
        HiveAuthzBinding hiveAuthzBinding = new HiveAuthzBinding(this.hiveHook, this.conf, this.authzConf);
        try {
            HiveAuthzBinding hiveAuthzBindingWithCache = HiveAuthzBindingHookBase.getHiveBindingWithPrivilegeCache(hiveAuthzBinding, userName);
            return hiveAuthzBindingWithCache;
        }
        catch (Exception e) {
            LOG.error("Unable to build bindings with cache. Use bindings without cache", (Throwable)e);
            return hiveAuthzBinding;
        }
    }

    private void addExtendHierarchy(HiveOperation hiveOp, HiveAuthzPrivileges stmtAuthPrivileges, Set<List<DBModelAuthorizable>> inputHierarchyList, Set<List<DBModelAuthorizable>> outputHierarchyList, String command, HiveAuthzBinding hiveAuthzBinding) throws HiveAuthzPluginException, HiveAccessControlException {
        String currDatabase = null;
        switch (stmtAuthPrivileges.getOperationScope()) {
            case SERVER: {
                ArrayList<Server> serverHierarchy = new ArrayList<Server>();
                serverHierarchy.add(hiveAuthzBinding.getAuthServer());
                inputHierarchyList.add(serverHierarchy);
                break;
            }
            case DATABASE: {
                if (!EX_DB_ALL.contains(hiveOp)) break;
                SimpleSemanticAnalyzer analyzer = new SimpleSemanticAnalyzer(hiveOp, command);
                currDatabase = analyzer.getCurrentDb();
                ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
                externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
                externalAuthorizableHierarchy.add(new Database(currDatabase));
                if (EX_DB_INPUT.contains(hiveOp)) {
                    inputHierarchyList.add(externalAuthorizableHierarchy);
                    break;
                }
                outputHierarchyList.add(externalAuthorizableHierarchy);
                break;
            }
            case TABLE: 
            case COLUMN: {
                if (!EX_TB_ALL.contains(hiveOp)) break;
                SimpleSemanticAnalyzer analyzer = new SimpleSemanticAnalyzer(hiveOp, command);
                currDatabase = analyzer.getCurrentDb();
                String currTable = analyzer.getCurrentTb();
                ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
                externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
                externalAuthorizableHierarchy.add(new Database(currDatabase));
                externalAuthorizableHierarchy.add(new Table(currTable));
                if (EX_TB_INPUT.contains(hiveOp)) {
                    inputHierarchyList.add(externalAuthorizableHierarchy);
                    break;
                }
                if (META_TB_INPUT.contains(hiveOp)) {
                    externalAuthorizableHierarchy.add(Column.SOME);
                    inputHierarchyList.add(externalAuthorizableHierarchy);
                    break;
                }
                outputHierarchyList.add(externalAuthorizableHierarchy);
                break;
            }
            case FUNCTION: {
                if (!hiveOp.equals((Object)HiveOperation.CREATEFUNCTION)) break;
                SimpleSemanticAnalyzer analyzer = new SimpleSemanticAnalyzer(hiveOp, command);
                currDatabase = analyzer.getCurrentDb();
                String udfClassName = analyzer.getCurrentTb();
                try {
                    CodeSource udfSrc = Class.forName(udfClassName).getProtectionDomain().getCodeSource();
                    if (udfSrc == null) {
                        throw new HiveAuthzPluginException("Could not resolve the jar for UDF class " + udfClassName);
                    }
                    String udfJar = udfSrc.getLocation().getPath();
                    if (udfJar == null || udfJar.isEmpty()) {
                        throw new HiveAuthzPluginException("Could not find the jar for UDF class " + udfClassName + "to validate privileges");
                    }
                    AccessURI udfURI = SentryAuthorizerUtil.parseURI(udfSrc.getLocation().toString(), true);
                    ArrayList<Object> udfUriHierarchy = new ArrayList<Object>();
                    udfUriHierarchy.add(hiveAuthzBinding.getAuthServer());
                    udfUriHierarchy.add(udfURI);
                    inputHierarchyList.add(udfUriHierarchy);
                    break;
                }
                catch (Exception e) {
                    throw new HiveAuthzPluginException("Error retrieving udf class", (Throwable)e);
                }
            }
            case CONNECT: {
                ArrayList<Object> connectHierarchy = new ArrayList<Object>();
                connectHierarchy.add(hiveAuthzBinding.getAuthServer());
                if (hiveOp.equals((Object)HiveOperation.SWITCHDATABASE)) {
                    currDatabase = command.split(" ")[1];
                }
                Table currTbl = Table.ALL;
                Database currDB = new Database(currDatabase);
                Column currCol = Column.ALL;
                if ("default".equalsIgnoreCase(currDatabase) && "false".equalsIgnoreCase(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false"))) {
                    currDB = Database.ALL;
                    currTbl = Table.SOME;
                }
                connectHierarchy.add(currDB);
                connectHierarchy.add(currTbl);
                connectHierarchy.add(currCol);
                inputHierarchyList.add(connectHierarchy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> listObjs, HiveAuthzContext context) {
        if (listObjs == null) return listObjs;
        if (listObjs.size() < 1) return listObjs;
        HivePrivilegeObject.HivePrivilegeObjectType pType = listObjs.get(0).getType();
        try (HiveAuthzBinding hiveAuthzBinding = null;){
            switch (pType) {
                case DATABASE: {
                    hiveAuthzBinding = this.getAuthzBindingWithPrivilegeCache(this.authenticator.getUserName());
                    MetastoreAuthzObjectFilter<HivePrivilegeObject> authzObjectFilter = new MetastoreAuthzObjectFilter<HivePrivilegeObject>(hiveAuthzBinding, this.OBJECT_EXTRACTOR);
                    listObjs = authzObjectFilter.filterDatabases(this.authenticator.getUserName(), listObjs);
                    return listObjs;
                }
                case TABLE_OR_VIEW: {
                    hiveAuthzBinding = this.getAuthzBindingWithPrivilegeCache(this.authenticator.getUserName());
                    MetastoreAuthzObjectFilter<HivePrivilegeObject> authzObjectFilter = new MetastoreAuthzObjectFilter<HivePrivilegeObject>(hiveAuthzBinding, this.OBJECT_EXTRACTOR);
                    listObjs = authzObjectFilter.filterTables(this.authenticator.getUserName(), listObjs);
                    return listObjs;
                }
            }
            return listObjs;
        }
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext hiveAuthzContext, List<HivePrivilegeObject> list) throws SemanticException {
        return null;
    }

    public boolean needTransform() {
        return false;
    }
}

