/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.SentryFilterDDLTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.authz.HiveAuthzBindingHookBase;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivilegesMap;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthzBindingHook
extends HiveAuthzBindingHookBase {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthzBindingHook.class);

    public HiveAuthzBindingHook() throws Exception {
        SessionState session = SessionState.get();
        if (session == null) {
            throw new IllegalStateException("Session has not been started");
        }
        SessionState.get().setAuthorizer(null);
        HiveConf hiveConf = session.getConf();
        if (hiveConf == null) {
            throw new IllegalStateException("Session HiveConf is null");
        }
    }

    public static HiveAuthzConf loadAuthzConf(HiveConf hiveConf) {
        boolean depreicatedConfigFile = false;
        HiveAuthzConf newAuthzConf = null;
        String hiveAuthzConf = hiveConf.get("hive.sentry.conf.url");
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            hiveAuthzConf = hiveConf.get("hive.access.conf.url");
            depreicatedConfigFile = true;
        }
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
        }
        try {
            newAuthzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
        }
        catch (MalformedURLException e) {
            if (depreicatedConfigFile) {
                throw new IllegalArgumentException("Configuration key hive.access.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
            }
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
        }
        return newAuthzConf;
    }

    @Override
    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        switch (ast.getToken().getType()) {
            case 657: 
            case 712: 
            case 734: 
            case 743: 
            case 941: {
                this.currDB = new Database(BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(0).getText()));
                break;
            }
            case 718: {
                for (Node childNode : ast.getChildren()) {
                    ASTNode childASTNode = (ASTNode)childNode;
                    if (!"TOK_TABLESERIALIZER".equals(childASTNode.getText())) continue;
                    ASTNode serdeNode = (ASTNode)childASTNode.getChild(0);
                    String serdeClassName = BaseSemanticAnalyzer.unescapeSQLString((String)serdeNode.getChild(0).getText());
                    this.setSerdeURI(serdeClassName);
                }
            }
            case 719: {
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 684: 
            case 692: 
            case 693: 
            case 694: 
            case 696: 
            case 697: 
            case 714: 
            case 745: 
            case 748: 
            case 749: 
            case 814: 
            case 914: 
            case 992: {
                this.currTab = this.extractTable((ASTNode)ast.getFirstChildWithType(970));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                this.indexURI = HiveAuthzBindingHook.extractTableLocation(ast);
                this.isAlterViewAs = this.isAlterViewAsOperation(ast);
                break;
            }
            case 659: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 920: {
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                int children = ast.getChildCount();
                for (int i = 1; i < children; ++i) {
                    ASTNode child = (ASTNode)ast.getChild(i);
                    if (child.getToken().getType() != 27) continue;
                    this.currDB = new Database(child.getText());
                    break;
                }
                this.currTab = Table.ALL;
                break;
            }
            case 661: 
            case 670: 
            case 678: 
            case 679: 
            case 680: 
            case 682: 
            case 908: 
            case 910: 
            case 921: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 818: {
                this.extractDbTableNameFromTOKTABLE((ASTNode)ast.getChild(1));
                break;
            }
            case 663: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                this.partitionURI = HiveAuthzBindingHook.extractPartition(ast);
                break;
            }
            case 713: {
                String udfClassName = BaseSemanticAnalyzer.unescapeSQLString((String)ast.getChild(1).getText());
                try {
                    CodeSource udfSrc = Class.forName(udfClassName, true, Utilities.getSessionSpecifiedClassLoader()).getProtectionDomain().getCodeSource();
                    if (udfSrc == null) {
                        throw new SemanticException("Could not resolve the jar for UDF class " + udfClassName);
                    }
                    String udfJar = udfSrc.getLocation().getPath();
                    if (udfJar == null || udfJar.isEmpty()) {
                        throw new SemanticException("Could not find the jar for UDF class " + udfClassName + "to validate privileges");
                    }
                    this.udfURIs.add(HiveAuthzBindingHook.parseURI(udfSrc.getLocation().toString(), true));
                }
                catch (ClassNotFoundException e) {
                    List<String> functionJars = this.getFunctionJars(ast);
                    if (functionJars.isEmpty()) {
                        throw new SemanticException("Error retrieving udf class:" + e.getMessage(), (Throwable)e);
                    }
                    for (String jar : functionJars) {
                        this.udfURIs.add(HiveAuthzBindingHook.parseURI(jar, false));
                    }
                }
                this.currDB = Database.ALL;
                break;
            }
            case 744: {
                this.currDB = Database.ALL;
                break;
            }
            case 812: {
                String dbName = BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(1).getChild(0).getChild(0).getText());
                this.currDB = new Database(dbName);
                break;
            }
            case 736: {
                this.currDB = this.getCanonicalDb();
                this.isDescTableBasic = ast.getChildCount() == 1;
                break;
            }
            case 983: {
                Preconditions.checkArgument((ast.getChildCount() == 1 ? 1 : 0) != 0);
                Preconditions.checkArgument((ast.getChild(0).getChildCount() >= 1 ? 1 : 0) != 0);
                ASTNode tableTok = (ASTNode)ast.getChild(0).getChild(0);
                Preconditions.checkArgument((tableTok.getChildCount() >= 1 ? 1 : 0) != 0);
                if (tableTok.getChildCount() == 1) {
                    this.currOutDB = this.extractDatabase((ASTNode)ast.getChild(0));
                    this.currOutTab = this.extractTable((ASTNode)tableTok.getChild(0));
                    break;
                }
                this.extractDbTableNameFromTOKTABLE(tableTok);
                break;
            }
            case 660: {
                this.currDB = this.getCanonicalDb();
                for (Node childNode : ast.getChildren()) {
                    String command;
                    ASTNode childASTNode = (ASTNode)childNode;
                    if ("TOK_ALTERTABLE_SERIALIZER".equals(childASTNode.getText())) {
                        ASTNode serdeNode = (ASTNode)childASTNode.getChild(0);
                        String serdeClassName = BaseSemanticAnalyzer.unescapeSQLString((String)serdeNode.getText());
                        this.setSerdeURI(serdeClassName);
                    }
                    if ("TOK_ALTERTABLE_RENAME".equals(childASTNode.getText())) {
                        this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                        ASTNode newTableNode = (ASTNode)childASTNode.getChild(0);
                        this.currOutDB = this.extractDatabase(newTableNode);
                    }
                    if ((command = context.getCommand()) == null || !command.toLowerCase().contains("set owner") || !"TOK_TABNAME".equals(childASTNode.getText())) continue;
                    this.extractDbTableNameFromTOKTABLE(childASTNode);
                    this.currDB = this.currOutDB;
                    this.currTab = this.currOutTab;
                }
                break;
            }
            case 656: {
                this.currDB = this.currOutDB = new Database(ast.getChild(0).getText());
                break;
            }
            default: {
                this.currDB = this.getCanonicalDb();
            }
        }
        LOG.debug("preAnalyze: For Operation={}; " + (Object)((Object)this), (Object)ast.getToken().getType());
        return ast;
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        HiveOperation stmtOperation = context.getHiveOperation();
        if (stmtOperation == HiveOperation.CREATEVIEW && this.isAlterViewAs) {
            stmtOperation = HiveOperation.ALTERVIEW_AS;
        }
        HiveAuthzPrivileges stmtAuthObject = HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(stmtOperation);
        Subject subject = this.getCurrentSubject(context);
        LOG.debug("postAnalyze: HiveOperation={}, HiveAuthzPrivileges={}, subject={}", new Object[]{stmtOperation, stmtAuthObject, subject});
        try {
            if (stmtAuthObject == null) {
                return;
            }
            for (int i = 0; i < rootTasks.size(); ++i) {
                ShowColumnsDesc showCols;
                Task<? extends Serializable> task = rootTasks.get(i);
                if (!(task instanceof DDLTask) || (showCols = ((DDLWork)((DDLTask)task).getWork()).getShowColumnsDesc()) == null) continue;
                SentryFilterDDLTask filterTask = new SentryFilterDDLTask(this.hiveAuthzBinding, subject, stmtOperation);
                filterTask.copyDDLTask((DDLTask)task);
                rootTasks.set(i, (Task<? extends Serializable>)filterTask);
            }
            this.authorizeWithHiveBindings(context, stmtAuthObject, stmtOperation);
        }
        catch (AuthorizationException e) {
            this.executeOnFailureHooks(context, stmtOperation, e);
            StringBuilder permsBuilder = new StringBuilder();
            for (String perm : this.hiveAuthzBinding.getLastQueryPrivilegeErrors()) {
                permsBuilder.append(perm);
                permsBuilder.append(";");
            }
            String permsRequired = permsBuilder.toString();
            SessionState.get().getConf().set("sentry.hive.authorization.errors", permsRequired);
            String msgForLog = "No valid privileges\n Required privileges for this query: " + permsRequired;
            String msgForConsole = "No valid privileges\n " + e.getMessage() + "\n The required privileges: " + permsRequired;
            LOG.info(msgForLog);
            throw new SemanticException(msgForConsole, (Throwable)e);
        }
        finally {
            this.hiveAuthzBinding.close();
        }
        if ("true".equalsIgnoreCase(context.getConf().get("sentry.hive.mock.compilation"))) {
            throw new SemanticException("sentry.hive.mock.error Mock query compilation aborted. Set sentry.hive.mock.compilation to 'false' for normal query processing");
        }
    }
}

