/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.web;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.server.provider.webservice.AttributeDesc;
import org.apache.sentry.server.provider.webservice.FilterDesc;
import org.apache.sentry.server.provider.webservice.ServletDesc;
import org.apache.sentry.server.provider.webservice.WebServiceProvider;
import org.apache.sentry.server.provider.webservice.WebServiceProviderFactory;
import org.apache.sentry.service.web.ConfServlet;
import org.apache.sentry.service.web.LogLevelServlet;
import org.apache.sentry.service.web.PubSubServlet;
import org.apache.sentry.service.web.SentryAuthFilter;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebServicesProvider
implements WebServiceProvider,
WebServiceProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWebServicesProvider.class);
    public static final String ID = "default";
    private static final String STATIC_RESOURCE_DIR = "/webapp";
    private Configuration config;

    public List<ServletDesc> getServlets() {
        ArrayList<ServletDesc> servlets = new ArrayList<ServletDesc>();
        servlets.add(ServletDesc.of((String)"/conf", (ServletHolder)new ServletHolder(ConfServlet.class)));
        servlets.add(ServletDesc.of((String)"/admin/logLevel", (ServletHolder)new ServletHolder(LogLevelServlet.class)));
        if (this.config.getBoolean("sentry.web.pubsub.servlet.enabled", false)) {
            servlets.add(ServletDesc.of((String)"/admin/publishMessage", (ServletHolder)new ServletHolder(PubSubServlet.class)));
        }
        if (this.config.getBoolean("sentry.web.admin.servlet.enabled", false)) {
            ServletHolder staticHolder = new ServletHolder((Servlet)new DefaultServlet());
            staticHolder.setInitParameter("pathInfoOnly", "true");
            URL url = this.getClass().getResource(STATIC_RESOURCE_DIR);
            staticHolder.setInitParameter("resourceBase", url.toString());
            servlets.add(ServletDesc.of((String)"/*", (ServletHolder)staticHolder));
        }
        return servlets;
    }

    public List<AttributeDesc> getAttributes() {
        return Arrays.asList(AttributeDesc.of((String)"sentry.conf", (Object)this.config));
    }

    public List<FilterDesc> getFilters() {
        ArrayList<FilterDesc> filters = new ArrayList<FilterDesc>();
        String authMethod = this.config.get("sentry.service.web.authentication.type");
        if (!"NONE".equalsIgnoreCase(authMethod)) {
            FilterHolder sentryAuthFilterHolder = new FilterHolder(SentryAuthFilter.class);
            sentryAuthFilterHolder.setInitParameters(DefaultWebServicesProvider.loadWebAuthenticationConf(this.config));
            filters.add(FilterDesc.of((String)"/*", (FilterHolder)sentryAuthFilterHolder, EnumSet.of(DispatcherType.REQUEST)));
        }
        return filters;
    }

    private static Map<String, String> loadWebAuthenticationConf(Configuration conf) {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("config.prefix", "sentry.service.web.authentication");
        String allowUsers = conf.get("sentry.service.web.authentication.allow.connect.users");
        if (allowUsers == null || allowUsers.equals("")) {
            allowUsers = conf.get("sentry.service.allow.connect");
            conf.set("sentry.service.web.authentication.allow.connect.users", allowUsers);
        }
        DefaultWebServicesProvider.validateConf(conf);
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith("sentry.service.web.authentication")) continue;
            String value = conf.get(name);
            prop.put(name, value);
        }
        return prop;
    }

    private static void validateConf(Configuration conf) {
        String authHandlerName = conf.get("sentry.service.web.authentication.type");
        Preconditions.checkNotNull((Object)authHandlerName, (Object)"Web authHandler should not be null.");
        String allowUsers = conf.get("sentry.service.web.authentication.allow.connect.users");
        Preconditions.checkNotNull((Object)allowUsers, (Object)"Allow connect user(s) should not be null.");
        if ("KERBEROS".equalsIgnoreCase(authHandlerName)) {
            String principal = conf.get("sentry.service.web.authentication.kerberos.principal");
            Preconditions.checkNotNull((Object)principal, (Object)"Kerberos principal should not be null.");
            Preconditions.checkArgument((principal.length() != 0 ? 1 : 0) != 0, (Object)"Kerberos principal is not right.");
            String keytabFile = conf.get("sentry.service.web.authentication.kerberos.keytab");
            Preconditions.checkNotNull((Object)keytabFile, (Object)"Keytab File should not be null.");
            Preconditions.checkArgument((keytabFile.length() != 0 ? 1 : 0) != 0, (Object)"Keytab File is not right.");
            try {
                UserGroupInformation.setConfiguration((Configuration)conf);
                String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)hostPrincipal, (String)keytabFile);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Can't use Kerberos authentication, principal [" + principal + "] keytab [" + keytabFile + "]", ex);
            }
            LOGGER.info("Using Kerberos authentication, principal [{}] keytab [{}]", (Object)principal, (Object)keytabFile);
        }
    }

    public void init(Configuration config) {
        this.config = config;
    }

    public WebServiceProvider create() {
        return this;
    }

    public String getId() {
        return ID;
    }

    public void close() {
    }
}

