/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSProcedureDispatcher
extends RemoteProcedureDispatcher<MasterProcedureEnv, ServerName>
implements ServerListener {
    private static final Logger LOG = LoggerFactory.getLogger(RSProcedureDispatcher.class);
    public static final String RS_RPC_STARTUP_WAIT_TIME_CONF_KEY = "hbase.regionserver.rpc.startup.waittime";
    private static final int DEFAULT_RS_RPC_STARTUP_WAIT_TIME = 60000;
    private static final int RS_VERSION_WITH_EXEC_PROCS = 0x200000;
    protected final MasterServices master;
    private final long rsStartupWaitTime;
    private MasterProcedureEnv procedureEnv;

    public RSProcedureDispatcher(MasterServices master) {
        super(master.getConfiguration());
        this.master = master;
        this.rsStartupWaitTime = master.getConfiguration().getLong(RS_RPC_STARTUP_WAIT_TIME_CONF_KEY, 60000L);
    }

    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Unexpected error caught, this may cause the procedure to hang forever", e);
            }
        };
    }

    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.master.getServerManager().registerListener(this);
        this.procedureEnv = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        for (ServerName serverName : this.master.getServerManager().getOnlineServersList()) {
            this.addNode((Comparable)serverName);
        }
        return true;
    }

    public boolean stop() {
        if (!super.stop()) {
            return false;
        }
        this.master.getServerManager().unregisterListener(this);
        return true;
    }

    protected void remoteDispatch(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
        int rsVersion = this.master.getServerManager().getVersionNumber(serverName);
        if (rsVersion == 0 && !this.master.getServerManager().isServerOnline(serverName)) {
            this.submitTask(new DeadRSRemoteCall(serverName, remoteProcedures));
        } else {
            this.submitTask(new ExecuteProceduresRemoteCall(serverName, remoteProcedures));
        }
    }

    protected void abortPendingOperations(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
        DoNotRetryIOException e = new DoNotRetryIOException("server not online " + serverName);
        for (RemoteProcedureDispatcher.RemoteProcedure proc : operations) {
            proc.remoteCallFailed((Object)this.procedureEnv, (Object)serverName, (IOException)e);
        }
    }

    @Override
    public void serverAdded(ServerName serverName) {
        this.addNode((Comparable)serverName);
    }

    @Override
    public void serverRemoved(ServerName serverName) {
        this.removeNode((Comparable)serverName);
    }

    public void splitAndResolveOperation(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations, RemoteProcedureResolver resolver) {
        List refreshOps;
        List closeOps;
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        ArrayListMultimap reqsByType = this.buildAndGroupRequestByType(env, (Comparable)serverName, operations);
        List openOps = this.fetchType(reqsByType, RegionOpenOperation.class);
        if (!openOps.isEmpty()) {
            resolver.dispatchOpenRequests(env, openOps);
        }
        if (!(closeOps = this.fetchType(reqsByType, RegionCloseOperation.class)).isEmpty()) {
            resolver.dispatchCloseRequests(env, closeOps);
        }
        if (!(refreshOps = this.fetchType(reqsByType, ServerOperation.class)).isEmpty()) {
            resolver.dispatchServerOperations(env, refreshOps);
        }
        if (!reqsByType.isEmpty()) {
            LOG.warn("unknown request type in the queue: " + reqsByType);
        }
    }

    protected static AdminProtos.OpenRegionRequest buildOpenRegionRequest(MasterProcedureEnv env, ServerName serverName, List<RegionOpenOperation> operations) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.setServerStartCode(serverName.getStartcode());
        builder.setMasterSystemTime(EnvironmentEdgeManager.currentTime());
        for (RegionOpenOperation op : operations) {
            builder.addOpenInfo(op.buildRegionOpenInfoRequest(env));
        }
        return builder.build();
    }

    public static class RegionCloseOperation
    extends RegionOperation {
        private final ServerName destinationServer;
        private boolean closed = false;

        public RegionCloseOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, RegionInfo regionInfo, ServerName destinationServer) {
            super(remoteProcedure, regionInfo);
            this.destinationServer = destinationServer;
        }

        public ServerName getDestinationServer() {
            return this.destinationServer;
        }

        protected void setClosed(boolean closed) {
            this.closed = closed;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName serverName) {
            return ProtobufUtil.buildCloseRegionRequest((ServerName)serverName, (byte[])this.getRegionInfo().getRegionName(), (ServerName)this.getDestinationServer());
        }
    }

    public static class RegionOpenOperation
    extends RegionOperation {
        private final List<ServerName> favoredNodes;
        private final boolean openForReplay;
        private boolean failedOpen;

        public RegionOpenOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, RegionInfo regionInfo, List<ServerName> favoredNodes, boolean openForReplay) {
            super(remoteProcedure, regionInfo);
            this.favoredNodes = favoredNodes;
            this.openForReplay = openForReplay;
        }

        protected void setFailedOpen(boolean failedOpen) {
            this.failedOpen = failedOpen;
        }

        public boolean isFailedOpen() {
            return this.failedOpen;
        }

        public AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfoRequest(MasterProcedureEnv env) {
            return RequestConverter.buildRegionOpenInfo((RegionInfo)this.getRegionInfo(), env.getAssignmentManager().getFavoredNodes(this.getRegionInfo()));
        }
    }

    public static abstract class RegionOperation
    extends RemoteProcedureDispatcher.RemoteOperation {
        private final RegionInfo regionInfo;

        protected RegionOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, RegionInfo regionInfo) {
            super(remoteProcedure);
            this.regionInfo = regionInfo;
        }

        public RegionInfo getRegionInfo() {
            return this.regionInfo;
        }
    }

    public static final class ServerOperation
    extends RemoteProcedureDispatcher.RemoteOperation {
        private final long procId;
        private final Class<?> rsProcClass;
        private final byte[] rsProcData;

        public ServerOperation(RemoteProcedureDispatcher.RemoteProcedure remoteProcedure, long procId, Class<?> rsProcClass, byte[] rsProcData) {
            super(remoteProcedure);
            this.procId = procId;
            this.rsProcClass = rsProcClass;
            this.rsProcData = rsProcData;
        }

        public AdminProtos.RemoteProcedureRequest buildRequest() {
            return AdminProtos.RemoteProcedureRequest.newBuilder().setProcId(this.procId).setProcClass(this.rsProcClass.getName()).setProcData(ByteString.copyFrom((byte[])this.rsProcData)).build();
        }
    }

    private final class CloseRegionRemoteCall
    extends AbstractRSRemoteCall {
        private final RegionCloseOperation operation;

        public CloseRegionRemoteCall(ServerName serverName, RegionCloseOperation operation) {
            super(serverName);
            this.operation = operation;
        }

        @Override
        public void run() {
            block2: {
                AdminProtos.CloseRegionRequest request = this.operation.buildCloseRegionRequest(this.getServerName());
                try {
                    AdminProtos.CloseRegionResponse response = this.sendRequest(this.getServerName(), request);
                    this.remoteCallCompleted(RSProcedureDispatcher.this.procedureEnv, response);
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block2;
                    this.remoteCallFailed(RSProcedureDispatcher.this.procedureEnv, e);
                }
            }
        }

        private AdminProtos.CloseRegionResponse sendRequest(ServerName serverName, AdminProtos.CloseRegionRequest request) throws IOException {
            try {
                return this.getRsAdmin().closeRegion(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
        }

        private void remoteCallCompleted(MasterProcedureEnv env, AdminProtos.CloseRegionResponse response) {
            this.operation.setClosed(response.getClosed());
        }

        private void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            this.operation.getRemoteProcedure().remoteCallFailed((Object)env, (Object)this.getServerName(), e);
        }
    }

    private final class OpenRegionRemoteCall
    extends AbstractRSRemoteCall {
        private final List<RegionOpenOperation> operations;

        public OpenRegionRemoteCall(ServerName serverName, List<RegionOpenOperation> operations) {
            super(serverName);
            this.operations = operations;
        }

        @Override
        public void run() {
            block2: {
                AdminProtos.OpenRegionRequest request = RSProcedureDispatcher.buildOpenRegionRequest(RSProcedureDispatcher.this.procedureEnv, this.getServerName(), this.operations);
                try {
                    this.sendRequest(this.getServerName(), request);
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block2;
                    this.remoteCallFailed(RSProcedureDispatcher.this.procedureEnv, e);
                }
            }
        }

        private AdminProtos.OpenRegionResponse sendRequest(ServerName serverName, AdminProtos.OpenRegionRequest request) throws IOException {
            try {
                return this.getRsAdmin().openRegion(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
        }

        private void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            for (RegionOpenOperation op : this.operations) {
                op.getRemoteProcedure().remoteCallFailed((Object)env, (Object)this.getServerName(), e);
            }
        }
    }

    protected class ExecuteProceduresRemoteCall
    extends AbstractRSRemoteCall
    implements RemoteProcedureResolver {
        protected final Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures;
        protected AdminProtos.ExecuteProceduresRequest.Builder request;

        public ExecuteProceduresRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            super(serverName);
            this.request = null;
            this.remoteProcedures = remoteProcedures;
        }

        @Override
        public void run() {
            block3: {
                this.request = AdminProtos.ExecuteProceduresRequest.newBuilder();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Building request with operations count=" + this.remoteProcedures.size());
                }
                RSProcedureDispatcher.this.splitAndResolveOperation(this.getServerName(), this.remoteProcedures, this);
                try {
                    this.sendRequest(this.getServerName(), this.request.build());
                }
                catch (IOException e) {
                    e = this.unwrapException(e);
                    if (this.scheduleForRetry(e)) break block3;
                    this.remoteCallFailed(RSProcedureDispatcher.this.procedureEnv, e);
                }
            }
        }

        @Override
        public void dispatchOpenRequests(MasterProcedureEnv env, List<RegionOpenOperation> operations) {
            RSProcedureDispatcher.this.submitTask(new OpenRegionRemoteCall(this.getServerName(), operations));
        }

        @Override
        public void dispatchCloseRequests(MasterProcedureEnv env, List<RegionCloseOperation> operations) {
            for (RegionCloseOperation op : operations) {
                RSProcedureDispatcher.this.submitTask(new CloseRegionRemoteCall(this.getServerName(), op));
            }
        }

        @Override
        public void dispatchServerOperations(MasterProcedureEnv env, List<ServerOperation> operations) {
            operations.stream().map(o -> o.buildRequest()).forEachOrdered(arg_0 -> ((AdminProtos.ExecuteProceduresRequest.Builder)this.request).addProc(arg_0));
        }

        protected AdminProtos.ExecuteProceduresResponse sendRequest(ServerName serverName, AdminProtos.ExecuteProceduresRequest request) throws IOException {
            try {
                return this.getRsAdmin().executeProcedures(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
        }

        protected void remoteCallFailed(MasterProcedureEnv env, IOException e) {
            for (RemoteProcedureDispatcher.RemoteProcedure proc : this.remoteProcedures) {
                proc.remoteCallFailed((Object)env, (Object)this.getServerName(), e);
            }
        }
    }

    private class DeadRSRemoteCall
    extends ExecuteProceduresRemoteCall {
        public DeadRSRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            super(serverName, remoteProcedures);
        }

        @Override
        public void run() {
            this.remoteCallFailed(RSProcedureDispatcher.this.procedureEnv, (IOException)new RegionServerStoppedException("Server " + this.getServerName() + " is not online"));
        }
    }

    private static interface RemoteProcedureResolver {
        public void dispatchOpenRequests(MasterProcedureEnv var1, List<RegionOpenOperation> var2);

        public void dispatchCloseRequests(MasterProcedureEnv var1, List<RegionCloseOperation> var2);

        public void dispatchServerOperations(MasterProcedureEnv var1, List<ServerOperation> var2);
    }

    protected abstract class AbstractRSRemoteCall
    implements Runnable {
        private final ServerName serverName;
        private int numberOfAttemptsSoFar = 0;
        private long maxWaitTime = -1L;

        public AbstractRSRemoteCall(ServerName serverName) {
            this.serverName = serverName;
        }

        protected AdminProtos.AdminService.BlockingInterface getRsAdmin() throws IOException {
            AdminProtos.AdminService.BlockingInterface admin = RSProcedureDispatcher.this.master.getServerManager().getRsAdmin(this.serverName);
            if (admin == null) {
                throw new IOException("Attempting to send OPEN RPC to server " + this.getServerName() + " failed because no RPC connection found to this server");
            }
            return admin;
        }

        protected ServerName getServerName() {
            return this.serverName;
        }

        protected boolean scheduleForRetry(IOException e) {
            LOG.debug("request to {} failed, try={}", new Object[]{this.serverName, this.numberOfAttemptsSoFar, e});
            if (e instanceof ServerNotRunningYetException) {
                long remainingTime = this.getMaxWaitTime() - EnvironmentEdgeManager.currentTime();
                if (remainingTime > 0L) {
                    LOG.warn("waiting a little before trying on the same server={}, try={}, can wait up to {}ms", new Object[]{this.serverName, this.numberOfAttemptsSoFar, remainingTime});
                    ++this.numberOfAttemptsSoFar;
                    RSProcedureDispatcher.this.submitTask(this, 100L, TimeUnit.MILLISECONDS);
                    return true;
                }
                LOG.warn("server {} is not up for a while; try a new one", (Object)this.serverName);
                return false;
            }
            boolean queueFull = e instanceof CallQueueTooBigException;
            if (queueFull && this.numberOfAttemptsSoFar == 0) {
                LOG.warn("request to {} failed due to {}, try={}, this usually because server is overloaded, give up", new Object[]{this.serverName, e.toString(), this.numberOfAttemptsSoFar});
                return false;
            }
            if ((queueFull || ClientExceptionsUtil.isConnectionException((Throwable)e)) && RSProcedureDispatcher.this.master.getServerManager().isServerOnline(this.serverName)) {
                LOG.debug("Retrying to same RegionServer {} because: {}", (Object)this.serverName, (Object)e.getMessage());
                ++this.numberOfAttemptsSoFar;
                RSProcedureDispatcher.this.submitTask(this, 100L, TimeUnit.MILLISECONDS);
                return true;
            }
            LOG.warn("Failed dispatch to server={} try={}", new Object[]{this.serverName, this.numberOfAttemptsSoFar, e});
            return false;
        }

        private long getMaxWaitTime() {
            if (this.maxWaitTime < 0L) {
                this.maxWaitTime = EnvironmentEdgeManager.currentTime() + RSProcedureDispatcher.this.rsStartupWaitTime;
            }
            return this.maxWaitTime;
        }

        protected IOException unwrapException(IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)((Object)e)).unwrapRemoteException();
            }
            return e;
        }
    }
}

