/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDateTime;
import org.joda.time.chrono.ISOChronology;

public class LocalInterval {
    private final long start;
    private final long end;

    private LocalInterval(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public static LocalInterval create(DateTime start, DateTime end) {
        return new LocalInterval(start.getMillis(), end.getMillis());
    }

    public static LocalInterval create(long start, long end) {
        return new LocalInterval(start, end);
    }

    public static LocalInterval create(String intervalString) {
        Interval i = new Interval((Object)intervalString, (Chronology)ISOChronology.getInstanceUTC());
        return new LocalInterval(i.getStartMillis(), i.getEndMillis());
    }

    public static LocalInterval create(String start, String end) {
        return LocalInterval.create(new DateTime((Object)start, (Chronology)ISOChronology.getInstanceUTC()), new DateTime((Object)end, (Chronology)ISOChronology.getInstanceUTC()));
    }

    public String toString() {
        LocalDateTime start = new LocalDateTime(this.start, (Chronology)ISOChronology.getInstanceUTC());
        LocalDateTime end = new LocalDateTime(this.end, (Chronology)ISOChronology.getInstanceUTC());
        return start + "/" + end;
    }

    public int hashCode() {
        int result = 97;
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof LocalInterval && this.start == ((LocalInterval)o).start && this.end == ((LocalInterval)o).end;
    }

    public long getStartMillis() {
        return this.start;
    }

    public long getEndMillis() {
        return this.end;
    }
}

