/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.slider.providers.agent.application.metadata.Component;
import org.apache.slider.providers.agent.application.metadata.DockerContainer;
import org.apache.slider.providers.agent.application.metadata.DockerContainerInputFile;
import org.apache.slider.providers.agent.application.metadata.DockerContainerMount;
import org.apache.slider.providers.agent.application.metadata.DockerContainerPort;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.server.appmaster.web.rest.agent.AgentCommandType;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ExecutionCommand {
    protected static final Logger log = LoggerFactory.getLogger(ExecutionCommand.class);
    private AgentCommandType commandType = AgentCommandType.EXECUTION_COMMAND;
    private String clusterName;
    private long taskId;
    private String commandId;
    private String hostname;
    private String role;
    private Map<String, String> hostLevelParams = new HashMap<String, String>();
    private Map<String, String> roleParams = null;
    private String roleCommand;
    private Map<String, Map<String, String>> configurations;
    private Map<String, Map<String, String>> componentConfigurations;
    private Map<String, String> commandParams;
    private String serviceName;
    private String componentName;
    private String componentType;
    private List<DockerContainer> containers = new ArrayList<DockerContainer>();
    private String pkg;

    public ExecutionCommand(AgentCommandType commandType) {
        this.commandType = commandType;
    }

    @JsonProperty(value="commandType")
    public AgentCommandType getCommandType() {
        return this.commandType;
    }

    @JsonProperty(value="commandType")
    public void setCommandType(AgentCommandType commandType) {
        this.commandType = commandType;
    }

    @JsonProperty(value="commandId")
    public String getCommandId() {
        return this.commandId;
    }

    @JsonProperty(value="commandId")
    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    @JsonProperty(value="taskId")
    public long getTaskId() {
        return this.taskId;
    }

    @JsonProperty(value="taskId")
    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty(value="roleParams")
    public Map<String, String> getRoleParams() {
        return this.roleParams;
    }

    @JsonProperty(value="roleParams")
    public void setRoleParams(Map<String, String> roleParams) {
        this.roleParams = roleParams;
    }

    @JsonProperty(value="roleCommand")
    public String getRoleCommand() {
        return this.roleCommand;
    }

    @JsonProperty(value="roleCommand")
    public void setRoleCommand(String cmd) {
        this.roleCommand = cmd;
    }

    @JsonProperty(value="clusterName")
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="componentType")
    public String getComponentType() {
        return this.componentType;
    }

    @JsonProperty(value="componentType")
    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonProperty(value="hostLevelParams")
    public Map<String, String> getHostLevelParams() {
        return this.hostLevelParams;
    }

    @JsonProperty(value="hostLevelParams")
    public void setHostLevelParams(Map<String, String> params) {
        this.hostLevelParams = params;
    }

    @JsonProperty(value="configurations")
    public Map<String, Map<String, String>> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="configurations")
    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        this.configurations = configurations;
    }

    @JsonProperty(value="commandParams")
    public Map<String, String> getCommandParams() {
        return this.commandParams;
    }

    @JsonProperty(value="commandParams")
    public void setCommandParams(Map<String, String> commandParams) {
        this.commandParams = commandParams;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @JsonProperty(value="componentName")
    public String getComponentName() {
        return this.componentName;
    }

    @JsonProperty(value="componentName")
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @JsonProperty(value="package")
    public String getPkg() {
        return this.pkg;
    }

    @JsonProperty(value="package")
    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    @JsonProperty(value="componentConfig")
    public Map<String, Map<String, String>> getComponentConfigurations() {
        return this.componentConfigurations;
    }

    @JsonProperty(value="componentConfig")
    public void setComponentConfigurations(Map<String, Map<String, String>> componentConfigurations) {
        this.componentConfigurations = componentConfigurations;
    }

    @JsonProperty(value="containers")
    public List<DockerContainer> getContainers() {
        return this.containers;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExecutionCommand [commandType=").append((Object)this.commandType).append(", clusterName=").append(this.clusterName).append(", taskId=").append(this.taskId).append(", commandId=").append(this.commandId).append(", hostname=").append(this.hostname).append(", role=").append(this.role).append(", hostLevelParams=").append(this.hostLevelParams).append(", roleParams=").append(this.roleParams).append(", roleCommand=").append(this.roleCommand).append(", configurations=").append(this.configurations).append(", commandParams=").append(this.commandParams).append(", serviceName=").append(this.serviceName).append(", componentName=").append(this.componentName).append(", componentType=").append(this.componentType).append(", pkg=").append(this.pkg).append("]");
        return builder.toString();
    }

    public void addContainerDetails(String componentName, Metainfo metaInfo) {
        Component component = metaInfo.getApplicationComponent(componentName);
        this.setComponentType(component.getType());
        log.info("Adding container details for {}", new Object[]{componentName, " from ", metaInfo.toString()});
        for (DockerContainer metaContainer : component.getDockerContainers()) {
            DockerContainer container = new DockerContainer();
            container.setImage(metaContainer.getImage());
            container.setName(metaContainer.getName());
            container.setOptions(metaContainer.getOptions());
            container.setAdditionalParam(metaContainer.getAdditionalParam());
            container.setCommandPath(metaContainer.getAdditionalParam());
            container.setStatusCommand(metaContainer.getStatusCommand());
            if (metaContainer.getMounts().size() > 0) {
                for (DockerContainerMount metaContMount : metaContainer.getMounts()) {
                    DockerContainerMount contMnt = new DockerContainerMount();
                    contMnt.setContainerMount(metaContMount.getContainerMount());
                    contMnt.setHostMount(metaContMount.getHostMount());
                    container.getMounts().add(contMnt);
                }
            }
            if (metaContainer.getPorts().size() > 0) {
                for (DockerContainerPort metaCntPort : metaContainer.getPorts()) {
                    DockerContainerPort cntPort = new DockerContainerPort();
                    cntPort.setContainerPort(metaCntPort.getContainerPort());
                    cntPort.setHostPort(metaCntPort.getHostPort());
                    container.getPorts().add(cntPort);
                }
            }
            if (metaContainer.getInputFiles().size() > 0) {
                for (DockerContainerInputFile metaInpFile : metaContainer.getInputFiles()) {
                    DockerContainerInputFile inpFile = new DockerContainerInputFile();
                    inpFile.setContainerMount(metaInpFile.getContainerMount());
                    inpFile.setFileLocalPath(metaInpFile.getFileLocalPath());
                    container.getInputFiles().add(inpFile);
                }
            }
            log.info("Docker container meta info ready: " + container.toString());
            this.getContainers().add(container);
        }
    }
}

