/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web;

import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.codahale.metrics.servlets.PingServlet;
import com.codahale.metrics.servlets.ThreadDumpServlet;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.yarn.webapp.Dispatcher;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.web.SliderAMController;
import org.apache.slider.server.appmaster.web.SliderDefaultWrapperServlet;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.AMWebServices;
import org.apache.slider.server.appmaster.web.rest.SliderJacksonJaxbJsonProvider;

public class SliderAMWebApp
extends WebApp {
    public static final String BASE_PATH = "slideram";
    public static final String CONTAINER_STATS = "/stats";
    public static final String CLUSTER_SPEC = "/spec";
    private final WebAppApi webAppApi;

    public SliderAMWebApp(WebAppApi webAppApi) {
        Preconditions.checkArgument((webAppApi != null ? 1 : 0) != 0, (Object)"webAppApi null");
        this.webAppApi = webAppApi;
    }

    public void setup() {
        Logger.getLogger("com.sun.jersey").setLevel(Level.FINEST);
        this.bind(SliderJacksonJaxbJsonProvider.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(AMWebServices.class);
        this.route("/", SliderAMController.class);
        this.route(CONTAINER_STATS, SliderAMController.class, "containerStats");
        this.route(CLUSTER_SPEC, SliderAMController.class, "specification");
    }

    public void configureServlets() {
        this.setup();
        this.serve("/", new String[]{"/__stop"}).with(Dispatcher.class);
        String[] stringArray = this.getServePathSpecs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.serve(path, new String[0]).with(Dispatcher.class);
            ++n2;
        }
        MetricsAndMonitoring monitoring = this.webAppApi.getMetricsAndMonitoring();
        this.serve("/system/health", new String[0]).with((HttpServlet)new HealthCheckServlet(monitoring.getHealth()));
        this.serve("/system/metrics", new String[0]).with((HttpServlet)new MetricsServlet(monitoring.getMetrics()));
        this.serve("/system/ping", new String[0]).with((HttpServlet)new PingServlet());
        this.serve("/system/threads", new String[0]).with((HttpServlet)new ThreadDumpServlet());
        String regex = "(?!/ws)";
        this.serveRegex(regex, new String[0]).with(SliderDefaultWrapperServlet.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("com.sun.jersey.config.feature.ImplicitViewables", "true");
        params.put("com.sun.jersey.config.feature.FilterForwardOn404", "true");
        params.put("com.sun.jersey.config.feature.XmlRootElementProcessing", "true");
        params.put("com.sun.jersey.spi.container.ContainerRequestFilters", GZIPContentEncodingFilter.class.getName());
        params.put("com.sun.jersey.spi.container.ContainerResponseFilters", GZIPContentEncodingFilter.class.getName());
        params.put("com.sun.jersey.config.property.WadlGeneratorConfig", "org.apache.slider.server.appmaster.web.rest.AMWadlGeneratorConfig");
        this.filter("/*", new String[0]).through(GuiceContainer.class, params);
    }
}

