/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.server.appmaster.management.BoolMetric;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.management.Timestamp;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.state.AbstractClusterServices;
import org.apache.slider.server.appmaster.state.ContainerAllocationResults;
import org.apache.slider.server.appmaster.state.ContainerOutcome;
import org.apache.slider.server.appmaster.state.ContainerPriority;
import org.apache.slider.server.appmaster.state.NodeEntry;
import org.apache.slider.server.appmaster.state.NodeInstance;
import org.apache.slider.server.appmaster.state.NodeMap;
import org.apache.slider.server.appmaster.state.OutstandingRequest;
import org.apache.slider.server.appmaster.state.OutstandingRequestTracker;
import org.apache.slider.server.appmaster.state.RoleHistoryUtils;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.apache.slider.server.avro.LoadedRoleHistory;
import org.apache.slider.server.avro.NodeEntryRecord;
import org.apache.slider.server.avro.RoleHistoryHeader;
import org.apache.slider.server.avro.RoleHistoryWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleHistory {
    protected static final Logger log = LoggerFactory.getLogger(RoleHistory.class);
    private final List<ProviderRole> providerRoles;
    private final Map<Integer, RoleStatus> roleStatusMap = new HashMap<Integer, RoleStatus>();
    private final AbstractClusterServices recordFactory;
    private long startTime;
    private final Timestamp saveTime = new Timestamp(0L);
    private final Timestamp thawedDataTime = new Timestamp(0L);
    private NodeMap nodemap;
    private int roleSize;
    private final BoolMetric dirty = new BoolMetric(false);
    private FileSystem filesystem;
    private Path historyPath;
    private RoleHistoryWriter historyWriter = new RoleHistoryWriter();
    private final Timestamp nodesUpdatedTime = new Timestamp(0L);
    private final BoolMetric nodeUpdateReceived = new BoolMetric(false);
    private OutstandingRequestTracker outstandingRequests = new OutstandingRequestTracker();
    private Map<Integer, LinkedList<NodeInstance>> recentNodes;

    public RoleHistory(Collection<RoleStatus> roles, AbstractClusterServices recordFactory) throws BadConfigException {
        this.recordFactory = recordFactory;
        this.roleSize = roles.size();
        this.providerRoles = new ArrayList<ProviderRole>(this.roleSize);
        for (RoleStatus role : roles) {
            this.addNewRole(role);
        }
        this.reset();
    }

    protected synchronized void reset() throws BadConfigException {
        this.nodemap = new NodeMap(this.roleSize);
        this.resetAvailableNodeLists();
        this.outstandingRequests = new OutstandingRequestTracker();
    }

    public void register(MetricsAndMonitoring metrics) {
        metrics.register(RoleHistory.class, this.dirty, "dirty");
        metrics.register(RoleHistory.class, this.nodesUpdatedTime, "nodes-updated.time");
        metrics.register(RoleHistory.class, this.nodeUpdateReceived, "nodes-updated.flag");
        metrics.register(RoleHistory.class, this.thawedDataTime, "thawed.time");
        metrics.register(RoleHistory.class, this.saveTime, "saved.time");
    }

    protected void putRole(RoleStatus roleStatus) throws BadConfigException {
        int index = roleStatus.getKey();
        if (index < 0) {
            throw new BadConfigException("Provider " + roleStatus + " id is out of range");
        }
        if (this.roleStatusMap.get(index) != null) {
            throw new BadConfigException(String.valueOf(roleStatus.toString()) + " id duplicates that of " + this.roleStatusMap.get(index));
        }
        this.roleStatusMap.put(index, roleStatus);
    }

    public void addNewRole(RoleStatus roleStatus) throws BadConfigException {
        log.debug("Validating/adding new role to role history: {} ", (Object)roleStatus);
        this.putRole(roleStatus);
        this.providerRoles.add(roleStatus.getProviderRole());
    }

    public ProviderRole lookupRole(int roleId) {
        for (ProviderRole role : this.providerRoles) {
            if (role.id != roleId) continue;
            return role;
        }
        return null;
    }

    private synchronized void resetAvailableNodeLists() {
        this.recentNodes = new ConcurrentHashMap<Integer, LinkedList<NodeInstance>>(this.roleSize);
    }

    private void prepareForReading(RoleHistoryHeader header) throws BadConfigException {
        this.reset();
        int roleCountInSource = header.getRoles();
        if (roleCountInSource != this.roleSize) {
            log.warn("Number of roles in source {} does not match the expected number of {}", (Object)roleCountInSource, (Object)this.roleSize);
        }
        this.setThawedDataTime(header.getSaved());
    }

    @VisibleForTesting
    public synchronized int rebuild(LoadedRoleHistory loadedRoleHistory) throws BadConfigException {
        RoleHistoryHeader header = loadedRoleHistory.getHeader();
        this.prepareForReading(header);
        int discarded = 0;
        Long saved = header.getSaved();
        for (NodeEntryRecord nodeEntryRecord : loadedRoleHistory.records) {
            Integer roleId = nodeEntryRecord.getRole();
            NodeEntry nodeEntry = new NodeEntry(roleId);
            nodeEntry.setLastUsed(nodeEntryRecord.getLastUsed());
            if (nodeEntryRecord.getActive().booleanValue()) {
                nodeEntry.setLastUsed(saved);
            }
            String hostname = SliderUtils.sequenceToString(nodeEntryRecord.getHost());
            ProviderRole providerRole = this.lookupRole(roleId);
            if (providerRole == null) {
                log.info("Discarding history entry with unknown role: {} on host {}", (Object)roleId, (Object)hostname);
                ++discarded;
                continue;
            }
            NodeInstance instance = this.getOrCreateNodeInstance(hostname);
            instance.set(roleId, nodeEntry);
        }
        return discarded;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized long getSaveTime() {
        return this.saveTime.get();
    }

    public long getThawedDataTime() {
        return this.thawedDataTime.get();
    }

    public void setThawedDataTime(long thawedDataTime) {
        this.thawedDataTime.set(thawedDataTime);
    }

    public synchronized int getRoleSize() {
        return this.roleSize;
    }

    public synchronized int getClusterSize() {
        return this.nodemap.size();
    }

    public synchronized boolean isDirty() {
        return this.dirty.get();
    }

    public synchronized void setDirty(boolean dirty) {
        this.dirty.set(dirty);
    }

    public synchronized void saved(long timestamp) {
        this.setDirty(false);
        this.saveTime.set(timestamp);
    }

    public synchronized NodeMap cloneNodemap() {
        return (NodeMap)this.nodemap.clone();
    }

    public synchronized Map<String, NodeInformation> getNodeInformationSnapshot(Map<Integer, String> naming) {
        HashMap<String, NodeInformation> result = new HashMap<String, NodeInformation>(this.nodemap.size());
        for (Map.Entry entry : this.nodemap.entrySet()) {
            result.put((String)entry.getKey(), ((NodeInstance)entry.getValue()).serialize(naming));
        }
        return result;
    }

    public NodeInformation getNodeInformation(String hostname, Map<Integer, String> naming) {
        NodeInstance nodeInstance = (NodeInstance)this.nodemap.get(hostname);
        return nodeInstance != null ? nodeInstance.serialize(naming) : null;
    }

    public synchronized NodeInstance getOrCreateNodeInstance(String hostname) {
        return this.nodemap.getOrCreate(hostname);
    }

    @VisibleForTesting
    public synchronized void insert(Collection<NodeInstance> nodes) {
        this.nodemap.insert(nodes);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public void touch() {
        this.setDirty(true);
        try {
            this.saveHistoryIfDirty();
        }
        catch (IOException e) {
            log.warn("Failed to save history file ", (Throwable)e);
        }
    }

    public synchronized void resetFailedRecently() {
        log.info("Resetting failure history");
        this.nodemap.resetFailedRecently();
    }

    public Path getHistoryPath() {
        return this.historyPath;
    }

    @VisibleForTesting
    public synchronized Path saveHistory(long time) throws IOException {
        Path filename = this.historyWriter.createHistoryFilename(this.historyPath, time);
        this.historyWriter.write(this.filesystem, filename, true, this, time);
        this.saved(time);
        return filename;
    }

    public synchronized Path saveHistoryIfDirty() throws IOException {
        if (this.isDirty()) {
            return this.saveHistory(this.now());
        }
        return null;
    }

    public boolean onStart(FileSystem fs, Path historyDir) throws BadConfigException {
        assert (this.filesystem == null);
        this.filesystem = fs;
        this.historyPath = historyDir;
        this.startTime = this.now();
        return this.onThaw();
    }

    public void onBootstrap() {
        log.debug("Role history bootstrapped");
    }

    public synchronized boolean onThaw() throws BadConfigException {
        assert (this.filesystem != null);
        assert (this.historyPath != null);
        boolean thawSuccessful = false;
        LoadedRoleHistory loadedRoleHistory = null;
        try {
            loadedRoleHistory = this.historyWriter.loadFromHistoryDir(this.filesystem, this.historyPath);
        }
        catch (IOException e) {
            log.warn("Exception trying to load history from {}", (Object)this.historyPath, (Object)e);
        }
        if (loadedRoleHistory != null) {
            this.rebuild(loadedRoleHistory);
            thawSuccessful = true;
            Path loadPath = loadedRoleHistory.getPath();
            log.debug("loaded history from {}", (Object)loadPath);
            try {
                int count = this.historyWriter.purgeOlderHistoryEntries(this.filesystem, loadPath);
                log.debug("Deleted {} old history entries", (Object)count);
            }
            catch (IOException e) {
                log.info("Ignoring exception raised while trying to delete old entries", (Throwable)e);
            }
            this.buildRecentNodeLists();
        } else {
            this.onBootstrap();
        }
        return thawSuccessful;
    }

    @VisibleForTesting
    public synchronized void buildRecentNodeLists() {
        this.resetAvailableNodeLists();
        for (Map.Entry entry : this.nodemap.entrySet()) {
            NodeInstance ni = (NodeInstance)entry.getValue();
            int i = 0;
            while (i < this.roleSize) {
                NodeEntry nodeEntry = ni.get(i);
                if (nodeEntry != null && nodeEntry.isAvailable()) {
                    log.debug("Adding {} for role {}", (Object)ni, (Object)i);
                    this.listRecentNodesForRoleId(i).add(ni);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.roleSize) {
            this.sortRecentNodeList(i);
            ++i;
        }
    }

    @VisibleForTesting
    public List<NodeInstance> getRecentNodesForRoleId(int id) {
        return this.recentNodes.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<NodeInstance> listRecentNodesForRoleId(int id) {
        LinkedList<NodeInstance> instances = this.recentNodes.get(id);
        if (instances == null) {
            RoleHistory roleHistory = this;
            synchronized (roleHistory) {
                if (this.recentNodes.get(id) == null) {
                    this.recentNodes.put(id, new LinkedList());
                }
                instances = this.recentNodes.get(id);
            }
        }
        return instances;
    }

    private void sortRecentNodeList(int role) {
        List<NodeInstance> nodesForRoleId = this.getRecentNodesForRoleId(role);
        if (nodesForRoleId != null) {
            Collections.sort(nodesForRoleId, new NodeInstance.Preferred(role));
        }
    }

    @VisibleForTesting
    public synchronized NodeInstance findRecentNodeForNewInstance(RoleStatus role) {
        if (!role.isPlacementDesired()) {
            return null;
        }
        int roleId = role.getKey();
        boolean strictPlacement = role.isStrictPlacement();
        NodeInstance nodeInstance = null;
        List<NodeInstance> targets = this.getRecentNodesForRoleId(roleId);
        if (targets == null) {
            return null;
        }
        int cnt = targets.size();
        log.debug("There are {} node(s) to consider for {}", (Object)cnt, (Object)role.getName());
        int i = 0;
        while (i < cnt && nodeInstance == null) {
            NodeInstance candidate = targets.get(i);
            if (candidate.getActiveRoleInstances(roleId) == 0) {
                if (strictPlacement || candidate.isOnline() && !candidate.exceedsFailureThreshold(role)) {
                    targets.remove(i);
                    nodeInstance = candidate;
                } else {
                    log.info("Recent node failures is higher than threshold {}. Not requesting host {}", (Object)role.getNodeFailureThreshold(), (Object)candidate.hostname);
                }
            }
            ++i;
        }
        if (nodeInstance == null) {
            log.info("No node found for {}", (Object)role.getName());
        }
        return nodeInstance;
    }

    @VisibleForTesting
    public synchronized List<NodeInstance> findNodeForNewAAInstance(RoleStatus role) {
        return this.nodemap.findAllNodesForRole(role.getKey(), role.getLabelExpression());
    }

    public synchronized OutstandingRequest requestInstanceOnNode(NodeInstance node, RoleStatus role, Resource resource) {
        OutstandingRequest outstanding = this.outstandingRequests.newRequest(node, role.getKey());
        outstanding.buildContainerRequest(resource, role, this.now());
        return outstanding;
    }

    public synchronized OutstandingRequest requestContainerForRole(RoleStatus role) {
        if (role.isAntiAffinePlacement()) {
            return this.requestContainerForAARole(role);
        }
        Resource resource = this.recordFactory.newResource();
        role.copyResourceRequirements(resource);
        NodeInstance node = this.findRecentNodeForNewInstance(role);
        return this.requestInstanceOnNode(node, role, resource);
    }

    public synchronized OutstandingRequest requestContainerForAARole(RoleStatus role) {
        List<NodeInstance> nodes = this.findNodeForNewAAInstance(role);
        if (!nodes.isEmpty()) {
            OutstandingRequest outstanding = this.outstandingRequests.newAARequest(role.getKey(), nodes, role.getLabelExpression());
            Resource resource = this.recordFactory.newResource();
            role.copyResourceRequirements(resource);
            outstanding.buildContainerRequest(resource, role, this.now());
            return outstanding;
        }
        log.warn("No suitable location for {}", (Object)role.getName());
        return null;
    }

    public synchronized List<NodeInstance> listActiveNodes(int role) {
        return this.nodemap.listActiveNodes(role);
    }

    public NodeEntry getOrCreateNodeEntry(Container container) {
        return this.getOrCreateNodeInstance(container).getOrCreate(container);
    }

    public synchronized NodeInstance getOrCreateNodeInstance(Container container) {
        return this.nodemap.getOrCreate(RoleHistoryUtils.hostnameOf(container));
    }

    public synchronized NodeInstance getExistingNodeInstance(String hostname) {
        return (NodeInstance)this.nodemap.get(hostname);
    }

    public synchronized NodeInstance getExistingNodeInstance(Container container) {
        return (NodeInstance)this.nodemap.get(RoleHistoryUtils.hostnameOf(container));
    }

    public synchronized List<Container> prepareAllocationList(List<Container> allocatedContainers) {
        ArrayList<Container> requested = new ArrayList<Container>(allocatedContainers.size());
        ArrayList<Container> unrequested = new ArrayList<Container>(allocatedContainers.size());
        this.outstandingRequests.partitionRequests(this, allocatedContainers, requested, unrequested);
        requested.addAll(unrequested);
        return requested;
    }

    public synchronized ContainerAllocationResults onContainerAllocated(Container container, long desiredCount, long actualCount) {
        List<NodeInstance> hosts;
        int role = ContainerPriority.extractRole(container);
        String hostname = RoleHistoryUtils.hostnameOf(container);
        LinkedList<NodeInstance> nodeInstances = this.listRecentNodesForRoleId(role);
        ContainerAllocationResults outcome = this.outstandingRequests.onContainerAllocated(role, hostname, container);
        if (desiredCount <= actualCount && !(hosts = this.outstandingRequests.resetOutstandingRequests(role)).isEmpty()) {
            log.info("Adding {} hosts for role {}", (Object)hosts.size(), (Object)role);
            nodeInstances.addAll(hosts);
            this.sortRecentNodeList(role);
        }
        return outcome;
    }

    public void onContainerAssigned(Container container) {
        NodeInstance node = this.getOrCreateNodeInstance(container);
        NodeEntry nodeEntry = node.getOrCreate(container);
        nodeEntry.onStarting();
        log.debug("Node {} has updated NodeEntry {}", (Object)node, (Object)nodeEntry);
    }

    public void onContainerStartSubmitted(Container container, RoleInstance instance) {
    }

    public void onContainerStarted(Container container) {
        NodeEntry nodeEntry = this.getOrCreateNodeEntry(container);
        nodeEntry.onStartCompleted();
        this.touch();
    }

    public boolean onNodeManagerContainerStartFailed(Container container) {
        return this.markContainerFinished(container, false, true, ContainerOutcome.Failed);
    }

    public boolean canPlaceAANodes() {
        return this.nodeUpdateReceived.get();
    }

    public long getNodesUpdatedTime() {
        return this.nodesUpdatedTime.get();
    }

    public synchronized boolean onNodesUpdated(List<NodeReport> updatedNodes) {
        log.debug("Updating {} nodes", (Object)updatedNodes.size());
        this.nodesUpdatedTime.set(this.now());
        this.nodeUpdateReceived.set(true);
        int printed = 0;
        boolean triggerReview = false;
        for (NodeReport updatedNode : updatedNodes) {
            String hostname = updatedNode.getNodeId() == null ? "" : updatedNode.getNodeId().getHost();
            NodeState nodeState = updatedNode.getNodeState();
            if (hostname.isEmpty() || nodeState == null) {
                log.warn("Ignoring incomplete update");
                continue;
            }
            if (log.isDebugEnabled() && printed++ < 10) {
                log.debug("Node \"{}\" is in state {}", (Object)hostname, (Object)nodeState);
            }
            boolean updated = this.nodemap.updateNode(hostname, updatedNode);
            triggerReview |= updated;
        }
        return triggerReview;
    }

    public void onContainerReleaseSubmitted(Container container) {
        NodeEntry nodeEntry = this.getOrCreateNodeEntry(container);
        nodeEntry.release();
    }

    public boolean onReleaseCompleted(Container container) {
        return this.markContainerFinished(container, true, false, ContainerOutcome.Failed);
    }

    public boolean onFailedContainer(Container container, boolean shortLived, ContainerOutcome outcome) {
        return this.markContainerFinished(container, false, shortLived, outcome);
    }

    protected synchronized boolean markContainerFinished(Container container, boolean wasReleased, boolean shortLived, ContainerOutcome outcome) {
        boolean available;
        NodeEntry nodeEntry = this.getOrCreateNodeEntry(container);
        log.info("Finished container for node {}, released={}, shortlived={}", new Object[]{nodeEntry.rolePriority, wasReleased, shortLived});
        if (shortLived) {
            nodeEntry.onStartFailed();
            available = false;
        } else {
            available = nodeEntry.containerCompleted(wasReleased, outcome);
            this.maybeQueueNodeForWork(container, nodeEntry, available);
        }
        this.touch();
        return available;
    }

    private boolean maybeQueueNodeForWork(Container container, NodeEntry nodeEntry, boolean available) {
        if (available) {
            nodeEntry.setLastUsed(this.now());
            NodeInstance ni = this.getOrCreateNodeInstance(container);
            int roleId = ContainerPriority.extractRole(container);
            log.debug("Node {} is now available for role id {}", (Object)ni, (Object)roleId);
            this.listRecentNodesForRoleId(roleId).addFirst(ni);
        }
        return available;
    }

    public synchronized void dump() {
        for (ProviderRole role : this.providerRoles) {
            log.info(role.toString());
            LinkedList<NodeInstance> instances = this.listRecentNodesForRoleId(role.id);
            log.info("  available: " + instances.size() + " " + SliderUtils.joinWithInnerSeparator(" ", instances));
        }
        log.info("Nodes in Cluster: {}", (Object)this.getClusterSize());
        for (NodeInstance node : this.nodemap.values()) {
            log.info(node.toFullString());
        }
    }

    public synchronized Map<CharSequence, Integer> buildMappingForHistoryFile() {
        HashMap<CharSequence, Integer> mapping = new HashMap<CharSequence, Integer>(this.getRoleSize());
        for (ProviderRole role : this.providerRoles) {
            mapping.put(role.name, role.id);
        }
        return mapping;
    }

    @VisibleForTesting
    public List<NodeInstance> cloneRecentNodeList(int role) {
        return new LinkedList<NodeInstance>(this.listRecentNodesForRoleId(role));
    }

    @VisibleForTesting
    public List<OutstandingRequest> listPlacedRequests() {
        return this.outstandingRequests.listPlacedRequests();
    }

    @VisibleForTesting
    public List<OutstandingRequest> listOpenRequests() {
        return this.outstandingRequests.listOpenRequests();
    }

    public List<AbstractRMOperation> escalateOutstandingRequests() {
        return this.outstandingRequests.escalateOutstandingRequests(this.now());
    }

    public List<AbstractRMOperation> cancelOutstandingAARequests() {
        return this.outstandingRequests.cancelOutstandingAARequests();
    }

    public List<AbstractRMOperation> cancelRequestsForRole(RoleStatus role, int toCancel) {
        return role.isAntiAffinePlacement() ? this.cancelRequestsForAARole(role, toCancel) : this.cancelRequestsForSimpleRole(role, toCancel);
    }

    private synchronized List<AbstractRMOperation> cancelRequestsForSimpleRole(RoleStatus role, int toCancel) {
        Preconditions.checkArgument((toCancel > 0 ? 1 : 0) != 0, (Object)("trying to cancel invalid number of requests: " + toCancel));
        ArrayList<AbstractRMOperation> results = new ArrayList<AbstractRMOperation>(toCancel);
        int roleId = role.getKey();
        List<OutstandingRequest> requests = this.outstandingRequests.extractOpenRequestsForRole(roleId, toCancel);
        int remaining = toCancel - requests.size();
        requests.addAll(this.outstandingRequests.extractPlacedRequestsForRole(roleId, remaining));
        for (OutstandingRequest request : requests) {
            results.add(request.createCancelOperation());
        }
        return results;
    }

    private synchronized List<AbstractRMOperation> cancelRequestsForAARole(RoleStatus role, int toCancel) {
        ArrayList<AbstractRMOperation> results = new ArrayList<AbstractRMOperation>(toCancel);
        int roleId = role.getKey();
        List<OutstandingRequest> requests = new ArrayList<OutstandingRequest>(toCancel);
        long pending = role.getPendingAntiAffineRequests();
        if (pending > 0L) {
            long pendingToCancel = Math.min(pending, (long)toCancel);
            log.info("Cancelling {} pending AA allocations, leaving {}", (Object)toCancel, (Object)pendingToCancel);
            role.setPendingAntiAffineRequests(pending - pendingToCancel);
            toCancel = (int)((long)toCancel - pendingToCancel);
        }
        if (toCancel > 0 && role.isAARequestOutstanding()) {
            log.info("Cancelling current AA request");
            requests = this.outstandingRequests.extractOpenRequestsForRole(roleId, toCancel);
            role.cancelOutstandingAARequest();
            --toCancel;
        }
        if (toCancel > 0) {
            requests.addAll(this.outstandingRequests.extractPlacedRequestsForRole(roleId, toCancel));
        }
        for (OutstandingRequest request : requests) {
            results.add(request.createCancelOperation());
        }
        return results;
    }
}

