/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.slider.api.types.NodeInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.common.tools.Duration;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderYarnClientImpl
extends YarnClientImpl {
    protected static final Logger log = LoggerFactory.getLogger(SliderYarnClientImpl.class);
    public static final String KILL_ALL = "all";

    protected void serviceInit(Configuration conf) throws Exception {
        InetSocketAddress clientRpcAddress = SliderUtils.getRmAddress(conf);
        if (!SliderUtils.isAddressDefined(clientRpcAddress)) {
            throw new BindException("Invalid yarn.resourcemanager.address value:" + conf.get("yarn.resourcemanager.address") + " - see https://wiki.apache.org/hadoop/UnsetHostnameOrPort");
        }
        super.serviceInit(conf);
    }

    public ApplicationClientProtocol getRmClient() {
        return this.rmClient;
    }

    public List<ApplicationReport> listInstances(String user) throws YarnException, IOException {
        return this.listDeployedInstances(user);
    }

    public List<ApplicationReport> listDeployedInstances(String user) throws YarnException, IOException {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"Null User");
        HashSet<String> types = new HashSet<String>(1);
        types.add("org-apache-slider");
        List allApps = this.getApplications(types);
        ArrayList<ApplicationReport> results = new ArrayList<ApplicationReport>();
        for (ApplicationReport report : allApps) {
            if (!StringUtils.isEmpty((String)user) && !user.equals(report.getUser())) continue;
            results.add(report);
        }
        return results;
    }

    public List<ApplicationReport> findAllInstances(String user, String appname) throws IOException, YarnException {
        Preconditions.checkArgument((appname != null ? 1 : 0) != 0, (Object)"Null application name");
        List<ApplicationReport> instances = this.listDeployedInstances(user);
        ArrayList<ApplicationReport> results = new ArrayList<ApplicationReport>(instances.size());
        for (ApplicationReport report : instances) {
            if (!report.getName().equals(appname)) continue;
            results.add(report);
        }
        return results;
    }

    public boolean isApplicationLive(ApplicationReport app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0, (Object)"Null app report");
        return app.getYarnApplicationState().ordinal() <= YarnApplicationState.RUNNING.ordinal();
    }

    public KillApplicationResponse killRunningApplication(ApplicationId applicationId, String reason) throws YarnException, IOException {
        Preconditions.checkArgument((applicationId != null ? 1 : 0) != 0, (Object)"Null application Id");
        log.info("Killing application {} - {}", (Object)applicationId.getClusterTimestamp(), (Object)reason);
        KillApplicationRequest request = (KillApplicationRequest)Records.newRecord(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        return this.getRmClient().forceKillApplication(request);
    }

    private String getUsername() throws IOException {
        return UserGroupInformation.getCurrentUser().getShortUserName();
    }

    public void emergencyForceKill(String applicationId) throws YarnException, IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)applicationId), (Object)"Null/empty application Id");
        if (KILL_ALL.equals(applicationId)) {
            String user = this.getUsername();
            log.info("Killing all applications belonging to {}", (Object)user);
            List<ApplicationReport> instances = this.listDeployedInstances(user);
            for (ApplicationReport instance : instances) {
                if (!this.isApplicationLive(instance)) continue;
                ApplicationId appId = instance.getApplicationId();
                log.info("Killing Application {}", (Object)appId);
                this.killRunningApplication(appId, "forced kill");
            }
        } else {
            ApplicationId appId = ConverterUtils.toApplicationId((String)applicationId);
            log.info("Killing Application {}", (Object)applicationId);
            this.killRunningApplication(appId, "forced kill");
        }
    }

    public ApplicationReport monitorAppToState(ApplicationId appId, YarnApplicationState desiredState, Duration duration) throws YarnException, IOException {
        if (appId == null) {
            throw new BadCommandArgumentsException("null application ID", new Object[0]);
        }
        if (duration.limit <= 0L) {
            throw new BadCommandArgumentsException("Invalid monitoring duration", new Object[0]);
        }
        log.debug("Waiting {} millis for app to reach state {} ", (Object)duration.limit, (Object)desiredState);
        duration.start();
        try {
            while (true) {
                ApplicationReport r = this.getApplicationReport(appId);
                log.debug("queried status is\n{}", (Object)new SliderUtils.OnDemandReportStringifier(r));
                YarnApplicationState state = r.getYarnApplicationState();
                if (state.ordinal() >= desiredState.ordinal()) {
                    log.debug("App in desired state (or higher) :{}", (Object)state);
                    ApplicationReport applicationReport = r;
                    return applicationReport;
                }
                if (duration.getLimitExceeded()) {
                    log.debug("Wait limit of {} millis to get to state {}, exceeded; app status\n {}", new Object[]{duration.limit, desiredState, new SliderUtils.OnDemandReportStringifier(r)});
                    return null;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    log.debug("Thread sleep in monitoring loop interrupted");
                }
            }
        }
        finally {
            duration.close();
        }
    }

    public List<ApplicationReport> findAllLiveInstances(String user, String appname) throws YarnException, IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)appname), (Object)"Null/empty application name");
        List<ApplicationReport> instances = this.listDeployedInstances(user);
        ArrayList<ApplicationReport> results = new ArrayList<ApplicationReport>(instances.size());
        for (ApplicationReport app : instances) {
            if (!app.getName().equals(appname) || !this.isApplicationLive(app)) continue;
            results.add(app);
        }
        return results;
    }

    public ApplicationReport findClusterInInstanceList(List<ApplicationReport> instances, String appname) {
        Preconditions.checkArgument((instances != null ? 1 : 0) != 0, (Object)"Null instances list");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)appname), (Object)"Null/empty application name");
        SliderUtils.sortApplicationsByMostRecent(instances);
        ApplicationReport found = null;
        for (ApplicationReport app : instances) {
            if (!app.getName().equals(appname)) continue;
            if (this.isApplicationLive(app)) {
                return app;
            }
            ApplicationReport applicationReport = found = found != null ? found : app;
        }
        return found;
    }

    public ApplicationReport findAppInInstanceList(List<ApplicationReport> instances, String appname, YarnApplicationState desiredState) {
        Preconditions.checkArgument((instances != null ? 1 : 0) != 0, (Object)"Null instances list");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)appname), (Object)"Null/empty application name");
        Preconditions.checkArgument((desiredState != null ? 1 : 0) != 0, (Object)"Null desiredState");
        log.debug("Searching {} records for instance name {} in state '{}'", new Object[]{instances.size(), appname, desiredState});
        for (ApplicationReport app : instances) {
            if (!app.getName().equals(appname)) continue;
            YarnApplicationState appstate = app.getYarnApplicationState();
            log.debug("app ID {} is in state {}", (Object)app.getApplicationId(), (Object)appstate);
            if (!appstate.equals((Object)desiredState)) continue;
            log.debug("match");
            return app;
        }
        log.debug("No match");
        return null;
    }

    public NodeInformationList listNodes(String label, boolean live) throws IOException, YarnException {
        Preconditions.checkArgument((label != null ? 1 : 0) != 0, (Object)"null label");
        NodeState[] states = live ? new NodeState[]{NodeState.RUNNING} : new NodeState[]{};
        List reports = this.getNodeReports(states);
        NodeInformationList results = new NodeInformationList(reports.size());
        for (NodeReport report : reports) {
            if (live && report.getNodeState() != NodeState.RUNNING || !label.isEmpty() && !report.getNodeLabels().contains(label)) continue;
            NodeInformation info = new NodeInformation();
            info.hostname = report.getNodeId().getHost();
            info.healthReport = report.getHealthReport();
            info.httpAddress = report.getHttpAddress();
            info.labels = SliderUtils.extractNodeLabel(report);
            info.rackName = report.getRackName();
            info.state = report.getNodeState().toString();
            results.add(info);
        }
        return results;
    }
}

