/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.solr.authz;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.api.tools.GenericPrivilegeConverter;
import org.apache.sentry.binding.solr.conf.SolrAuthzConf;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.solr.AdminOperation;
import org.apache.sentry.core.model.solr.SolrModelAction;
import org.apache.sentry.core.model.solr.SolrModelAuthorizable;
import org.apache.sentry.core.model.solr.SolrPrivilegeModel;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.generic.SentryGenericProviderBackend;
import org.apache.solr.security.AuthorizationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAuthzBinding
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SolrAuthzBinding.class);
    static final Set<SolrModelAction> QUERY = new HashSet<SolrModelAction>(Arrays.asList(SolrModelAction.QUERY));
    static final Set<SolrModelAction> UPDATE = new HashSet<SolrModelAction>(Arrays.asList(SolrModelAction.UPDATE));
    private final SolrAuthzConf authzConf;
    public final AuthorizationProvider authProvider;
    private final GroupMappingService groupMapping;
    public ProviderBackend providerBackend;

    public SolrAuthzBinding(SolrAuthzConf authzConf) throws Exception {
        this.authzConf = authzConf;
        this.authProvider = this.getAuthProvider();
        this.groupMapping = this.authProvider.getGroupMapping();
    }

    @Override
    public void close() throws IOException {
        if (this.authProvider != null) {
            this.authProvider.close();
        }
    }

    private AuthorizationProvider getAuthProvider() throws Exception {
        String authProviderName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER.getVar());
        String resourceName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar());
        String providerBackendName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar());
        String policyEngineName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar(), SolrAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getDefault());
        String serviceName = this.authzConf.get("sentry.solr.service", "service1");
        LOG.debug("Using authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend " + providerBackendName);
        if (this.authzConf.get("sentry.provider.backend.generic.privilege.converter") == null) {
            this.authzConf.set("sentry.provider.backend.generic.privilege.converter", GenericPrivilegeConverter.class.getName());
        }
        Constructor<?> providerBackendConstructor = Class.forName(providerBackendName).getDeclaredConstructor(Configuration.class, String.class);
        providerBackendConstructor.setAccessible(true);
        this.providerBackend = (ProviderBackend)providerBackendConstructor.newInstance(new Object[]{this.authzConf, resourceName});
        if (this.providerBackend instanceof SentryGenericProviderBackend) {
            ((SentryGenericProviderBackend)this.providerBackend).setComponentType("solr");
            ((SentryGenericProviderBackend)this.providerBackend).setServiceName(serviceName);
        }
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(false);
        context.setValidators(SolrPrivilegeModel.getInstance().getPrivilegeValidators());
        this.providerBackend.initialize(context);
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(this.providerBackend);
        if (this.authzConf.get(HadoopGroupResourceAuthorizationProvider.USE_NEW_GROUPS) == null) {
            this.authzConf.setBoolean(HadoopGroupResourceAuthorizationProvider.USE_NEW_GROUPS, true);
        }
        Constructor<?> constrctor = Class.forName(authProviderName).getDeclaredConstructor(Configuration.class, String.class, PolicyEngine.class, Model.class);
        constrctor.setAccessible(true);
        return (AuthorizationProvider)constrctor.newInstance(new Object[]{this.authzConf, resourceName, policyEngine, SolrPrivilegeModel.getInstance()});
    }

    public AuthorizationResponse authorize(Subject subject, Collection<? extends SolrModelAuthorizable> authorizables, Set<SolrModelAction> actions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to authorize " + authorizables + " for subject " + subject.getName());
            LOG.debug("Actions: " + actions);
        }
        for (SolrModelAuthorizable solrModelAuthorizable : authorizables) {
            if (this.authProvider.hasAccess(subject, Arrays.asList(solrModelAuthorizable), actions, ActiveRoleSet.ALL)) continue;
            return AuthorizationResponse.FORBIDDEN;
        }
        return AuthorizationResponse.OK;
    }

    public AuthorizationResponse authorizeCollection(Subject subject, org.apache.sentry.core.model.solr.Collection collection, Set<SolrModelAction> actions) {
        return this.authorize(subject, Collections.singleton(collection), actions);
    }

    public AuthorizationResponse authorizeAdminAction(Subject subject, AdminOperation admin, Set<SolrModelAction> actions) {
        return this.authorize(subject, Collections.singleton(admin), actions);
    }

    @Deprecated
    public Set<String> getGroups(String user) throws SentryUserException {
        return this.groupMapping.getGroups(user);
    }

    public Set<String> getRoles(String user) throws SentryUserException {
        return this.providerBackend.getRoles(this.getGroups(user), ActiveRoleSet.ALL);
    }

    public SentryGenericServiceClient getClient() throws Exception {
        return SentryGenericServiceClientFactory.create((Configuration)this.authzConf);
    }
}

