/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.solr.authz;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.sentry.binding.solr.authz.SolrAuthzBinding;
import org.apache.sentry.binding.solr.authz.SolrAuthzUtil;
import org.apache.sentry.binding.solr.conf.SolrAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.solr.AdminOperation;
import org.apache.sentry.core.model.solr.SolrModelAction;
import org.apache.sentry.provider.file.SimpleFileProviderBackend;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.sentry.AuditLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentrySolrPluginImpl
implements AuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SentrySolrPluginImpl.class);
    private static final String SYSPROP_PREFIX_PROPERTY = "sysPropPrefix";
    private static final String AUTH_CONFIG_NAMES_PROPERTY = "authConfigs";
    private static final String DEFAULT_AUTH_CONFIGS_PROPERTY = "defaultConfigs";
    public static final String SNTRY_SITE_LOCATION_PROPERTY = "authorization.sentry.site";
    public static final String SENTRY_SOLR_AUTH_SUPERUSER = "authorization.superuser";
    public static final String SENTRY_ENABLE_SOLR_AUDITLOG = "authorization.enable.auditlog";
    public static final String SENTRY_HADOOP_CONF_DIR_PROPERTY = "authorization.sentry.hadoop.conf";
    public static final String SENTRY_HDFS_KERBEROS_PRINCIPAL = "authorization.hdfs.kerberos.principal";
    public static final String SENTRY_HDFS_KERBEROS_KEYTAB = "authorization.hdfs.kerberos.keytabfile";
    private String solrSuperUser;
    private SolrAuthzBinding binding;
    private Optional<AuditLogger> auditLog = Optional.empty();

    public void init(Map<String, Object> pluginConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        String sysPropPrefix = (String)pluginConfig.getOrDefault(SYSPROP_PREFIX_PROPERTY, "solr.");
        Collection authConfigNames = pluginConfig.getOrDefault(AUTH_CONFIG_NAMES_PROPERTY, Collections.emptyList());
        Map authConfigDefaults = pluginConfig.getOrDefault(DEFAULT_AUTH_CONFIGS_PROPERTY, Collections.emptyMap());
        for (String configName : authConfigNames) {
            String defaultConfigVal;
            String systemProperty = sysPropPrefix + configName;
            String configVal = System.getProperty(systemProperty, defaultConfigVal = (String)authConfigDefaults.get(configName));
            if (configVal == null) continue;
            params.put(configName, configVal);
        }
        this.initializeSentry(params);
    }

    public void close() throws IOException {
        if (this.binding != null) {
            this.binding.close();
        }
    }

    public AuthorizationResponse authorize(AuthorizationContext authCtx) {
        String userNameStr;
        if (authCtx.getUserPrincipal() == null) {
            return AuthorizationResponse.PROMPT;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authorizing a request with authorization context {} ", (Object)SolrAuthzUtil.toString(authCtx));
        }
        if ((userNameStr = authCtx.getUserName()) == null) {
            userNameStr = SentrySolrPluginImpl.getShortUserName(authCtx.getUserPrincipal());
        }
        if (this.solrSuperUser.equals(userNameStr)) {
            AuthorizationResponse resp = AuthorizationResponse.OK;
            if (authCtx.getHandler() instanceof PermissionNameProvider) {
                PermissionNameProvider.Name perm = ((PermissionNameProvider)authCtx.getHandler()).getPermissionName(authCtx);
                this.audit(perm, authCtx, resp);
            }
            return resp;
        }
        if (authCtx.getHandler() instanceof PermissionNameProvider) {
            Subject userName = new Subject(userNameStr);
            PermissionNameProvider.Name perm = ((PermissionNameProvider)authCtx.getHandler()).getPermissionName(authCtx);
            switch (perm) {
                case READ_PERM: 
                case UPDATE_PERM: {
                    AuthorizationResponse resp = AuthorizationResponse.FORBIDDEN;
                    Set<SolrModelAction> actions = perm == PermissionNameProvider.Name.READ_PERM ? SolrAuthzBinding.QUERY : SolrAuthzBinding.UPDATE;
                    for (AuthorizationContext.CollectionRequest req : authCtx.getCollectionRequests()) {
                        resp = this.binding.authorizeCollection(userName, new org.apache.sentry.core.model.solr.Collection(req.collectionName), actions);
                        if (AuthorizationResponse.OK.equals(resp)) continue;
                        break;
                    }
                    this.audit(perm, authCtx, resp);
                    return resp;
                }
                case SECURITY_EDIT_PERM: {
                    return this.binding.authorize(userName, Collections.singleton(AdminOperation.SECURITY), SolrAuthzBinding.UPDATE);
                }
                case SECURITY_READ_PERM: {
                    return this.binding.authorize(userName, Collections.singleton(AdminOperation.SECURITY), SolrAuthzBinding.QUERY);
                }
                case CORE_READ_PERM: 
                case CORE_EDIT_PERM: 
                case COLL_READ_PERM: 
                case COLL_EDIT_PERM: {
                    AuthorizationResponse resp = AuthorizationResponse.FORBIDDEN;
                    AdminOperation auth = perm == PermissionNameProvider.Name.COLL_READ_PERM || perm == PermissionNameProvider.Name.COLL_EDIT_PERM ? AdminOperation.COLLECTIONS : AdminOperation.CORES;
                    Set<SolrModelAction> actions = perm == PermissionNameProvider.Name.COLL_READ_PERM || perm == PermissionNameProvider.Name.CORE_READ_PERM ? SolrAuthzBinding.QUERY : SolrAuthzBinding.UPDATE;
                    resp = this.binding.authorize(userName, Collections.singleton(auth), actions);
                    this.audit(perm, authCtx, resp);
                    if (AuthorizationResponse.OK.equals(resp)) {
                        String operationName = this.getAdminOperationName(authCtx, perm);
                        for (Map.Entry<String, SolrModelAction> entry : SolrAuthzUtil.getCollectionsForAdminOp(authCtx).entrySet()) {
                            resp = this.binding.authorizeCollection(userName, new org.apache.sentry.core.model.solr.Collection(entry.getKey()), Collections.singleton(entry.getValue()));
                            this.audit(entry.getKey(), operationName, authCtx, resp);
                            if (AuthorizationResponse.OK.equals(resp)) continue;
                            break;
                        }
                    }
                    return resp;
                }
                case CONFIG_EDIT_PERM: {
                    return this.binding.authorize(userName, SolrAuthzUtil.getConfigAuthorizables(authCtx), SolrAuthzBinding.UPDATE);
                }
                case CONFIG_READ_PERM: {
                    return this.binding.authorize(userName, SolrAuthzUtil.getConfigAuthorizables(authCtx), SolrAuthzBinding.QUERY);
                }
                case SCHEMA_EDIT_PERM: {
                    return this.binding.authorize(userName, SolrAuthzUtil.getSchemaAuthorizables(authCtx), SolrAuthzBinding.UPDATE);
                }
                case SCHEMA_READ_PERM: {
                    return this.binding.authorize(userName, SolrAuthzUtil.getSchemaAuthorizables(authCtx), SolrAuthzBinding.QUERY);
                }
                case METRICS_HISTORY_READ_PERM: 
                case METRICS_READ_PERM: {
                    return this.binding.authorize(userName, Collections.singleton(AdminOperation.METRICS), SolrAuthzBinding.QUERY);
                }
                case AUTOSCALING_READ_PERM: 
                case AUTOSCALING_HISTORY_READ_PERM: {
                    return this.binding.authorize(userName, Collections.singleton(AdminOperation.AUTOSCALING), SolrAuthzBinding.QUERY);
                }
                case AUTOSCALING_WRITE_PERM: {
                    return this.binding.authorize(userName, Collections.singleton(AdminOperation.AUTOSCALING), SolrAuthzBinding.UPDATE);
                }
                case ALL: {
                    return AuthorizationResponse.OK;
                }
            }
        }
        return AuthorizationResponse.OK;
    }

    public Set<String> getRoles(String userName) throws SentryUserException {
        return this.binding.getRoles(userName);
    }

    private void initializeSentry(Map<String, String> config) {
        String sentrySiteLoc = (String)Preconditions.checkNotNull((Object)config.get(SNTRY_SITE_LOCATION_PROPERTY), (Object)"The authorization plugin configuration is missing authorization.sentry.site property");
        String sentryHadoopConfLoc = config.get(SENTRY_HADOOP_CONF_DIR_PROPERTY);
        try {
            List<URL> configFiles = this.getHadoopConfigFiles(sentryHadoopConfLoc);
            configFiles.add(new File(sentrySiteLoc).toURI().toURL());
            SolrAuthzConf conf = new SolrAuthzConf(configFiles);
            if (this.shouldInitializeKereberos(conf)) {
                String princ = (String)Preconditions.checkNotNull((Object)config.get(SENTRY_HDFS_KERBEROS_PRINCIPAL), (Object)"The authorization plugin is missing the authorization.hdfs.kerberos.principal property.");
                String keytab = (String)Preconditions.checkNotNull((Object)config.get(SENTRY_HDFS_KERBEROS_KEYTAB), (Object)"The authorization plugin is missing the authorization.hdfs.kerberos.keytabfile property.");
                this.initKerberos(conf, keytab, princ);
            }
            this.binding = new SolrAuthzBinding(conf);
            LOG.info("SolrAuthzBinding created successfully");
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create SolrAuthzBinding", (Throwable)e);
        }
        this.solrSuperUser = (String)Preconditions.checkNotNull((Object)config.get(SENTRY_SOLR_AUTH_SUPERUSER));
        boolean enableAuditLog = Boolean.parseBoolean((String)Preconditions.checkNotNull((Object)config.get(SENTRY_ENABLE_SOLR_AUDITLOG)));
        if (enableAuditLog) {
            this.auditLog = Optional.of(new AuditLogger());
        }
    }

    private void audit(PermissionNameProvider.Name perm, AuthorizationContext ctx, AuthorizationResponse resp) {
        switch (perm) {
            case CORE_READ_PERM: 
            case CORE_EDIT_PERM: 
            case COLL_READ_PERM: 
            case COLL_EDIT_PERM: {
                this.audit("admin", this.getAdminOperationName(ctx, perm), ctx, resp);
                break;
            }
            case READ_PERM: 
            case UPDATE_PERM: {
                ArrayList<String> names = new ArrayList<String>();
                for (AuthorizationContext.CollectionRequest r : ctx.getCollectionRequests()) {
                    names.add(r.collectionName);
                }
                String collectionName = String.join((CharSequence)",", names);
                String operationName = perm == PermissionNameProvider.Name.READ_PERM ? "query" : "update";
                this.audit(collectionName, operationName, ctx, resp);
                break;
            }
        }
    }

    private void audit(String collectionName, String operationName, AuthorizationContext ctx, AuthorizationResponse resp) {
        if (!this.auditLog.isPresent() || !this.auditLog.get().isLogEnabled()) {
            return;
        }
        String userName = ctx.getUserName();
        if (userName == null) {
            userName = SentrySolrPluginImpl.getShortUserName(ctx.getUserPrincipal());
        }
        String ipAddress = ctx.getRemoteAddr();
        long eventTime = System.currentTimeMillis();
        int allowed = resp.statusCode == AuthorizationResponse.OK.statusCode ? 1 : 0;
        String operationParams = ctx.getParams().toString();
        String impersonator = ctx.getImpersonatorUserName().orElse(null);
        this.auditLog.get().log(userName, impersonator, ipAddress, operationName, operationParams, eventTime, allowed, collectionName);
    }

    private String getAdminOperationName(AuthorizationContext ctx, PermissionNameProvider.Name perm) {
        switch (perm) {
            case COLL_READ_PERM: 
            case COLL_EDIT_PERM: {
                String actionName = ctx.getParams().get("action");
                String operationName = actionName != null ? "CollectionAction." + ctx.getParams().get("action") : ctx.getHandler().getClass().getName();
                return operationName;
            }
            case CORE_READ_PERM: 
            case CORE_EDIT_PERM: {
                String operationName = "CoreAdminAction.STATUS";
                if (ctx.getParams().get("action") != null) {
                    operationName = "CoreAdminAction." + ctx.getParams().get("action");
                }
                return operationName;
            }
        }
        throw new IllegalStateException("This api must only be used for collection/core admin permissions");
    }

    public static String getShortUserName(Principal princ) {
        if (princ instanceof BasicUserPrincipal) {
            return princ.getName();
        }
        KerberosName name = new KerberosName(princ.getName());
        try {
            return name.getShortName();
        }
        catch (IOException e) {
            LOG.error("Error converting kerberos name. principal = {}, KerberosName.rules = {}", (Object)princ, (Object)KerberosName.getRules());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected error converting a kerberos name", (Throwable)e);
        }
    }

    private List<URL> getHadoopConfigFiles(String confDir) {
        ArrayList<URL> result = new ArrayList<URL>();
        if (confDir != null && !confDir.isEmpty()) {
            File confDirFile = new File(confDir);
            if (!confDirFile.exists()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Specified Sentry hadoop config directory does not exist: " + confDirFile.getAbsolutePath());
            }
            if (!confDirFile.isDirectory()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Specified Sentry hadoop config directory path is not a directory: " + confDirFile.getAbsolutePath());
            }
            if (!confDirFile.canRead()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Specified Sentry hadoop config directory must be readable by the Solr process: " + confDirFile.getAbsolutePath());
            }
            for (String file : Arrays.asList("core-site.xml", "hdfs-site.xml", "ssl-client.xml")) {
                File f = new File(confDirFile, file);
                if (!f.exists()) continue;
                try {
                    result.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKerberos(SolrAuthzConf authzConf, String keytabFile, String principal) {
        Class<SentrySolrPluginImpl> clazz = SentrySolrPluginImpl.class;
        synchronized (SentrySolrPluginImpl.class) {
            UserGroupInformation.setConfiguration((Configuration)authzConf);
            LOG.info("Attempting to acquire kerberos ticket with keytab: {}, principal: {} ", (Object)keytabFile, (Object)principal);
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
            }
            catch (IOException ioe) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ioe);
            }
            LOG.info("Got Kerberos ticket");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private boolean shouldInitializeKereberos(SolrAuthzConf conf) {
        String providerBackend = conf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar());
        String authVal = conf.get("hadoop.security.authentication");
        return SimpleFileProviderBackend.class.getName().equals(providerBackend) && "kerberos".equalsIgnoreCase(authVal);
    }
}

