/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.engine.application.RangeRepresentation;
import org.restlet.routing.Filter;
import org.restlet.service.RangeService;

public class RangeFilter
extends Filter {
    public RangeFilter(Context context) {
        super(context);
    }

    @Override
    protected void afterHandle(Request request, Response response) {
        if (this.getRangeService().isEnabled()) {
            response.getServerInfo().setAcceptingRanges(true);
            if (request.getMethod().isSafe() && response.isEntityAvailable()) {
                boolean rangedEntity;
                boolean bl = rangedEntity = response.getEntity().getRange() != null;
                if (response.getStatus().isSuccess()) {
                    if (Status.SUCCESS_PARTIAL_CONTENT.equals(response.getStatus())) {
                        if (!rangedEntity) {
                            this.getLogger().warning("When returning a \"206 Partial content\" status, your response entity must be properly ranged.");
                        }
                    } else if (request.getRanges().size() == 1 && (!request.getConditions().hasSomeRange() || request.getConditions().getRangeStatus(response.getEntity()).isSuccess())) {
                        Range requestedRange = request.getRanges().get(0);
                        if (!(response.getEntity().hasKnownSize() || requestedRange.getIndex() != -1L && requestedRange.getSize() != -1L || requestedRange.getIndex() == -1L && requestedRange.getSize() == -1L)) {
                            response.setStatus(Status.SERVER_ERROR_INTERNAL);
                            this.getLogger().warning("Unable to serve this range since at least the end index of the range cannot be computed.");
                            response.setEntity(null);
                        } else if (!requestedRange.equals(response.getEntity().getRange())) {
                            if (rangedEntity) {
                                this.getLogger().info("The range of the response entity is not equal to the requested one.");
                            }
                            if (response.getEntity().hasKnownSize() && requestedRange.getSize() > response.getEntity().getAvailableSize()) {
                                requestedRange.setSize(-1L);
                            }
                            response.setEntity(new RangeRepresentation(response.getEntity(), requestedRange));
                            response.setStatus(Status.SUCCESS_PARTIAL_CONTENT);
                        }
                    } else if (request.getRanges().size() > 1) {
                        response.setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                        this.getLogger().warning("Multiple ranges are not supported at this time.");
                        response.setEntity(null);
                    }
                }
            }
        }
    }

    public RangeService getRangeService() {
        return this.getApplication().getRangeService();
    }
}

