/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Preference;
import org.restlet.engine.application.EncodeRepresentation;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;
import org.restlet.service.EncoderService;

public class Encoder
extends Filter {
    private final boolean encodingRequest;
    private final boolean encodingResponse;
    private final EncoderService encoderService;

    public Encoder(Context context, boolean encodingRequest, boolean encodingResponse, EncoderService encoderService) {
        super(context);
        this.encodingRequest = encodingRequest;
        this.encodingResponse = encodingResponse;
        this.encoderService = encoderService;
    }

    @Override
    public void afterHandle(Request request, Response response) {
        if (this.isEncodingResponse() && this.getEncoderService().canEncode(response.getEntity())) {
            response.setEntity(this.encode(request.getClientInfo(), response.getEntity()));
        }
    }

    @Override
    public int beforeHandle(Request request, Response response) {
        if (this.isEncodingRequest() && this.getEncoderService().canEncode(request.getEntity())) {
            request.setEntity(this.encode(request.getClientInfo(), request.getEntity()));
        }
        return 0;
    }

    public Representation encode(ClientInfo client, Representation representation) {
        Representation result = representation;
        Encoding bestEncoding = this.getBestEncoding(client);
        if (bestEncoding != null) {
            result = new EncodeRepresentation(bestEncoding, representation);
        }
        return result;
    }

    public Encoding getBestEncoding(ClientInfo client) {
        Encoding bestEncoding = null;
        Encoding currentEncoding2 = null;
        Preference<Encoding> currentPref2 = null;
        float bestScore = 0.0f;
        for (Encoding currentEncoding2 : this.getSupportedEncodings()) {
            for (Preference<Encoding> currentPref2 : client.getAcceptedEncodings()) {
                if (!currentPref2.getMetadata().equals(Encoding.ALL) && !currentPref2.getMetadata().equals(currentEncoding2) || !(currentPref2.getQuality() > bestScore)) continue;
                bestScore = currentPref2.getQuality();
                bestEncoding = currentEncoding2;
            }
        }
        return bestEncoding;
    }

    public EncoderService getEncoderService() {
        return this.encoderService;
    }

    public List<Encoding> getSupportedEncodings() {
        return EncodeRepresentation.getSupportedEncodings();
    }

    public boolean isEncodingRequest() {
        return this.encodingRequest;
    }

    public boolean isEncodingResponse() {
        return this.encodingResponse;
    }
}

