/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.spi;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sentry.spi.DefaultProviderLoader;
import org.apache.sentry.spi.Provider;
import org.apache.sentry.spi.ProviderFactory;
import org.apache.sentry.spi.ProviderLoader;
import org.apache.sentry.spi.Spi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderManager.class);
    private static ProviderManager instance;
    private Map<String, Spi> spiMap = new HashMap<String, Spi>();
    private List<ProviderLoader> loaders = new LinkedList<ProviderLoader>();
    private ListMultimap<Class<? extends Provider>, ProviderFactory> cache = ArrayListMultimap.create();

    private ProviderManager(ClassLoader baseClassLoader) {
        this.loaders.add(new DefaultProviderLoader(baseClassLoader));
        this.loadSpis();
    }

    public static ProviderManager getInstance() {
        if (instance == null) {
            instance = new ProviderManager(ProviderManager.class.getClassLoader());
        }
        return instance;
    }

    private synchronized void loadSpis() {
        for (ProviderLoader loader : this.loaders) {
            List<Spi> spis = loader.loadSpis();
            if (spis == null) continue;
            for (Spi spi : spis) {
                this.spiMap.put(spi.getName(), spi);
            }
        }
    }

    public synchronized <T extends ProviderFactory> List<T> load(String service) {
        List rtn;
        if (!this.spiMap.containsKey(service)) {
            throw new RuntimeException(String.format("SPI Definition for Service %s not found", service));
        }
        Spi spi = this.spiMap.get(service);
        if (!this.cache.containsKey(spi.getProviderClass())) {
            LOGGER.debug("Loading Service {}", (Object)spi.getName());
            IdentityHashMap factoryClasses = new IdentityHashMap();
            for (ProviderLoader loader : this.loaders) {
                List<ProviderFactory> f = loader.load(spi);
                if (f == null) continue;
                for (ProviderFactory pf : f) {
                    if (factoryClasses.containsKey(pf.getClass())) continue;
                    LOGGER.debug("Service {} provider {} loaded", (Object)spi.getName(), (Object)pf.getId());
                    this.cache.put(spi.getProviderClass(), (Object)pf);
                    factoryClasses.put(pf.getClass(), pf);
                }
            }
        }
        return (rtn = this.cache.get(spi.getProviderClass())) == null ? Collections.EMPTY_LIST : rtn;
    }

    public synchronized <T extends ProviderFactory> T load(String service, String providerId) {
        for (ProviderFactory f : this.load(service)) {
            if (!f.getId().equals(providerId)) continue;
            return (T)f;
        }
        return null;
    }
}

