/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.kafka.conf;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.policy.engine.common.CommonPolicyEngine;
import org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider;
import org.apache.sentry.provider.db.generic.SentryGenericProviderBackend;

public class KafkaAuthConf
extends Configuration {
    public static final String SENTRY_KAFKA_SITE_URL = "sentry.kafka.site.url";
    public static final String AUTHZ_SITE_FILE = "sentry-site.xml";
    public static final String KAFKA_SUPER_USERS = "super.users";
    public static final String KAFKA_SERVICE_INSTANCE_NAME = "sentry.kafka.service.instance";
    public static final String KAFKA_SERVICE_USER_NAME = "sentry.kafka.service.user.name";
    public static final String KAFKA_PRINCIPAL_HOSTNAME = "sentry.kafka.principal.hostname";
    public static final String KAFKA_PRINCIPAL_NAME = "sentry.kafka.kerberos.principal";
    public static final String KAFKA_KEYTAB_FILE_NAME = "sentry.kafka.keytab.file";
    public static final String SENTRY_KAFKA_CACHING_ENABLE_NAME = "sentry.kafka.caching.enable";
    public static final String SENTRY_KAFKA_CACHING_TTL_MS_NAME = "sentry.kafka.caching.ttl.ms";
    public static final String SENTRY_KAFKA_CACHING_UPDATE_FAILURES_COUNT_NAME = "sentry.kafka.caching.update.failures.count";

    public KafkaAuthConf(URL kafkaAuthzSiteURL) {
        super(true);
        this.addResource(kafkaAuthzSiteURL, true);
    }

    public String get(String varName) {
        return this.get(varName, AuthzConfVars.getDefault(varName));
    }

    public static enum AuthzConfVars {
        AUTHZ_PROVIDER("sentry.kafka.provider", HadoopGroupResourceAuthorizationProvider.class.getName()),
        AUTHZ_PROVIDER_RESOURCE("sentry.kafka.provider.resource", ""),
        AUTHZ_PROVIDER_BACKEND("sentry.kafka.provider.backend", SentryGenericProviderBackend.class.getName()),
        AUTHZ_POLICY_ENGINE("sentry.kafka.policy.engine", CommonPolicyEngine.class.getName()),
        AUTHZ_INSTANCE_NAME("sentry.kafka.service.instance", "kafka"),
        AUTHZ_SERVICE_USER_NAME("sentry.kafka.service.user.name", "kafka"),
        AUTHZ_PRINCIPAL_HOSTNAME("sentry.kafka.principal.hostname", null),
        AUTHZ_PRINCIPAL_NAME("sentry.kafka.kerberos.principal", null),
        AUTHZ_KEYTAB_FILE_NAME("sentry.kafka.keytab.file", null),
        AUTHZ_CACHING_ENABLE_NAME("sentry.kafka.caching.enable", "false"),
        AUTHZ_CACHING_TTL_MS_NAME("sentry.kafka.caching.ttl.ms", "30000"),
        AUTHZ_CACHING_UPDATE_FAILURES_COUNT_NAME("sentry.kafka.caching.update.failures.count", "3");

        private final String varName;
        private final String defaultVal;

        private AuthzConfVars(String varName, String defaultVal) {
            this.varName = varName;
            this.defaultVal = defaultVal;
        }

        public String getVar() {
            return this.varName;
        }

        public String getDefault() {
            return this.defaultVal;
        }

        public static String getDefault(String varName) {
            for (AuthzConfVars oneVar : AuthzConfVars.values()) {
                if (!oneVar.getVar().equalsIgnoreCase(varName)) continue;
                return oneVar.getDefault();
            }
            return null;
        }
    }
}

