/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.io.encoded.OrcEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.FileSplit;

public class OrcColumnVectorProducer
implements ColumnVectorProducer {
    private final OrcMetadataCache metadataCache;
    private final LowLevelCache lowLevelCache;
    private final BufferUsageManager bufferManager;
    private final Configuration conf;
    private boolean _skipCorrupt;
    private LlapDaemonCacheMetrics cacheMetrics;
    private LlapDaemonIOMetrics ioMetrics;

    public OrcColumnVectorProducer(OrcMetadataCache metadataCache, LowLevelCache lowLevelCache, BufferUsageManager bufferManager, Configuration conf, LlapDaemonCacheMetrics cacheMetrics, LlapDaemonIOMetrics ioMetrics) {
        LlapIoImpl.LOG.info("Initializing ORC column vector producer");
        this.metadataCache = metadataCache;
        this.lowLevelCache = lowLevelCache;
        this.bufferManager = bufferManager;
        this.conf = conf;
        this._skipCorrupt = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_SKIP_CORRUPT_DATA);
        this.cacheMetrics = cacheMetrics;
        this.ioMetrics = ioMetrics;
    }

    @Override
    public ReadPipeline createReadPipeline(Consumer<ColumnVectorBatch> consumer, FileSplit split, List<Integer> columnIds, SearchArgument sarg, String[] columnNames, QueryFragmentCounters counters) throws IOException {
        this.cacheMetrics.incrCacheReadRequests();
        OrcEncodedDataConsumer edc = new OrcEncodedDataConsumer(consumer, columnIds.size(), this._skipCorrupt, counters, this.ioMetrics);
        OrcEncodedDataReader reader = new OrcEncodedDataReader(this.lowLevelCache, this.bufferManager, this.metadataCache, this.conf, split, columnIds, sarg, columnNames, edc, counters);
        edc.init(reader, (Callable<Void>)((Object)reader));
        return edc;
    }
}

