/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.LdapUserAttributeSourceParams;
import org.apache.solr.handler.component.UserAttributeSource;
import org.apache.solr.handler.component.UserAttributeSourceParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserAttributeSource
implements UserAttributeSource {
    private static final HostnameVerifier PERMISSIVE_HOSTNAME_VERIFIER = (hostname, session) -> true;
    private static final Logger LOG = LoggerFactory.getLogger(LdapUserAttributeSource.class);
    private static volatile Cache<String, Set<String>> scache;
    private static final Object SCACHE_SYNC;
    private Hashtable env;
    private LdapUserAttributeSourceParams params;
    private SearchControls searchControls;
    private Cache<String, Set<String>> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache<String, Set<String>> getCache(long ttlSeconds, long maxCacheSize) {
        if (scache != null) {
            return scache;
        }
        Object object = SCACHE_SYNC;
        synchronized (object) {
            if (scache == null) {
                LOG.info("Creating access group cache, ttl={} maxSize={}", (Object)ttlSeconds, (Object)maxCacheSize);
                scache = CacheBuilder.newBuilder().expireAfterWrite(ttlSeconds, TimeUnit.SECONDS).maximumSize(maxCacheSize).build();
            }
            return scache;
        }
    }

    @Override
    public void init(UserAttributeSourceParams params, Collection<String> attributes) {
        LOG.debug("Creating LDAP user attribute source, params={}, attributes={}", (Object)params, attributes);
        if (!(params instanceof LdapUserAttributeSourceParams)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "LdapUserAttributeSource has been misconfigured with the wrong parameters {" + params.getClass().getName() + "}");
        }
        this.params = (LdapUserAttributeSourceParams)params;
        this.env = this.toEnv(this.params);
        this.searchControls = new SearchControls();
        this.searchControls.setReturningAttributes(attributes.toArray(new String[attributes.size()]));
        this.searchControls.setSearchScope(2);
        if (this.params.isStartTlsEnabled() && this.params.getServerUrl().startsWith("ldaps://")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Start TLS should not be used with ldaps://");
        }
        long cacheTtl = this.params.getGroupCacheTtl();
        long cacheMaxSize = this.params.getGroupCacheMaxSize();
        this.cache = LdapUserAttributeSource.getCache(cacheTtl, cacheMaxSize);
    }

    private Hashtable toEnv(LdapUserAttributeSourceParams params) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        result.put("java.naming.provider.url", params.getServerUrl());
        String authType = params.getAuthType();
        result.put("java.naming.security.authentication", authType);
        if ("simple".equals(authType)) {
            result.put("java.naming.security.principal", params.getUsername());
            result.put("java.naming.security.credentials", params.getPassword());
        }
        return result;
    }

    @Override
    public Multimap<String, String> getAttributesForUser(String userName) {
        InitialLdapContext ctx = null;
        try {
            Multimap<String, String> result;
            ctx = new InitialLdapContext(this.env, null);
            if (this.params.isStartTlsEnabled()) {
                StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                if (this.params.isHostNameVerificationDisabled()) {
                    tls.setHostnameVerifier(PERMISSIVE_HOSTNAME_VERIFIER);
                }
                tls.negotiate();
                result = this.doAttributeSearch(userName, ctx);
                tls.close();
            } else {
                result = this.doAttributeSearch(userName, ctx);
            }
            Multimap<String, String> multimap = result;
            return multimap;
        }
        catch (IOException | NamingException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to query LDAP server", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    public Class<LdapUserAttributeSourceParams> getParamsClass() {
        return LdapUserAttributeSourceParams.class;
    }

    private Multimap<String, String> doAttributeSearch(String userName, LdapContext ctx) throws NamingException {
        NamingEnumeration<SearchResult> searchResults = ctx.search(this.params.getBaseDn(), this.params.getUserFilter().replace("{0}", userName), this.searchControls);
        if (!searchResults.hasMore()) {
            LOG.error("User '{}' not found in LDAP", (Object)userName);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "User not found in LDAP");
        }
        LOG.info("Fetching attributes for {} from LDAP using {}", (Object)userName, (Object)this);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        while (searchResults.hasMore()) {
            SearchResult entry = searchResults.next();
            Attributes attributes = entry.getAttributes();
            NamingEnumeration<? extends Attribute> attrEnum = attributes.getAll();
            while (attrEnum.hasMore()) {
                Attribute a = attrEnum.next();
                NamingEnumeration<?> values = a.getAll();
                while (values.hasMore()) {
                    result.put((Object)a.getID(), (Object)((String)values.next()));
                }
            }
        }
        LOG.debug("Direct attributes found for user {}: {}", (Object)userName, (Object)result);
        if (this.params.isNestedQueryEnabled() && this.params.getMaxRecurseDepth() > 0) {
            LOG.debug("Querying nested groups for user {} up to depth {}", (Object)userName, (Object)this.params.getMaxRecurseDepth());
            String recursiveAttr = this.params.getRecursiveAttribute();
            HashSet values = new HashSet(result.get((Object)recursiveAttr));
            for (String group : values) {
                HashSet<String> known = new HashSet<String>();
                known.add(group);
                this.getParentGroups(group, known, ctx, 1);
                known.remove(group);
                LOG.debug("Adding parent groups for {} : {}", (Object)group, known);
                result.putAll((Object)recursiveAttr, known);
            }
            LOG.debug("Total attributes found for user {}: {}", (Object)userName, (Object)result);
        }
        return result;
    }

    private Set<String> getParentGroups(String childGroup, Set<String> knownGroups, LdapContext ctx, int depth) throws NamingException {
        if (depth > this.params.getMaxRecurseDepth()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Nested groups recursion limit exceeded for group " + childGroup + " at depth " + depth);
        }
        Set parents = (Set)this.cache.getIfPresent((Object)childGroup);
        if (parents != null) {
            LOG.debug("Cache hit for {} : {}", (Object)childGroup, (Object)parents);
            knownGroups.addAll(parents);
            return parents;
        }
        LOG.debug("Querying LDAP for parent groups of {} at depth {}...", (Object)childGroup, (Object)depth);
        String recursiveAttr = this.params.getRecursiveAttribute();
        Attributes atts = ctx.getAttributes(childGroup, new String[]{recursiveAttr});
        Attribute att = atts.get(recursiveAttr);
        if (att != null && att.size() > 0) {
            LOG.debug("Group {} has direct parent groups: {}", (Object)childGroup, (Object)att);
            NamingEnumeration<?> parentGroups = att.getAll();
            while (parentGroups.hasMore()) {
                String parentGroup = parentGroups.next().toString();
                if (knownGroups.add(parentGroup)) {
                    LOG.debug("Found new parent group: {} - recursing...", (Object)parentGroup);
                    this.getParentGroups(parentGroup, knownGroups, ctx, depth + 1);
                    continue;
                }
                LOG.debug("Cycle detected for parent group: {} - stopping recursion.", (Object)parentGroup);
            }
        } else {
            LOG.debug("No parent groups found for group {}", (Object)childGroup);
            this.cache.put((Object)childGroup, Collections.emptySet());
        }
        return knownGroups;
    }

    static {
        SCACHE_SYNC = new Object();
    }
}

