/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.sentry.binding.solr.authz.SentrySolrPluginImpl;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.AuthorizationPlugin;

public abstract class DocAuthorizationComponent
extends SearchComponent {
    public static final String SUPERUSER = System.getProperty("solr.authorization.superuser", "solr");

    public abstract boolean getEnabled();

    public abstract void prepare(ResponseBuilder var1, String var2) throws IOException;

    protected final Set<String> getRoles(SolrQueryRequest req, String userName) {
        SolrCore solrCore = req.getCore();
        AuthorizationPlugin plugin = solrCore.getCoreContainer().getAuthorizationPlugin();
        if (!(plugin instanceof SentrySolrPluginImpl)) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, ((Object)((Object)this)).getClass().getSimpleName() + " can only be used with Sentry authorization plugin for Solr");
        }
        try {
            return ((SentrySolrPluginImpl)plugin).getRoles(userName);
        }
        catch (SentryUserException e) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Request from user: " + userName + " rejected due to SentryUserException: ", (Throwable)e);
        }
    }

    protected final String getUserName(SolrQueryRequest req) {
        if (req instanceof LocalSolrQueryRequest) {
            return SUPERUSER;
        }
        SolrCore solrCore = req.getCore();
        HttpServletRequest httpServletRequest = (HttpServletRequest)req.getContext().get("httpRequest");
        if (httpServletRequest == null) {
            StringBuilder builder = new StringBuilder("Unable to locate HttpServletRequest");
            if (solrCore != null && !solrCore.getSolrConfig().getBool("requestDispatcher/requestParsers/@addHttpRequestToContext", true)) {
                builder.append(", ensure requestDispatcher/requestParsers/@addHttpRequestToContext is set to true in solrconfig.xml");
            }
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, builder.toString());
        }
        String userName = httpServletRequest.getRemoteUser();
        if (userName == null) {
            userName = SentrySolrPluginImpl.getShortUserName((Principal)httpServletRequest.getUserPrincipal());
        }
        if (userName == null) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "This request is not authenticated.");
        }
        return userName;
    }

    public final void prepare(ResponseBuilder rb) throws IOException {
        if (!this.getEnabled()) {
            return;
        }
        String userName = this.getUserName(rb.req);
        if (SUPERUSER.equals(userName)) {
            return;
        }
        this.prepare(rb, userName);
    }
}

