/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.UserAttributeSource;
import org.apache.solr.handler.component.UserAttributeSourceParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingUserAttributeSource
implements UserAttributeSource {
    private static final Logger LOG = LoggerFactory.getLogger(CachingUserAttributeSource.class);
    private final LoadingCache<String, Multimap<String, String>> cache;

    public CachingUserAttributeSource(UserAttributeSource userAttributeSource, long ttlSeconds, long maxCacheSize) {
        this(userAttributeSource, ttlSeconds, maxCacheSize, null);
    }

    @VisibleForTesting
    CachingUserAttributeSource(final UserAttributeSource userAttributeSource, long ttlSeconds, long maxCacheSize, Ticker ticker) {
        LOG.debug("Creating cached user attribute source, userAttributeSource={}, ttlSeconds={}, maxCacheSize={}", new Object[]{userAttributeSource, ttlSeconds, maxCacheSize});
        CacheLoader<String, Multimap<String, String>> cacheLoader = new CacheLoader<String, Multimap<String, String>>(){

            public Multimap<String, String> load(String userName) {
                LOG.debug("User attribute cache miss for user: {}", (Object)userName);
                return userAttributeSource.getAttributesForUser(userName);
            }
        };
        CacheBuilder builder = CacheBuilder.newBuilder().expireAfterWrite(ttlSeconds, TimeUnit.SECONDS).maximumSize(maxCacheSize);
        if (ticker != null) {
            builder.ticker(ticker);
        }
        this.cache = builder.build((CacheLoader)cacheLoader);
    }

    @Override
    public Multimap<String, String> getAttributesForUser(String userName) {
        try {
            return (Multimap)this.cache.get((Object)userName);
        }
        catch (ExecutionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting user attributes from cache", (Throwable)e);
        }
    }

    @Override
    public Class<? extends UserAttributeSourceParams> getParamsClass() {
        return null;
    }

    @Override
    public void init(UserAttributeSourceParams params, Collection<String> attributes) {
    }
}

