/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.shell;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.api.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.apache.sentry.shell.TopLevelShell;

public class SentryCli {
    private static final String LOG4J_CONF = "log4jConf";
    private Options options = new Options();
    private CommandLine cmd;
    private static final String localhost = "localhost";
    private static final String defaultPort = "8038";
    private static final String configOpt = "config";
    private static final String userOpt = "user";
    private static final String hostOpt = "host";
    private static final String configEnv = "SENTRY_CONFIG";
    private static final String hostEnv = "SENTRY_HOST";
    private static final String userEnv = "SENTRY_USER";
    private SentryPolicyServiceClient sentryClient;
    private SentryGenericServiceClient sentryGenericClient;
    private String requestorName;

    public SentryPolicyServiceClient getSentryClient() {
        return this.sentryClient;
    }

    public SentryGenericServiceClient getSentryGenericClient() {
        return this.sentryGenericClient;
    }

    public String getRequestorName() {
        return this.requestorName;
    }

    public static void main(String[] args) {
        SentryCli cli = new SentryCli(args);
        TopLevelShell shell = new TopLevelShell(cli.getSentryClient(), cli.getSentryGenericClient(), cli.getRequestorName());
        shell.run();
    }

    public SentryCli(String[] args) {
        this.options.addOption("h", "help", false, "show help");
        this.options.addOption("U", userOpt, true, "auth user");
        this.options.addOption("H", hostOpt, true, "host address");
        this.options.addOption("c", configOpt, true, "sentry configuration");
        this.options.addOption("L", LOG4J_CONF, true, "Location of log4j properties file");
        GnuParser parser = new GnuParser();
        try {
            this.cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            this.help();
        }
        if (this.cmd.hasOption("h")) {
            this.help();
        }
        this.init();
    }

    private void init() {
        String pathConf;
        String host;
        Map<String, String> env = System.getenv();
        String log4jconf = this.cmd.getOptionValue(LOG4J_CONF);
        if (log4jconf != null && log4jconf.length() > 0) {
            Properties log4jProperties = new Properties();
            try (FileInputStream istream = new FileInputStream(log4jconf);){
                log4jProperties.load(istream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PropertyConfigurator.configure((Properties)log4jProperties);
        }
        if ((host = this.cmd.getOptionValue(hostOpt)) == null) {
            host = env.get(hostEnv);
        }
        if ((pathConf = this.cmd.getOptionValue(configOpt)) == null) {
            pathConf = env.get(configEnv);
        }
        if (host == null && pathConf == null) {
            host = "localhost:8038";
        }
        Configuration conf = new Configuration();
        if (pathConf != null) {
            conf.addResource(new Path(pathConf), true);
        } else {
            conf.set("sentry.service.security.mode", "none");
        }
        if (host != null) {
            conf.set("sentry.service.client.server.rpc-addresses", host);
        }
        this.requestorName = this.cmd.getOptionValue(userOpt);
        if (this.requestorName == null) {
            this.requestorName = env.get(userEnv);
        }
        if (this.requestorName == null) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.requestorName = ugi.getShortUserName();
        }
        try {
            this.sentryClient = SentryServiceClientFactory.create((Configuration)conf);
            this.sentryGenericClient = SentryGenericServiceClientFactory.create((Configuration)conf);
        }
        catch (Exception e) {
            System.out.println("Failed to connect to Sentry server: " + e.toString());
        }
    }

    private void help() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("sentrycli", this.options);
        System.exit(0);
    }
}

