/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.shell;

import com.budhash.cliche.Command;
import com.budhash.cliche.Shell;
import com.budhash.cliche.ShellDependent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.sentry.cli.tools.ShellCommand;
import org.apache.sentry.core.common.exception.SentryUserException;

public class GroupShell
implements ShellDependent {
    private final ShellCommand shellCommand;
    private final String authUser;
    Shell shell;

    public GroupShell(ShellCommand shellCommand, String authUser) {
        this.shellCommand = shellCommand;
        this.authUser = authUser;
    }

    @Command(abbrev="lr", header="[groups]", description="list groups and their roles")
    public List<String> listRoles() {
        try {
            return this.shellCommand.listGroupRoles(this.authUser);
        }
        catch (SentryUserException e) {
            System.out.printf("failed to list the groups and roles: %s\n", e.toString());
            return Collections.emptyList();
        }
    }

    @Command(description="Grant role to groups")
    public void grant(String roleName, String ... groups) {
        try {
            HashSet<String> groupsSet = new HashSet<String>(Arrays.asList(groups));
            this.shellCommand.grantRoleToGroups(this.authUser, roleName, groupsSet);
        }
        catch (SentryUserException e) {
            System.out.printf("Failed to gran role %s to groups: %s\n", roleName, e.toString());
        }
    }

    @Command(description="Revoke role from groups")
    public void revoke(String roleName, String ... groups) {
        try {
            HashSet<String> groupsSet = new HashSet<String>(Arrays.asList(groups));
            this.shellCommand.revokeRoleFromGroups(this.authUser, roleName, groupsSet);
        }
        catch (SentryUserException e) {
            System.out.printf("Failed to revoke role %s to groups: %s\n", roleName, e.toString());
        }
    }

    public void cliSetShell(Shell theShell) {
        this.shell = theShell;
    }
}

