/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools.command.hive;

import org.apache.commons.lang.StringUtils;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;

public final class CommandUtil {
    public static final String SPLIT_CHAR = ",";

    private CommandUtil() {
    }

    public static void validatePrivilegeHierarchy(TSentryPrivilege tSentryPrivilege) throws IllegalArgumentException {
        String serverName = tSentryPrivilege.getServerName();
        String dbName = tSentryPrivilege.getDbName();
        String tableName = tSentryPrivilege.getTableName();
        String columnName = tSentryPrivilege.getColumnName();
        String uri = tSentryPrivilege.getURI();
        if (ApiConstants.PrivilegeScope.SERVER.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) : (ApiConstants.PrivilegeScope.URI.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)uri) : (ApiConstants.PrivilegeScope.DATABASE.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)dbName) : (ApiConstants.PrivilegeScope.TABLE.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)dbName) || StringUtils.isEmpty((String)tableName) : ApiConstants.PrivilegeScope.COLUMN.toString().equals(tSentryPrivilege.getPrivilegeScope()) && (StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)dbName) || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)))))) {
            throw new IllegalArgumentException("The hierarchy of privilege is not correct.");
        }
    }
}

