/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.api.tools.GenericPrivilegeConverter;
import org.apache.sentry.api.tools.TSentryPrivilegeConverter;
import org.apache.sentry.cli.tools.SentryShellCommon;
import org.apache.sentry.cli.tools.command.GenericShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryShellGeneric
extends SentryShellCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryShellGeneric.class);
    private static final String KAFKA_SERVICE_NAME = "sentry.service.client.kafka.service.name";
    private static final String SOLR_SERVICE_NAME = "sentry.service.client.solr.service.name";
    private static final String SQOOP_SERVICE_NAME = "sentry.service.client.sqoop.service.name";

    @Override
    public void run() throws Exception {
        String component = this.getComponent();
        Configuration conf = this.getSentryConf();
        String service = this.getService(conf);
        try (SentryGenericServiceClient client = SentryGenericServiceClientFactory.create((Configuration)conf);){
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            String requestorName = ugi.getShortUserName();
            GenericPrivilegeConverter converter = this.getPrivilegeConverter(component, service);
            GenericShellCommand command = new GenericShellCommand(client, component, service, (TSentryPrivilegeConverter)converter);
            if (StringUtils.isEmpty((String)requestorName)) {
                throw new Exception("The requestor name is empty.");
            }
            if (this.isCreateRole) {
                command.createRole(requestorName, this.roleName);
            } else if (this.isDropRole) {
                command.dropRole(requestorName, this.roleName);
            } else if (this.isAddRoleGroup) {
                HashSet groups = Sets.newHashSet((Object[])this.groupName.split(","));
                command.grantRoleToGroups(requestorName, this.roleName, groups);
            } else if (this.isDeleteRoleGroup) {
                HashSet groups = Sets.newHashSet((Object[])this.groupName.split(","));
                command.revokeRoleFromGroups(requestorName, this.roleName, groups);
            } else if (this.isGrantPrivilegeRole) {
                command.grantPrivilegeToRole(requestorName, this.roleName, this.privilegeStr);
            } else if (this.isRevokePrivilegeRole) {
                command.revokePrivilegeFromRole(requestorName, this.roleName, this.privilegeStr);
            } else if (this.isListRole) {
                List<String> roles = command.listRoles(requestorName, this.groupName);
                for (String role : roles) {
                    System.out.println(role);
                }
            } else if (this.isListPrivilege) {
                List<String> privileges = command.listPrivileges(requestorName, this.roleName);
                for (String privilege : privileges) {
                    System.out.println(privilege);
                }
            } else if (this.isListGroup) {
                List<String> groups = command.listGroupRoles(requestorName);
                for (String group : groups) {
                    System.out.println(group);
                }
            }
        }
    }

    protected GenericPrivilegeConverter getPrivilegeConverter(String component, String service) {
        return new GenericPrivilegeConverter(component, service);
    }

    protected String getComponent() throws Exception {
        if (this.type == SentryShellCommon.TYPE.kafka) {
            return "kafka";
        }
        if (this.type == SentryShellCommon.TYPE.solr) {
            return "SOLR";
        }
        if (this.type == SentryShellCommon.TYPE.sqoop) {
            return "sqoop";
        }
        throw new Exception("Invalid type specified for SentryShellGeneric: " + (Object)((Object)this.type));
    }

    protected String getService(Configuration conf) throws Exception {
        if (this.type == SentryShellCommon.TYPE.kafka) {
            return conf.get(KAFKA_SERVICE_NAME, "kafka");
        }
        if (this.type == SentryShellCommon.TYPE.solr) {
            return conf.get(SOLR_SERVICE_NAME, "service1");
        }
        if (this.type == SentryShellCommon.TYPE.sqoop) {
            return conf.get(SQOOP_SERVICE_NAME, "sqoopServer1");
        }
        throw new Exception("Invalid type specified for SentryShellGeneric: " + (Object)((Object)this.type));
    }

    private Configuration getSentryConf() {
        Configuration conf = new Configuration();
        conf.addResource(new Path(this.confPath), true);
        return conf;
    }

    public static void main(String[] args) throws Exception {
        SentryShellGeneric sentryShell = new SentryShellGeneric();
        try {
            sentryShell.executeShell(args);
        }
        catch (Exception e) {
            Throwable current;
            LOGGER.error(e.getMessage(), (Throwable)e);
            for (current = e; current != null && current.getMessage() == null; current = current.getCause()) {
            }
            String error = "";
            if (current != null && current.getMessage() != null) {
                error = "Message: " + current.getMessage();
            }
            System.out.println("The operation failed. " + error);
            System.exit(1);
        }
    }
}

