/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.cli.tools.SentryStoreUpgrade;
import org.apache.sentry.provider.db.service.persistent.SentryStore;

public class ImpalaRefreshPrivilegesUpgrade
implements SentryStoreUpgrade {
    private static final String REFRESH = "REFRESH";
    private static final String SELECT = "SELECT";
    private static final String INSERT = "INSERT";
    private final Set<String> ALLOWED_SCOPES = Sets.newHashSet((Object[])new String[]{ApiConstants.PrivilegeScope.SERVER.toString(), ApiConstants.PrivilegeScope.DATABASE.toString(), ApiConstants.PrivilegeScope.TABLE.toString()});
    private final Set<String> UPGRADES_FROM_VERSIONS = Sets.newHashSet((Object[])new String[]{"1.4.0", "1.4.0-cdh5", "1.4.0-cdh5-2", "1.5.0", "1.5.0-cdh5", "2.0.0"});

    @Override
    public boolean needsUpgrade(String fromVersion) {
        return this.UPGRADES_FROM_VERSIONS.contains(fromVersion.toLowerCase());
    }

    @Override
    public void upgrade(SentryStore store) throws Exception {
        Map rolesPrivileges = store.getAllRolesPrivileges();
        for (String roleName : rolesPrivileges.keySet()) {
            HashSet refreshPrivilegesToAdd = Sets.newHashSet();
            for (TSentryPrivilege p : (Set)rolesPrivileges.get(roleName)) {
                if ((this.checkPrivilege(p, SELECT) || this.checkPrivilege(p, INSERT)) && this.isScopeAllowed(p)) {
                    refreshPrivilegesToAdd.add(RefreshPrivilege.copyFrom(p));
                    continue;
                }
                if (!this.checkPrivilege(p, REFRESH)) continue;
                refreshPrivilegesToAdd.remove(RefreshPrivilege.copyFrom(p));
            }
            if (refreshPrivilegesToAdd.isEmpty()) continue;
            HashSet<TSentryPrivilege> privileges = new HashSet<TSentryPrivilege>();
            for (RefreshPrivilege p : refreshPrivilegesToAdd) {
                privileges.add(p.toSentryPrivilege());
            }
            store.alterSentryRoleGrantPrivileges(roleName, privileges);
        }
    }

    private boolean checkPrivilege(TSentryPrivilege p, String action) {
        return p != null && p.getAction().equalsIgnoreCase(action);
    }

    private boolean isScopeAllowed(TSentryPrivilege p) {
        return p != null && this.ALLOWED_SCOPES.contains(p.getPrivilegeScope().toUpperCase());
    }

    private static class RefreshPrivilege {
        private String scope;
        private String server;
        private String db;
        private String table;

        static RefreshPrivilege copyFrom(TSentryPrivilege from) {
            return new RefreshPrivilege(from.getPrivilegeScope(), from.getServerName(), from.getDbName(), from.getTableName());
        }

        private RefreshPrivilege(String scope, String server, String db, String table) {
            this.scope = scope;
            this.server = server;
            this.db = db;
            this.table = table;
        }

        TSentryPrivilege toSentryPrivilege() {
            TSentryPrivilege p = new TSentryPrivilege();
            p.setPrivilegeScope(this.scope);
            p.setServerName(this.server);
            p.setAction(ImpalaRefreshPrivilegesUpgrade.REFRESH);
            if (this.db != null) {
                p.setDbName(this.db);
            }
            if (this.table != null) {
                p.setTableName(this.table);
            }
            p.setGrantOption(TSentryGrantOption.FALSE);
            return p;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.scope, this.server, this.db, this.table});
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof RefreshPrivilege)) {
                return false;
            }
            RefreshPrivilege op = (RefreshPrivilege)o;
            return StringUtils.equals((String)this.scope, (String)op.scope) && StringUtils.equals((String)this.server, (String)op.server) && StringUtils.equals((String)this.db, (String)op.db) && StringUtils.equals((String)this.table, (String)op.table);
        }
    }
}

