/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sentry.SentryVersionInfo;
import org.apache.sentry.binding.hive.authz.SentryConfigTool;
import org.apache.sentry.cli.tools.SentrySchemaTool;
import org.apache.sentry.service.thrift.SentryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryMain {
    private static final String HELP_SHORT = "h";
    private static final String HELP_LONG = "help";
    private static final String VERSION_SHORT = "v";
    private static final String VERSION_LONG = "version";
    private static final String COMMAND = "command";
    private static final String HIVE_CONF = "hiveconf";
    private static final String LOG4J_CONF = "log4jConf";
    private static final String LOG4J_DATANUCLEUS = "log4j.category.DataNucleus.Query";
    private static final List<String> COMMANDS = Arrays.asList("service", "config-tool", "schema-tool");

    private SentryMain() {
    }

    public static void main(String[] args) throws Exception {
        String commandName;
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption(HELP_SHORT, HELP_LONG, false, "Print this help text");
        options.addOption(VERSION_SHORT, VERSION_LONG, false, "Print Sentry version");
        options.addOption(HIVE_CONF, true, "Set hive configuration variables");
        options.addOption(null, COMMAND, true, "Command to run. Options: " + COMMANDS);
        options.addOption(null, LOG4J_CONF, true, "Location of log4j properties file");
        CommandLine commandLine = parser.parse(options, args, true);
        String log4jconf = commandLine.getOptionValue(LOG4J_CONF);
        if (log4jconf != null && log4jconf.length() > 0) {
            Properties log4jProperties = new Properties();
            InputStream istream = Files.newInputStream(Paths.get(log4jconf, new String[0]), new OpenOption[0]);
            Object object = null;
            try {
                log4jProperties.load(istream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (istream != null) {
                    if (object != null) {
                        try {
                            istream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        istream.close();
                    }
                }
            }
            if (!log4jProperties.containsKey(LOG4J_DATANUCLEUS)) {
                log4jProperties.setProperty(LOG4J_DATANUCLEUS, "INFO");
                String logThreshold = log4jProperties.getProperty("log.threshold");
                if (logThreshold != null && logThreshold.equalsIgnoreCase("TRACE")) {
                    log4jProperties.setProperty(LOG4J_DATANUCLEUS, "DEBUG");
                }
            }
            PropertyConfigurator.configure((Properties)log4jProperties);
            Logger sentryLogger = LoggerFactory.getLogger(SentryMain.class);
            sentryLogger.info("Configuring log4j to use [" + log4jconf + "]");
        }
        if ((commandName = commandLine.getOptionValue(COMMAND)) == null && (commandLine.hasOption(HELP_SHORT) || commandLine.hasOption(HELP_LONG))) {
            SentryMain.printHelp(options, "Command name is missing.");
        } else if (commandLine.hasOption(VERSION_SHORT) || commandLine.hasOption(VERSION_LONG)) {
            SentryMain.printVersion();
        }
        Object command = null;
        switch (commandName) {
            case "service": {
                command = new SentryService.CommandImpl();
                break;
            }
            case "config-tool": {
                command = new SentryConfigTool.CommandImpl();
                break;
            }
            case "schema-tool": {
                command = new SentrySchemaTool.CommandImpl();
                break;
            }
            default: {
                SentryMain.printHelp(options, "Unknown command " + commandName + "\n");
            }
        }
        command.run(commandLine.getArgs());
    }

    private static void printVersion() {
        System.out.println(SentryVersionInfo.getBuildVersion());
        System.exit(0);
    }

    private static void printHelp(Options options, String msg) {
        String sentry = "sentry";
        if (msg != null) {
            sentry = msg + sentry;
        }
        new HelpFormatter().printHelp(sentry, options);
        System.exit(1);
    }
}

