/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Locale;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.util.RedactionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXJsonServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    public static String REDACT_STRING = RedactionUtils.getRedactString();
    protected transient MBeanServer mBeanServer = null;

    public void init() {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json; charset=utf8");
        MultiMapSolrParams params = SolrRequestParsers.parseQueryString(request.getQueryString());
        JsonFactory jsonFactory = new JsonFactory();
        try (JsonGenerator jg = jsonFactory.createJsonGenerator((Writer)response.getWriter());){
            jg.useDefaultPrettyPrinter();
            jg.writeStartObject();
            jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            if (this.mBeanServer == null) {
                jg.writeStringField("result", "ERROR");
                jg.writeStringField("message", "No MBeanServer could be found");
                LOG.error("No MBeanServer could be found.");
                response.setStatus(404);
                return;
            }
            String getmethod = params.get("get");
            if (getmethod != null) {
                String[] splitStrings = getmethod.split("\\:\\:");
                if (splitStrings.length != 2) {
                    jg.writeStringField("result", "ERROR");
                    jg.writeStringField("message", "query format is not as expected.");
                    response.setStatus(400);
                    return;
                }
                this.listBeans(jg, new ObjectName(splitStrings[0]), splitStrings[1], response);
                return;
            }
            String qry = params.get("qry");
            if (qry == null) {
                qry = "*:*";
            }
            this.listBeans(jg, new ObjectName(qry), null, response);
        }
        catch (IOException e) {
            LOG.error("Caught an exception while processing JMX request", (Throwable)e);
            response.setStatus(500);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Caught an exception while processing JMX request", (Throwable)e);
            response.setStatus(400);
        }
        catch (Exception e) {
            LOG.error("Caught an exception while processing JMX request", (Throwable)e);
            response.setStatus(500);
            throw e;
        }
    }

    private void listBeans(JsonGenerator jg, ObjectName qry, String attribute, HttpServletResponse response) throws IOException {
        LOG.debug("Listing beans for " + qry);
        Set<ObjectName> names = null;
        names = this.mBeanServer.queryNames(qry, null);
        jg.writeArrayFieldStart("beans");
        for (ObjectName oname : names) {
            MBeanInfo minfo;
            Object attributeinfo;
            String code;
            block18: {
                code = "";
                attributeinfo = null;
                try {
                    minfo = this.mBeanServer.getMBeanInfo(oname);
                    code = minfo.getClassName();
                    String prs = "";
                    try {
                        if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                            prs = "modelerType";
                            code = (String)this.mBeanServer.getAttribute(oname, prs);
                        }
                        if (attribute != null) {
                            prs = attribute;
                            attributeinfo = this.mBeanServer.getAttribute(oname, prs);
                        }
                    }
                    catch (RuntimeMBeanException e) {
                        if (e.getCause() instanceof UnsupportedOperationException) {
                            LOG.debug("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                            break block18;
                        }
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (AttributeNotFoundException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (MBeanException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                    catch (ReflectionException e) {
                        LOG.error("getting attribute " + prs + " of " + oname + " threw an exception", (Throwable)e);
                    }
                }
                catch (InstanceNotFoundException e) {
                    continue;
                }
                catch (IntrospectionException e) {
                    LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, (Throwable)e);
                    continue;
                }
                catch (ReflectionException e) {
                    LOG.error("Problem while trying to process JMX query: " + qry + " with MBean " + oname, (Throwable)e);
                    continue;
                }
            }
            jg.writeStartObject();
            jg.writeStringField("name", oname.toString());
            jg.writeStringField("modelerType", code);
            if (attribute != null && attributeinfo == null) {
                jg.writeStringField("result", "ERROR");
                jg.writeStringField("message", "No attribute with name " + attribute + " was found.");
                jg.writeEndObject();
                jg.writeEndArray();
                response.setStatus(404);
                return;
            }
            if (attribute != null) {
                JMXJsonServlet.writeAttribute(jg, attribute, attributeinfo);
            } else {
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    this.writeAttribute(jg, oname, attrs[i]);
                }
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private void writeAttribute(JsonGenerator jg, ObjectName oname, MBeanAttributeInfo attr) throws IOException {
        if (!attr.isReadable()) {
            return;
        }
        String attName = attr.getName();
        if ("modelerType".equals(attName)) {
            return;
        }
        if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
            return;
        }
        Object value = null;
        try {
            value = this.mBeanServer.getAttribute(oname, attName);
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                LOG.debug("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            } else {
                LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            }
            return;
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        catch (MBeanException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (ReflectionException e) {
            LOG.error("getting attribute " + attName + " of " + oname + " threw an exception", (Throwable)e);
            return;
        }
        catch (InstanceNotFoundException e) {
            return;
        }
        JMXJsonServlet.writeAttribute(jg, attName, value);
    }

    @VisibleForTesting
    public static void writeAttribute(JsonGenerator jg, String attName, Object value) throws IOException {
        jg.writeFieldName(attName);
        JMXJsonServlet.writeObject(jg, value);
    }

    private static void writeObject(JsonGenerator jg, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                jg.writeStartArray();
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value, j);
                    JMXJsonServlet.writeObject(jg, item);
                }
                jg.writeEndArray();
            } else if (value instanceof Number) {
                Number n = (Number)value;
                jg.writeNumber(n.toString());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jg.writeBoolean(b.booleanValue());
            } else if (value instanceof CompositeData) {
                String keyValStr;
                Object keyVal;
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                jg.writeStartObject();
                boolean needsRedact = false;
                Object object = keyVal = cds.containsKey("key") ? cds.get("key") : null;
                if (keyVal instanceof String && (RedactionUtils.isSystemPropertySensitive(keyValStr = keyVal.toString()) || keyValStr.startsWith("-D") && keyValStr.contains("=") && RedactionUtils.isSystemPropertySensitive(keyValStr.substring(2, keyValStr.indexOf("="))))) {
                    needsRedact = true;
                }
                for (String key : keys) {
                    Object val = cds.get(key);
                    if (needsRedact && key.equals("value")) {
                        val = REDACT_STRING;
                    }
                    JMXJsonServlet.writeAttribute(jg, key, val);
                }
                jg.writeEndObject();
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                jg.writeStartArray();
                for (Object entry : tds.values()) {
                    JMXJsonServlet.writeObject(jg, entry);
                }
                jg.writeEndArray();
            } else {
                String valueStr = value.toString();
                if (valueStr.contains("=")) {
                    if (valueStr.startsWith("-D") && RedactionUtils.isSystemPropertySensitive(valueStr.substring(2, valueStr.indexOf("=")))) {
                        valueStr = String.format(Locale.ROOT, "%s=%s", valueStr.substring(0, valueStr.indexOf("=")), REDACT_STRING);
                    } else if (RedactionUtils.isSystemPropertySensitive(valueStr.substring(0, valueStr.indexOf("=")))) {
                        valueStr = String.format(Locale.ROOT, "%s=%s", valueStr.substring(0, valueStr.indexOf("=")), REDACT_STRING);
                    }
                }
                jg.writeString(valueStr);
            }
        }
    }
}

