/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.CurrencyFieldType;
import org.apache.solr.schema.CurrencyValue;
import org.apache.solr.schema.ExchangeRateProvider;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRange;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.util.DateMathParser;

class FacetRangeProcessor
extends FacetProcessor<FacetRange> {
    final SchemaField sf;
    final Calc calc;
    final EnumSet<FacetParams.FacetRangeInclude> include;
    final long effectiveMincount;
    final Comparable start;
    final Comparable end;
    final String gap;
    List<Range> rangeList;
    List<Range> otherList;
    Comparable actual_end = null;
    private Query[] filters;
    private DocSet[] intersections;

    FacetRangeProcessor(FacetContext fcontext, FacetRange freq) {
        super(fcontext, freq);
        this.include = freq.include;
        this.sf = fcontext.searcher.getSchema().getField(freq.field);
        this.calc = FacetRangeProcessor.getCalcForField(this.sf);
        this.start = this.calc.getValue(freq.start.toString());
        this.end = this.calc.getValue(freq.end.toString());
        this.gap = freq.gap.toString();
        this.effectiveMincount = fcontext.isShard() ? 0L : freq.mincount;
    }

    @Override
    public void process() throws IOException {
        super.process();
        if (this.fcontext.facetInfo != null) {
            this.response = this.refineFacets();
        } else {
            this.createRangeList();
            this.response = this.getRangeCountsIndexed();
        }
    }

    public static Calc getNumericCalc(SchemaField sf) {
        Calc calc;
        block15: {
            block16: {
                FieldType ft;
                block14: {
                    ft = sf.getType();
                    if (!(ft instanceof TrieField)) break block14;
                    switch (ft.getNumberType()) {
                        case FLOAT: {
                            calc = new FloatCalc(sf);
                            break block15;
                        }
                        case DOUBLE: {
                            calc = new DoubleCalc(sf);
                            break block15;
                        }
                        case INTEGER: {
                            calc = new IntCalc(sf);
                            break block15;
                        }
                        case LONG: {
                            calc = new LongCalc(sf);
                            break block15;
                        }
                        case DATE: {
                            calc = new DateCalc(sf, null);
                            break block15;
                        }
                        default: {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected numeric field type :" + sf);
                        }
                    }
                }
                if (!(ft instanceof PointField)) break block16;
                switch (ft.getNumberType()) {
                    case FLOAT: {
                        calc = new FloatCalc(sf);
                        break block15;
                    }
                    case DOUBLE: {
                        calc = new DoubleCalc(sf);
                        break block15;
                    }
                    case INTEGER: {
                        calc = new IntCalc(sf);
                        break block15;
                    }
                    case LONG: {
                        calc = new LongCalc(sf);
                        break block15;
                    }
                    case DATE: {
                        calc = new DateCalc(sf, null);
                        break block15;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected numeric field type :" + sf);
                    }
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected numeric field type :" + sf);
        }
        return calc;
    }

    private static Calc getCalcForField(SchemaField sf) {
        FieldType ft = sf.getType();
        if (ft instanceof TrieField || ft.isPointField()) {
            switch (ft.getNumberType()) {
                case FLOAT: {
                    return new FloatCalc(sf);
                }
                case DOUBLE: {
                    return new DoubleCalc(sf);
                }
                case INTEGER: {
                    return new IntCalc(sf);
                }
                case LONG: {
                    return new LongCalc(sf);
                }
                case DATE: {
                    return new DateCalc(sf, null);
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on numeric field of unexpected type:" + sf.getName());
        }
        if (ft instanceof CurrencyFieldType) {
            return new CurrencyCalc(sf);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + sf.getName());
    }

    private void createRangeList() throws IOException {
        this.rangeList = new ArrayList<Range>();
        this.otherList = new ArrayList<Range>(3);
        Comparable low = this.start;
        Comparable loop_end = this.end;
        while (low.compareTo(this.end) < 0) {
            Comparable high = this.calc.addGap(low, this.gap);
            if (this.end.compareTo(high) < 0) {
                if (((FacetRange)this.freq).hardend) {
                    high = loop_end;
                } else {
                    loop_end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            if (high.compareTo(low) == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + this.gap + " = " + high);
            }
            boolean incLower = this.include.contains(FacetParams.FacetRangeInclude.LOWER) || this.include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(this.start);
            boolean incUpper = this.include.contains(FacetParams.FacetRangeInclude.UPPER) || this.include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(this.end);
            Range range = new Range(this.calc.buildRangeLabel(low), low, high, incLower, incUpper);
            this.rangeList.add(range);
            low = high;
        }
        if (!((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.NONE)) {
            boolean all = ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.ALL);
            if (all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                this.otherList.add(this.buildBeforeRange());
            }
            if (all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.AFTER)) {
                this.actual_end = loop_end;
                this.otherList.add(this.buildAfterRange());
            }
            if (all || ((FacetRange)this.freq).others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                this.actual_end = loop_end;
                this.otherList.add(this.buildBetweenRange());
            }
        }
        if (((FacetRange)this.freq).hardend || !this.fcontext.isShard()) {
            this.actual_end = null;
        }
    }

    private SimpleOrderedMap getRangeCountsIndexed() throws IOException {
        SimpleOrderedMap bucket;
        Range range;
        int idx;
        int idx2;
        int slotCount = this.rangeList.size() + this.otherList.size();
        this.intersections = new DocSet[slotCount];
        this.filters = new Query[slotCount];
        this.createAccs(this.fcontext.base.size(), slotCount);
        for (idx2 = 0; idx2 < this.rangeList.size(); ++idx2) {
            this.rangeStats(this.rangeList.get(idx2), idx2);
        }
        for (idx2 = 0; idx2 < this.otherList.size(); ++idx2) {
            this.rangeStats(this.otherList.get(idx2), this.rangeList.size() + idx2);
        }
        SimpleOrderedMap res = new SimpleOrderedMap();
        ArrayList<SimpleOrderedMap> buckets = new ArrayList<SimpleOrderedMap>();
        res.add("buckets", buckets);
        for (idx = 0; idx < this.rangeList.size(); ++idx) {
            if (this.effectiveMincount > 0L && (long)this.countAcc.getCount(idx) < this.effectiveMincount) continue;
            range = this.rangeList.get(idx);
            bucket = new SimpleOrderedMap();
            buckets.add(bucket);
            bucket.add("val", range.label);
            this.addStats((SimpleOrderedMap<Object>)bucket, idx);
            this.doSubs(bucket, idx);
        }
        for (idx = 0; idx < this.otherList.size(); ++idx) {
            range = this.otherList.get(idx);
            bucket = new SimpleOrderedMap();
            res.add(range.label.toString(), (Object)bucket);
            this.addStats((SimpleOrderedMap<Object>)bucket, this.rangeList.size() + idx);
            this.doSubs(bucket, this.rangeList.size() + idx);
        }
        if (null != this.actual_end) {
            res.add("_actual_end", (Object)this.calc.formatValue(this.actual_end));
        }
        return res;
    }

    private void rangeStats(Range range, int slot) throws IOException {
        Query rangeQ = this.sf.getType().getRangeQuery(null, this.sf, range.low == null ? null : this.calc.formatValue(range.low), range.high == null ? null : this.calc.formatValue(range.high), range.includeLower, range.includeUpper);
        DocSet intersection = this.fcontext.searcher.getDocSet(rangeQ, this.fcontext.base);
        this.filters[slot] = rangeQ;
        this.intersections[slot] = intersection;
        int num = this.collect(intersection, slot, (int slotNum) -> new SlotAcc.SlotContext(rangeQ));
        this.countAcc.incrementCount(slot, num);
    }

    private void doSubs(SimpleOrderedMap bucket, int slot) throws IOException {
        if (((FacetRange)this.freq).getSubFacets().size() > 0) {
            DocSet subBase = this.intersections[slot];
            this.processSubs((SimpleOrderedMap<Object>)bucket, this.filters[slot], subBase, false, null);
        }
    }

    protected SimpleOrderedMap<Object> refineFacets() throws IOException {
        boolean skipThisFacet = (this.fcontext.flags & 4) != 0;
        List<List> skip = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_s"));
        assert (0 == FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_l")).size());
        assert (0 == FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_p")).size());
        SimpleOrderedMap res = new SimpleOrderedMap();
        ArrayList<SimpleOrderedMap<Object>> bucketList = new ArrayList<SimpleOrderedMap<Object>>(skip.size());
        res.add("buckets", bucketList);
        this.createAccs(-1, 1);
        for (List bucketAndFacetInfo : skip) {
            assert (bucketAndFacetInfo.size() == 2);
            Object bucketVal = bucketAndFacetInfo.get(0);
            Map facetInfo = (Map)bucketAndFacetInfo.get(1);
            bucketList.add(this.refineBucket(bucketVal, true, facetInfo));
        }
        Map specialFacetInfo = (Map)this.fcontext.facetInfo.get(FacetParams.FacetRangeOther.BEFORE.toString());
        if (null != specialFacetInfo) {
            res.add(FacetParams.FacetRangeOther.BEFORE.toString(), this.refineRange(this.buildBeforeRange(), skipThisFacet, specialFacetInfo));
        }
        if (null != (specialFacetInfo = (Map)this.fcontext.facetInfo.get(FacetParams.FacetRangeOther.AFTER.toString()))) {
            res.add(FacetParams.FacetRangeOther.AFTER.toString(), this.refineRange(this.buildAfterRange(), skipThisFacet, specialFacetInfo));
        }
        if (null != (specialFacetInfo = (Map)this.fcontext.facetInfo.get(FacetParams.FacetRangeOther.BETWEEN.toString()))) {
            res.add(FacetParams.FacetRangeOther.BETWEEN.toString(), this.refineRange(this.buildBetweenRange(), skipThisFacet, specialFacetInfo));
        }
        return res;
    }

    private Comparable getOrComputeActualEndForRefinement() {
        if (null != this.actual_end) {
            return this.actual_end;
        }
        if (((FacetRange)this.freq).hardend) {
            this.actual_end = this.end;
        } else if (this.fcontext.facetInfo.containsKey("_actual_end")) {
            this.actual_end = this.calc.getValue(this.fcontext.facetInfo.get("_actual_end").toString());
        } else {
            Comparable low = this.start;
            while (low.compareTo(this.end) < 0) {
                Comparable high = this.calc.addGap(low, this.gap);
                if (this.end.compareTo(high) < 0) {
                    this.actual_end = high;
                    break;
                }
                if (high.compareTo(low) <= 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Garbage input for facet refinement w/o _actual_end");
                }
                low = high;
            }
        }
        assert (null != this.actual_end);
        return this.actual_end;
    }

    private SimpleOrderedMap<Object> refineBucket(Object bucketVal, boolean skip, Map<String, Object> facetInfo) throws IOException {
        Comparable low = this.calc.getValue(bucketVal.toString());
        Comparable high = this.calc.addGap(low, this.gap);
        Comparable max_end = this.end;
        if (this.end.compareTo(high) < 0) {
            if (((FacetRange)this.freq).hardend) {
                high = max_end;
            } else {
                max_end = high;
            }
        }
        if (high.compareTo(low) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
        }
        if (high.compareTo(low) == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + this.gap + " = " + high);
        }
        boolean incLower = this.include.contains(FacetParams.FacetRangeInclude.LOWER) || this.include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(this.start);
        boolean incUpper = this.include.contains(FacetParams.FacetRangeInclude.UPPER) || this.include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(max_end);
        Range range = new Range(this.calc.buildRangeLabel(low), low, high, incLower, incUpper);
        SimpleOrderedMap<Object> bucket = this.refineRange(range, skip, facetInfo);
        bucket.add("val", range.label);
        return bucket;
    }

    private SimpleOrderedMap<Object> refineRange(Range range, boolean skip, Map<String, Object> facetInfo) throws IOException {
        SimpleOrderedMap bucket = new SimpleOrderedMap();
        Query domainQ = this.sf.getType().getRangeQuery(null, this.sf, range.low == null ? null : this.calc.formatValue(range.low), range.high == null ? null : this.calc.formatValue(range.high), range.includeLower, range.includeUpper);
        this.fillBucket((SimpleOrderedMap<Object>)bucket, domainQ, null, skip, facetInfo);
        return bucket;
    }

    private Range buildBeforeRange() {
        boolean incUpper = this.include.contains(FacetParams.FacetRangeInclude.OUTER) || !this.include.contains(FacetParams.FacetRangeInclude.LOWER) && !this.include.contains(FacetParams.FacetRangeInclude.EDGE);
        return new Range(FacetParams.FacetRangeOther.BEFORE.toString(), null, this.start, false, incUpper);
    }

    private Range buildAfterRange() {
        Comparable the_end = this.getOrComputeActualEndForRefinement();
        assert (null != the_end);
        boolean incLower = this.include.contains(FacetParams.FacetRangeInclude.OUTER) || !this.include.contains(FacetParams.FacetRangeInclude.UPPER) && !this.include.contains(FacetParams.FacetRangeInclude.EDGE);
        return new Range(FacetParams.FacetRangeOther.AFTER.toString(), the_end, null, incLower, false);
    }

    private Range buildBetweenRange() {
        Comparable the_end = this.getOrComputeActualEndForRefinement();
        assert (null != the_end);
        boolean incLower = this.include.contains(FacetParams.FacetRangeInclude.LOWER) || this.include.contains(FacetParams.FacetRangeInclude.EDGE);
        boolean incUpper = this.include.contains(FacetParams.FacetRangeInclude.UPPER) || this.include.contains(FacetParams.FacetRangeInclude.EDGE);
        return new Range(FacetParams.FacetRangeOther.BETWEEN.toString(), this.start, the_end, incLower, incUpper);
    }

    private static class CurrencyCalc
    extends Calc {
        private String defaultCurrencyCode;
        private ExchangeRateProvider exchangeRateProvider;

        public CurrencyCalc(SchemaField field) {
            super(field);
            if (!(this.field.getType() instanceof CurrencyFieldType)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot perform range faceting over non CurrencyField fields");
            }
            this.defaultCurrencyCode = ((CurrencyFieldType)this.field.getType()).getDefaultCurrency();
            this.exchangeRateProvider = ((CurrencyFieldType)this.field.getType()).getProvider();
        }

        @Override
        public Comparable bitsToValue(long bits) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Currency Field " + this.field.getName() + " can not be used in this way");
        }

        @Override
        public long bitsToSortableBits(long bits) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Currency Field " + this.field.getName() + " can not be used in this way");
        }

        @Override
        public Object buildRangeLabel(Comparable low) {
            return ((CurrencyValue)low).strValue();
        }

        @Override
        public String formatValue(Comparable val) {
            return ((CurrencyValue)val).strValue();
        }

        @Override
        protected Comparable parseStr(String rawval) throws ParseException {
            return CurrencyValue.parse(rawval, this.defaultCurrencyCode);
        }

        @Override
        protected Object parseGap(String rawval) throws ParseException {
            return this.parseStr(rawval);
        }

        @Override
        protected Comparable parseAndAddGap(Comparable value, String gap) throws ParseException {
            if (value == null) {
                throw new NullPointerException("Cannot perform range faceting on null CurrencyValue");
            }
            CurrencyValue val = (CurrencyValue)value;
            CurrencyValue gapCurrencyValue = CurrencyValue.parse(gap, this.defaultCurrencyCode);
            long gapAmount = CurrencyValue.convertAmount(this.exchangeRateProvider, gapCurrencyValue.getCurrencyCode(), gapCurrencyValue.getAmount(), val.getCurrencyCode());
            return new CurrencyValue(val.getAmount() + gapAmount, val.getCurrencyCode());
        }
    }

    private static class DateCalc
    extends Calc {
        private final Date now;

        public DateCalc(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof TrieDateField) && !this.field.getType().isPointField()) {
                throw new IllegalArgumentException("SchemaField must use field type extending TrieDateField, DateRangeField or PointField");
            }
        }

        @Override
        public Comparable bitsToValue(long bits) {
            return new Date(bits);
        }

        @Override
        public String formatValue(Comparable val) {
            return ((Date)val).toInstant().toString();
        }

        @Override
        protected Date parseStr(String rawval) {
            return DateMathParser.parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Comparable value, String gap) throws ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow((Date)value);
            return dmp.parseMath(gap);
        }
    }

    private static class LongCalc
    extends Calc {
        public LongCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Long parseStr(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Comparable value, String gap) {
            return new Long(((Number)((Object)value)).longValue() + Long.parseLong(gap));
        }
    }

    private static class IntCalc
    extends Calc {
        public IntCalc(SchemaField f) {
            super(f);
        }

        @Override
        public Comparable bitsToValue(long bits) {
            return Integer.valueOf((int)bits);
        }

        @Override
        protected Integer parseStr(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Comparable value, String gap) {
            return new Integer(((Number)((Object)value)).intValue() + Integer.parseInt(gap));
        }
    }

    private static class DoubleCalc
    extends Calc {
        @Override
        public Comparable bitsToValue(long bits) {
            if (this.field.getType().isPointField() && this.field.multiValued()) {
                return Double.valueOf(NumericUtils.sortableLongToDouble((long)bits));
            }
            return Double.valueOf(Double.longBitsToDouble(bits));
        }

        @Override
        public long bitsToSortableBits(long bits) {
            return NumericUtils.sortableDoubleBits((long)bits);
        }

        public DoubleCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Double parseStr(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Comparable value, String gap) {
            return new Double(((Number)((Object)value)).doubleValue() + Double.parseDouble(gap));
        }
    }

    private static class FloatCalc
    extends Calc {
        @Override
        public Comparable bitsToValue(long bits) {
            if (this.field.getType().isPointField() && this.field.multiValued()) {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)bits)));
            }
            return Float.valueOf(Float.intBitsToFloat((int)bits));
        }

        @Override
        public long bitsToSortableBits(long bits) {
            return NumericUtils.sortableDoubleBits((long)bits);
        }

        public FloatCalc(SchemaField f) {
            super(f);
        }

        @Override
        protected Float parseStr(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Comparable value, String gap) {
            return new Float(((Number)((Object)value)).floatValue() + Float.parseFloat(gap));
        }
    }

    static abstract class Calc {
        protected final SchemaField field;

        public Calc(SchemaField field) {
            this.field = field;
        }

        public Comparable bitsToValue(long bits) {
            return Long.valueOf(bits);
        }

        public long bitsToSortableBits(long bits) {
            return bits;
        }

        public Object buildRangeLabel(Comparable low) {
            return low;
        }

        public String formatValue(Comparable val) {
            return val.toString();
        }

        public final Comparable getValue(String rawval) {
            try {
                return this.parseStr(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract Comparable parseStr(String var1) throws ParseException;

        public final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected Object parseGap(String rawval) throws ParseException {
            return this.parseStr(rawval);
        }

        public final Comparable addGap(Comparable value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract Comparable parseAndAddGap(Comparable var1, String var2) throws ParseException;
    }

    private static class Range {
        Object label;
        Comparable low;
        Comparable high;
        boolean includeLower;
        boolean includeUpper;

        public Range(Object label, Comparable low, Comparable high, boolean includeLower, boolean includeUpper) {
            this.label = label;
            this.low = low;
            this.high = high;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
        }
    }
}

